# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 818-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55399);
 script_bugtraq_id(14561);
 script_cve_id("CVE-2005-2101");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 818-1 (kdeedu)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to kdeedu
announced via advisory DSA 818-1.

Javier Fernandez-Sanguino Pena discoverd that langen2kvhtml from the
kvoctrain package from the kdeedu suite  creates temporary files in an
insecure fashion.  This leaves them open for symlink attacks.

The old stable distribution (woody) is not affected by these problems.

For the stable distribution (sarge) these problems have been fixed in
version 3.3.2-3.sarge.1.

For the unstable distribution (sid) these problems have been fixed in
version 3.4.2-1.

We recommend that you upgrade your kvoctrain package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20818-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 818-1 (kdeedu)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kdeedu-data", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdeedu-doc-html", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdeedu", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"klettres-data", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kstars-data", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kalzium", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kbruch", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"keduca", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"khangman", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kig", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kiten", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"klatin", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"klettres", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kmessedwords", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kmplot", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kpercentage", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kstars", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ktouch", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kturtle", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kverbos", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kvoctrain", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kwordquiz", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkdeedu-dev", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkdeedu1", ver:"3.3.2-3.sarge.1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
