# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 545-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53235);
 script_bugtraq_id(11183);
 script_cve_id("CVE-2004-0558");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 545-1 (cupsys)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to cupsys
announced via advisory DSA 545-1.

Alvaro Martinez Echevarria discovered a problem in CUPS, the Common
UNIX Printing System.  An attacker can easily disable browsing in CUPS
by sending a specially crafted UDP datagram to port 631 where cupsd is
running.

For the stable distribution (woody) this problem has been fixed in
version 1.1.14-5woody6.

For the unstable distribution (sid) this problem has been fixed in
version cupsys_1.1.20final+rc1-6.

We recommend that you upgrade your cups packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20545-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 545-1 (cupsys)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cupsys", ver:"1.1.14-5woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-bsd", ver:"1.1.14-5woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-client", ver:"1.1.14-5woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-pstoraster", ver:"1.1.14-5woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys2", ver:"1.1.14-5woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys2-dev", ver:"1.1.14-5woody6", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
