# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 526-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53217);
 script_cve_id("CVE-2004-0582", "CVE-2004-0583");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 526-1 (webmin)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to webmin
announced via advisory DSA 526-1.

Two vulnerabilities were discovered in webmin:

CVE-2004-0582: Unknown vulnerability in Webmin 1.140 allows remote
attackers to bypass access control rules and gain read access to
configuration information for a module.

CVE-2004-0583: The account lockout functionality in (1) Webmin 1.140
and (2) Usermin 1.070 does not parse certain character strings, which
allows remote attackers to conduct a brute force attack to guess user
IDs and passwords.

For the current stable distribution (woody), these problems have been
fixed in version 0.94-7woody2.

For the unstable distribution (sid), these problems have been fixed in
version 1.150-1.

We recommend that you update your webmin package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20526-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 526-1 (webmin)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"webmin-apache", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-bind8", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-burner", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-cluster-software", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-cluster-useradmin", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-core", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-cpan", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-dhcpd", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-exports", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-fetchmail", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-heartbeat", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-inetd", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-jabber", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-lpadmin", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-mon", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-mysql", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-nis", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-postfix", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-postgresql", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-ppp", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-qmailadmin", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-quota", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-raid", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-samba", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-sendmail", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-software", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-squid", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-sshd", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-ssl", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-status", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-stunnel", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-wuftpd", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-xinetd", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-grub", ver:"0.94-7woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
