# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 215-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53739);
 script_cve_id("CVE-2002-0379");
 script_bugtraq_id(4713);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 215-1 (cyrus-imapd)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to cyrus-imapd
announced via advisory DSA 215-1.

Timo Sirainen discovered a buffer overflow in the Cyrus IMAP server,
which could be exploited by a remote attacker prior to logging in.  A
malicious user could craft a request to run commands on the server under
the UID and GID of the cyrus server.

For the current stable distribution (woody) this problem has been
fixed in version 1.5.19-9.1.

For the old stable distribution (potato) this problem has been fixed
in version 1.5.19-2.2.

For the current unstable distribution (sid) this problem has been
fixed in version 1.5.19-9.10.  The cyrus21-imapd packages are not
vulnerable

We recommend that you upgrade your cyrus-imapd package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20215-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 215-1 (cyrus-imapd)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cyrus-admin", ver:"1.5.19-2.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-common", ver:"1.5.19-2.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-dev", ver:"1.5.19-2.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-imapd", ver:"1.5.19-2.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-nntp", ver:"1.5.19-2.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-pop3d", ver:"1.5.19-2.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-admin", ver:"1.5.19-9.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-common", ver:"1.5.19-9.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-dev", ver:"1.5.19-9.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-imapd", ver:"1.5.19-9.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-nntp", ver:"1.5.19-9.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-pop3d", ver:"1.5.19-9.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
