# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1718-1 (boinc)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63334);
 script_cve_id("CVE-2009-0126");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1718-1 (boinc)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to boinc
announced via advisory DSA 1718-1.

It was discovered that the core client for the BOINC distributed
computing infrastructure performs incorrect validation of the return
values of OpenSSL's RSA functions.

For the stable distribution (etch), this problem has been fixed in
version 5.4.11-4+etch1.

For the upcoming stable distribution (lenny), this problem has been
fixed in version 6.2.14-3.

For the unstable distribution (sid), this problem has been fixed in
version 6.2.14-3.

We recommend that you upgrade your boinc packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201718-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1718-1 (boinc)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"boinc-manager", ver:"5.4.11-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"boinc-client", ver:"5.4.11-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"boinc-dev", ver:"5.4.11-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
