# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1703-1 (bind9)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63150);
 script_cve_id("CVE-2009-0025");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1703-1 (bind9)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to bind9
announced via advisory DSA 1703-1.

It was discovered that BIND, an implementation of the DNS protocol
suite, does not properly check the result of an OpenSSL function which
is used to verify DSA cryptographic signatures.  As a result,
incorrect DNS resource records in zones protected by DNSSEC could be
accepted as genuine.

For the stable distribution (etch), this problem has been fixed in
version 9.3.4-2etch4.

For the unstable distribution (sid) and the testing distribution
(lenny), this problem will be fixed soon.

We recommend that you upgrade your BIND packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201703-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1703-1 (bind9)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"bind9-doc", ver:"9.3.4-2etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lwresd", ver:"9.3.4-2etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libbind9-0", ver:"9.3.4-2etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libisccfg1", ver:"9.3.4-2etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libisccc0", ver:"9.3.4-2etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libisc11", ver:"9.3.4-2etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bind9", ver:"9.3.4-2etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liblwres9", ver:"9.3.4-2etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdns22", ver:"9.3.4-2etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bind9-host", ver:"9.3.4-2etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libbind-dev", ver:"9.3.4-2etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dnsutils", ver:"9.3.4-2etch4", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
