# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1680-1 (clamav)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(62842);
 script_cve_id("CVE-2008-5050", "CVE-2008-5314");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1680-1 (clamav)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to clamav
announced via advisory DSA 1680-1.

Moritz Jodeit discovered that ClamAV, an anti-virus solution, suffers
from an off-by-one-error in its VBA project file processing, leading to
a heap-based buffer overflow and potentially arbitrary code execution
(CVE-2008-5050).

Ilja van Sprundel discovered that ClamAV contains a denial of service
condition in its JPEG file processing because it does not limit the
recursion depth when processing JPEG thumbnails (CVE-2008-5314).

For the stable distribution (etch), these problems have been fixed in
version 0.90.1dfsg-4etch16.

For the unstable distribution (sid), these problems have been fixed in
version 0.94.dfsg.2-1.

The testing distribution (lenny) will be fixed soon.

We recommend that you upgrade your clamav packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201680-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1680-1 (clamav)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"clamav-base", ver:"0.90.1dfsg-4etch16", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-docs", ver:"0.90.1dfsg-4etch16", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-testfiles", ver:"0.90.1dfsg-4etch16", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav2", ver:"0.90.1dfsg-4etch16", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-daemon", ver:"0.90.1dfsg-4etch16", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-freshclam", ver:"0.90.1dfsg-4etch16", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav-dev", ver:"0.90.1dfsg-4etch16", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-dbg", ver:"0.90.1dfsg-4etch16", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-milter", ver:"0.90.1dfsg-4etch16", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav", ver:"0.90.1dfsg-4etch16", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
