# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1570-1 (kazehakase)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60938);
 script_cve_id("CVE-2006-7227", "CVE-2006-7228", "CVE-2006-7230", "CVE-2007-1659", "CVE-2007-1660", "CVE-2007-1661", "CVE-2007-1662", "CVE-2007-4766", "CVE-2007-4767", "CVE-2007-4768");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1570-1 (kazehakase)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to kazehakase
announced via advisory DSA 1570-1.

Andrews Salomon reported that kazehakase, a GTK+-base web browser that
allows pluggable rendering engines, contained an embedded copy of the
PCRE library in its source tree which was compiled in and used in preference
to the system-wide version of this library.

The PCRE library has been updated to fix the security issues reported
against it in previous Debian Security Advisories.  This update ensures that
kazehakase  uses that supported library, and not its own embedded and
insecure version.

For the stable distribution (etch), this problem has been fixed in version
0.4.2-1etch1.

We recommend that you upgrade your kazehakase package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201570-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1570-1 (kazehakase)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kazehakase", ver:"0.4.2-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
