# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1491-1 (tk8.4)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60366);
 script_cve_id("CVE-2008-0553");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1491-1 (tk8.4)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to tk8.4
announced via advisory DSA 1491-1.

It was discovered that a buffer overflow in the GIF image parsing code
of Tk, a cross-platform graphical toolkit, could lead to denial of
service and potentially the execution of arbitrary code.

For the stable distribution (etch), this problem has been fixed in
version 8.4.12-1etch2.

For the old stable distribution (sarge), this problem has been fixed in
version 8.4.9-1sarge2.

We recommend that you upgrade your tk8.4 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201491-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1491-1 (tk8.4)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"tk8.4-doc", ver:"8.4.9-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tk8.4-dev", ver:"8.4.9-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tk8.4", ver:"8.4.9-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tk8.4-doc", ver:"8.4.12-1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tk8.4-dev", ver:"8.4.12-1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tk8.4", ver:"8.4.12-1etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
