# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1483-1 (net-snmp)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60359);
 script_cve_id("CVE-2007-5846");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1483-1 (net-snmp)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to net-snmp
announced via advisory DSA 1483-1.

The SNMP agent (snmp_agent.c) in net-snmp before 5.4.1 allows remote
attackers to cause a denial of service (CPU and memory consumption)
via a GETBULK request with a large max-repeaters value.

For the stable distribution (etch), this problem has been fixed in
version 5.2.3-7etch2

For the unstable and testing distributions (sid and lenny,
respectively), this problem has been fixed in version 5.4.1~dfsg-2

We recommend that you upgrade your net-snmp package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201483-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1483-1 (net-snmp)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"tkmib", ver:"5.2.3-7etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsnmp-base", ver:"5.2.3-7etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"snmpd", ver:"5.2.3-7etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"snmp", ver:"5.2.3-7etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsnmp9", ver:"5.2.3-7etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsnmp9-dev", ver:"5.2.3-7etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsnmp-perl", ver:"5.2.3-7etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
