# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1471-1 (libvorbis)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60215);
 script_cve_id("CVE-2007-3106", "CVE-2007-4029", "CVE-2007-4066");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1471-1 (libvorbis)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to libvorbis
announced via advisory DSA 1471-1.

Several vulnerabilities were found in the the Vorbis General Audio
Compression Codec, which may lead to denial of service or the
execution of arbitrary code, if a user is tricked into opening to
a malformed Ogg Audio file with an application linked against
libvorbis.

For the unstable distribution (sid), these problems have been fixed in
version 1.2.0.dfsg-1.

For the stable distribution (etch), these problems have been fixed in
version 1.1.2.dfsg-1.3.

For the old stable distribution (sarge), these problems have been fixed
in version 1.1.0-2.

We recommend that you upgrade your libvorbis packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201471-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1471-1 (libvorbis)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libvorbis-dev", ver:"1.1.0-2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbisenc2", ver:"1.1.0-2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbis0a", ver:"1.1.0-2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbisfile3", ver:"1.1.0-2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbisfile3", ver:"1.1.2.dfsg-1.3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbis0a", ver:"1.1.2.dfsg-1.3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbisenc2", ver:"1.1.2.dfsg-1.3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbis-dev", ver:"1.1.2.dfsg-1.3", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
