# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 144-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53580);
 script_bugtraq_id(5260);
 script_cve_id("CVE-2002-0818");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 144-1 (wwwoffle)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to wwwoffle
announced via advisory DSA 144-1.

A problem with wwwoffle has been discovered.  The web proxy didn't
handle input data with negative Content-Length settings properly which
causes the processing child to crash.  It is at this time not obvious
how this can lead to an exploitable vulnerability; however, it's better
to be safe than sorry, so here's an update.

Additionally, in the woody version empty passwords will be treated as
wrong when trying to authenticate.  In the woody version we also
replaced CanonicaliseHost() with the latest routine from 2.7d, offered
by upstream.  This stops bad IPv6 format IP addresses in URLs from
causing problems (memory overwriting, potential exploits).

This problem has been fixed in version 2.5c-10.4 for the old stable
distribution (potato), in version 2.7a-1.2 for the current stable
distribution (woody) and in version 2.7d-1 for the unstable
distribution (sid).

We recommend that you upgrade your wwwoffle packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20144-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 144-1 (wwwoffle)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"wwwoffle", ver:"2.5c-10.4", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wwwoffle", ver:"2.7a-1.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
