# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1431-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(60010);
 script_cve_id("CVE-2007-6183");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1431-1 (ruby-gnome2)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to ruby-gnome2
announced via advisory DSA 1431-1.

It was discovered that ruby-gnome2, GNOME-related bindings for the Ruby
language, didn't properly sanitize input prior to constructing dialogs.
This could allow for the execution of arbitary code if untrusted input
is displayed within a dialog.

For the stable distribution (etch), this problem has been fixed in version
0.15.0-1.1etch1.

For the old stable distribution (sarge), this problem has been fixed in
version 0.12.0-2sarge1.

For the unstable distribution (sid), this problem has been fixed in
version 0.16.0-10.

We recommend that you upgrade your ruby-gnome2 package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201431-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1431-1 (ruby-gnome2)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ruby-gnome2", ver:"0.12.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgda2-ruby", ver:"0.12.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgconf2-ruby", ver:"0.12.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpango1-ruby", ver:"0.12.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgtkglext1-ruby", ver:"0.12.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgtkhtml2-ruby", ver:"0.12.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpanel-applet2-ruby", ver:"0.12.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdk-pixbuf2-ruby", ver:"0.12.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnomecanvas2-ruby", ver:"0.12.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libatk1-ruby", ver:"0.12.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgtksourceview1-ruby", ver:"0.12.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgtk2-ruby", ver:"0.12.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnome2-ruby", ver:"0.12.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnomeprintui2-ruby", ver:"0.12.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libglade2-ruby", ver:"0.12.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"librsvg2-ruby", ver:"0.12.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libart2-ruby", ver:"0.12.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnomeprint2-ruby", ver:"0.12.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libglib2-ruby", ver:"0.12.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgstreamer0.8-ruby", ver:"0.12.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnomevfs2-ruby", ver:"0.12.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby-gnome2", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgtk-mozembed-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpango1-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libatk1-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgda2-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"librsvg2-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libglib2-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgtkhtml2-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdk-pixbuf2-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libglade2-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgstreamer0.8-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnomeprintui2-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgtk2-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnome2-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libart2-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvte-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgconf2-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpanel-applet2-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnomevfs2-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnomecanvas2-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgtkglext1-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnomeprint2-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgtksourceview1-ruby", ver:"0.15.0-1.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
