# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1338-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58470);
 script_cve_id("CVE-2007-3089", "CVE-2007-3656", "CVE-2007-3734", "CVE-2007-3735", "CVE-2007-3736", "CVE-2007-3737", "CVE-2007-3738");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1338-1 (iceweasel)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to iceweasel
announced via advisory DSA 1338-1.

Several remote vulnerabilities have been discovered in the Iceweasel web
browser, an unbranded version of the Firefox browser. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2007-3089

Ronen Zilberman and Michal Zalewski discovered that a timing race
allows the injection of content into about:blank frames.

CVE-2007-3656

Michal Zalewski discovered that same-origin policies for wyciwyg://
documents are insufficiently enforced.

CVE-2007-3734

Bernd Mielke, Boris Zbarsky, David Baron, Daniel Veditz, Jesse Ruderman,
Lukas Loehrer, Martijn Wargers, Mats Palmgren, Olli Pettay, Paul
Nickerson,and Vladimir Sukhoy discovered crashes in the layout engine,
which might allow the execution of arbitrary code.

CVE-2007-3735

Asaf Romano, Jesse Ruderman and Igor Bukanov discovered crashes in the
javascript engine, which might allow the execution of arbitrary code.

CVE-2007-3736

moz_bug_r_a4 discovered that the addEventListener() and setTimeout()
functions allow cross-site scripting.

CVE-2007-3737

moz_bug_r_a4 discovered that a programming error in event handling
allows privilege escalation.

CVE-2007-3738

shutdown and moz_bug_r_a4 discovered that the XPCNativeWrapper allows
the execution of arbitrary code.

The Mozilla products in the oldstable distribution (sarge) are no longer
supported with with security updates. You're strongly encouraged to upgrade to
stable as soon as possible.

For the stable distribution (etch) these problems have been fixed in version
2.0.0.5-0etch1. Builds for alpha and mips are not yet available, they will
be provided later.

For the unstable distribution (sid) these problems have been fixed in version
2.0.0.5-1.

We recommend that you upgrade your iceweasel packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201338-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1338-1 (iceweasel)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"2.0.0.5-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"2.0.0.5-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox", ver:"2.0.0.5-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel-dom-inspector", ver:"2.0.0.5-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-firefox-dom-inspector", ver:"2.0.0.5-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-firefox-gnome-support", ver:"2.0.0.5-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-firefox", ver:"2.0.0.5-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel", ver:"2.0.0.5-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel-dbg", ver:"2.0.0.5-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel-gnome-support", ver:"2.0.0.5-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
