# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1286-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58337);
 script_cve_id("CVE-2007-0005", "CVE-2007-0958", "CVE-2007-1357", "CVE-2007-1592", "CVE-2004-1073");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1286-1 (linux-2.6)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to linux-2.6
announced via advisory DSA 1286-1.

Several local and remote vulnerabilities have been discovered in the Linux
kernel that may lead to a denial of service or the execution of arbitrary
code. The Common Vulnerabilities and Exposures project identifies the
following problems:

CVE-2007-0005

Daniel Roethlisberger discovered two buffer overflows in the cm4040
driver for the Omnikey CardMan 4040 device. A local user or malicious
device could exploit this to execute arbitrary code in kernel space.

CVE-2007-0958

Santosh Eraniose reported a vulnerability that allows local users to read
otherwise unreadable files by triggering a core dump while using PT_INTERP.
This is related to CVE-2004-1073.

CVE-2007-1357

Jean Delvare reported a vulnerability in the appletalk subsystem.
Systems with the appletalk module loaded can be triggered to crash
by other systems on the local network via a malformed frame.

CVE-2007-1592

Masayuki Nakagawa discovered that flow labels were inadvertently
being shared between listening sockets and child sockets. This defect
can be exploited by local users to cause a DoS (Oops).

This problem has been fixed in the stable distribution in version
2.6.18.dfsg.1-12etch1.

The following matrix lists additional packages that were rebuilt for
compatibility with or to take advantage of this update:

Debian 4.0 (etch)
fai-kernels                 1.17etch1
user-mode-linux             2.6.18-1um-2etch1

We recommend that you upgrade your kernel package immediately and reboot

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201286-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1286-1 (linux-2.6)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"linux-doc-2.6.18", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-manual-2.6.18", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-patch-debian-2.6.18", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-source-2.6.18", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-support-2.6.18-4", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-tree-2.6.18", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-all", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-all-alpha", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-alpha-generic", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-alpha-legacy", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-alpha-smp", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-vserver", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-vserver-alpha", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-alpha-generic", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-alpha-legacy", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-alpha-smp", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-vserver-alpha", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-all-amd64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-amd64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-vserver-amd64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-xen", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-xen-amd64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-xen-vserver", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-xen-vserver-amd64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-amd64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-vserver-amd64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-xen-amd64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-xen-vserver-amd64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-modules-2.6.18-4-xen-amd64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-modules-2.6.18-4-xen-vserver-amd64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xen-linux-system-2.6.18-4-xen-amd64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xen-linux-system-2.6.18-4-xen-vserver-amd64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fai-kernels", ver:"1.17etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-all-arm", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-footbridge", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-iop32x", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-ixp4xx", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-rpc", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-s3c2410", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-footbridge", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-iop32x", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-ixp4xx", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-rpc", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-s3c2410", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-all-hppa", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-parisc", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-parisc-smp", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-parisc64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-parisc64-smp", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-parisc", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-parisc-smp", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-parisc64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-parisc64-smp", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-486", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-686", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-686-bigmem", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-all-i386", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-k7", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-vserver-686", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-vserver-k7", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-xen-686", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-xen-vserver-686", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-486", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-686", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-686-bigmem", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-k7", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-vserver-686", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-vserver-k7", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-xen-686", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-xen-vserver-686", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-modules-2.6.18-4-xen-686", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-modules-2.6.18-4-xen-vserver-686", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xen-linux-system-2.6.18-4-xen-686", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xen-linux-system-2.6.18-4-xen-vserver-686", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"user-mode-linux", ver:"2.6.18-1um-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-all-ia64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-itanium", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-mckinley", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-itanium", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-mckinley", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-all-powerpc", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-powerpc", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-powerpc-miboot", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-powerpc-smp", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-powerpc64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-prep", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-vserver-powerpc", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-vserver-powerpc64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-powerpc", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-powerpc-miboot", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-powerpc-smp", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-powerpc64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-prep", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-vserver-powerpc", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-vserver-powerpc64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-all-s390", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-s390", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-s390x", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-vserver-s390x", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-s390", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-s390-tape", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-s390x", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-vserver-s390x", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-all-sparc", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-sparc32", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-sparc64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-sparc64-smp", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-4-vserver-sparc64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-sparc32", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-sparc64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-sparc64-smp", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-4-vserver-sparc64", ver:"2.6.18.dfsg.1-12etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
