# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1264-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58119);
 script_cve_id("CVE-2007-0906", "CVE-2007-0907", "CVE-2006-0908", "CVE-2007-0909", "CVE-2007-0910", "CVE-2007-0988", "CVE-2007-0908");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1264-1 (php4)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to php4
announced via advisory DSA 1264-1.

Several remote vulnerabilities have been discovered in PHP, a server-side,
HTML-embedded scripting language, which may lead to the execution of
arbitrary code. The Common Vulnerabilities and Exposures project identifies
the following problems:

CVE-2007-0906

It was discovered that an integer overflow in the str_replace()
function could lead to the execution of arbitrary code.

CVE-2007-0907

It was discovered that a buffer underflow in the sapi_header_op()
function could crash the PHP interpreter.

CVE-2007-0908

Stefan Esser discovered that a programming error in the wddx
extension allows information disclosure.

CVE-2007-0909

It was discovered that a format string vulnerability in the
odbc_result_all() functions allows the execution of arbitrary code.

CVE-2007-0910

It was discovered that super-global variables could be overwritten
with session data.

CVE-2007-0988

Stefan Esser discovered that the zend_hash_init() function could
be tricked into an endless loop, allowing denial of service through
resource consumption until a timeout is triggered.

For the stable distribution (sarge) these problems have been fixed in
version 4:4.3.10-19.

For the unstable distribution (sid) these problems have been fixed in
version 6:4.4.4-9 of php4 and version 5.2.0-9 of php5.

We recommend that you upgrade your php4 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201264-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1264-1 (php4)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"php4-pear", ver:"4.3.10-19", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4", ver:"4.3.10-19", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-php4", ver:"4.3.10-19", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php4", ver:"4.3.10-19", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi", ver:"4.3.10-19", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cli", ver:"4.3.10-19", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-common", ver:"4.3.10-19", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-curl", ver:"4.3.10-19", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-dev", ver:"4.3.10-19", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-domxml", ver:"4.3.10-19", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-gd", ver:"4.3.10-19", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-imap", ver:"4.3.10-19", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-ldap", ver:"4.3.10-19", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mcal", ver:"4.3.10-19", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mhash", ver:"4.3.10-19", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mysql", ver:"4.3.10-19", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-odbc", ver:"4.3.10-19", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-recode", ver:"4.3.10-19", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-snmp", ver:"4.3.10-19", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-sybase", ver:"4.3.10-19", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-xslt", ver:"4.3.10-19", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
