# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1184-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57408);
 script_cve_id("CVE-2004-2660", "CVE-2005-4798", "CVE-2006-1052", "CVE-2006-1343", "CVE-2006-1528", "CVE-2006-1855", "CVE-2006-1856", "CVE-2006-2444", "CVE-2006-2446", "CVE-2006-2935", "CVE-2006-2936", "CVE-2006-3468", "CVE-2006-3745", "CVE-2006-4093", "CVE-2006-4145", "CVE-2006-4535");
 script_bugtraq_id(17203,17830,18081,18099,18101,18105,18847,19033,19396);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1184-1 (kernel-source-2.6.8)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to kernel-source-2.6.8
announced via advisory DSA 1184-1. For details, please visit
the referenced security advisories.

Solution:
The following matrix explains which kernel version for which
architecture fixes the problem mentioned above:

stable (sarge)
Source                           2.6.8-16sarge5
Alpha architecture               2.6.8-16sarge5
AMD64 architecture               2.6.8-16sarge5
HP Precision architecture        2.6.8-6sarge5
Intel IA-32 architecture         2.6.8-16sarge5
Intel IA-64 architecture         2.6.8-14sarge5
Motorola 680x0 architecture      2.6.8-4sarge5
PowerPC architecture             2.6.8-12sarge5
IBM S/390                        2.6.8-5sarge5
Sun Sparc architecture           2.6.8-15sarge5
FAI                              1.9.1sarge4

For the unstable distribution (sid) these problems have been fixed in
version 2.6.18-1.

We recommend that you upgrade your kernel package and reboot.

https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201184-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1184-1 (kernel-source-2.6.8)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kernel-doc-2.6.8", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-patch-debian-2.6.8", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-source-2.6.8", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-tree-2.6.8", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-2", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-2-generic", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-2-smp", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-3", ver:"2.6.8-15sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-3-generic", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-3-smp", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-2-generic", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-2-smp", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-generic", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-smp", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-11", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-11-amd64-generic", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-11-amd64-k8", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-11-amd64-k8-smp", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-11-em64t-p4", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-11-em64t-p4-smp", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-12", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-12-amd64-generic", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-12-amd64-k8", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-12-amd64-k8-smp", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-12-em64t-p4", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-12-em64t-p4-smp", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-11-amd64-generic", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-11-amd64-k8", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-11-amd64-k8-smp", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-11-em64t-p4", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-11-em64t-p4-smp", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-12-amd64-generic", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-12-amd64-k8", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-12-amd64-k8-smp", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-12-em64t-p4", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-12-em64t-p4-smp", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-2-32", ver:"2.6.8-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-2-32-smp", ver:"2.6.8-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-2-64", ver:"2.6.8-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-2-64-smp", ver:"2.6.8-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-3-32", ver:"2.6.8-6sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-3-32-smp", ver:"2.6.8-6sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-3-64", ver:"2.6.8-6sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-3-64-smp", ver:"2.6.8-6sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-2-32", ver:"2.6.8-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-2-32-smp", ver:"2.6.8-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-2-64", ver:"2.6.8-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-2-64-smp", ver:"2.6.8-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-32", ver:"2.6.8-6sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-32-smp", ver:"2.6.8-6sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-64", ver:"2.6.8-6sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-64-smp", ver:"2.6.8-6sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-2-386", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-2-686", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-2-686-smp", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-2-k7", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-2-k7-smp", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-3-386", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-3-686", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-3-686-smp", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-3-k7", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-3-k7-smp", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-2-386", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-2-686", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-2-686-smp", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-2-k7", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-2-k7-smp", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-386", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-686", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-686-smp", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-k7", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-k7-smp", ver:"2.6.8-16sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fai-kernels", ver:"1.9.1sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6-itanium", ver:"2.6.8-14sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6-itanium-smp", ver:"2.6.8-14sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6-mckinley", ver:"2.6.8-14sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6-mckinley-smp", ver:"2.6.8-14sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-2-itanium", ver:"2.6.8-14sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-2-itanium-smp", ver:"2.6.8-14sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-2-mckinley", ver:"2.6.8-14sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-2-mckinley-smp", ver:"2.6.8-14sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-3-itanium", ver:"2.6.8-14sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-3-itanium-smp", ver:"2.6.8-14sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-3-mckinley", ver:"2.6.8-14sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-3-mckinley-smp", ver:"2.6.8-14sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6-itanium", ver:"2.6.8-14sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6-itanium-smp", ver:"2.6.8-14sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6-mckinley", ver:"2.6.8-14sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6-mckinley-smp", ver:"2.6.8-14sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-2-itanium", ver:"2.6.8-14sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-2-itanium-smp", ver:"2.6.8-14sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-2-mckinley", ver:"2.6.8-14sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-2-mckinley-smp", ver:"2.6.8-14sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-itanium", ver:"2.6.8-14sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-itanium-smp", ver:"2.6.8-14sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-mckinley", ver:"2.6.8-14sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-mckinley-smp", ver:"2.6.8-14sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-amiga", ver:"2.6.8-4sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-atari", ver:"2.6.8-4sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-bvme6000", ver:"2.6.8-4sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-hp", ver:"2.6.8-4sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-mac", ver:"2.6.8-4sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-mvme147", ver:"2.6.8-4sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-mvme16x", ver:"2.6.8-4sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-q40", ver:"2.6.8-4sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-sun3", ver:"2.6.8-4sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-build-2.6.8-3-power3", ver:"2.6.8-12sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-build-2.6.8-3-power3-smp", ver:"2.6.8-12sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-build-2.6.8-3-power4", ver:"2.6.8-12sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-build-2.6.8-3-power4-smp", ver:"2.6.8-12sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-build-2.6.8-3-powerpc", ver:"2.6.8-12sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-build-2.6.8-3-powerpc-smp", ver:"2.6.8-12sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-build-2.6.8-power3", ver:"2.6.8-12sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-build-2.6.8-power3-smp", ver:"2.6.8-12sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-build-2.6.8-power4", ver:"2.6.8-12sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-build-2.6.8-power4-smp", ver:"2.6.8-12sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-build-2.6.8-powerpc", ver:"2.6.8-12sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-build-2.6.8-powerpc-smp", ver:"2.6.8-12sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8", ver:"2.6.8-12sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-power3", ver:"2.6.8-12sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-power3-smp", ver:"2.6.8-12sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-power4", ver:"2.6.8-12sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-power4-smp", ver:"2.6.8-12sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-powerpc", ver:"2.6.8-12sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-powerpc-smp", ver:"2.6.8-12sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-power3", ver:"2.6.8-12sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-power3-smp", ver:"2.6.8-12sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-power4", ver:"2.6.8-12sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-power4-smp", ver:"2.6.8-12sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-powerpc", ver:"2.6.8-12sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-powerpc-smp", ver:"2.6.8-12sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-build-2.6.8-2", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-build-2.6.8-3", ver:"2.6.8-15sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-2-sparc32", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-2-sparc64", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-2-sparc64-smp", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-3-sparc32", ver:"2.6.8-15sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-3-sparc64", ver:"2.6.8-15sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-3-sparc64-smp", ver:"2.6.8-15sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-2-sparc32", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-2-sparc64", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-2-sparc64-smp", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-sparc32", ver:"2.6.8-15sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-sparc64", ver:"2.6.8-15sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-3-sparc64-smp", ver:"2.6.8-15sarge5", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
