# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 075-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53824);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 075-1 (netkit-telnet-ssl)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to netkit-telnet-ssl
announced via advisory DSA 075-1.

The telnet daemon contained in the netkit-telnet-ssl_0.16.3-1 package in
the 'stable' (potato) distribution of Debian GNU/Linux is vulnerable to an
exploitable overflow in its output handling.
The original bug was found by <scut@nb.in-berlin.de>, and announced to
bugtraq on Jul 18 2001. At that time, netkit-telnet versions after 0.14 were
not believed to be vulnerable.
On Aug 10 2001, zen-parse posted an advisory based on the same problem, for
all netkit-telnet versions below 0.17.
More details can be found on http://www.securityfocus.com/archive/1/203000 .
As Debian uses the 'telnetd' user to run in.telnetd, this is not a remote
root compromise on Debian systems; the 'telnetd' user can be compromised.

We strongly advise you update your netkit-telnet-ssl packages to the versions
listed below.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20075-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 075-1 (netkit-telnet-ssl)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ssltelnet", ver:"0.16.3-1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"telnet-ssl", ver:"0.16.3-1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"telnetd-ssl", ver:"0.16.3-1.1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
