# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 009-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53773);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 009-1 (stunnel)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to stunnel
announced via advisory DSA 009-1.

Lez discovered a format string problem in stunnel (a tool to create
Universal SSL tunnel for other network daemons). Brian Hatch
responded by stating he was already preparing a new release with
multiple security fixes:

1. the PRNG (pseudo-random generated) was not seeded correctly.
This only affects operation on operating systems without a
secure random generator (like Linux)
2. Pid files were not created securely, making stunnel vulnerable
to a symlink attack
3. There was an insecure syslog() call which could be exploited if
the user could manage to insert text into the logged text. At
least one way to exploit this using faked identd responses was
demonstrated by Lez.

These problems have been fixed in version 3.10-0potato1.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20009-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 009-1 (stunnel)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"stunnel", ver:"3.10-0potato1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
