# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:1061 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64021);
 script_cve_id("CVE-2009-0946");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:1061";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates to FreeType announced in
advisory RHSA-2009:1061.

Tavis Ormandy of the Google Security Team discovered several integer
overflow flaws in the FreeType 2 font engine. If a user loaded a
carefully-crafted font file with an application linked against FreeType 2,
it could cause the application to crash or, possibly, execute arbitrary
code with the privileges of the user running the application.
(CVE-2009-0946)

Users are advised to upgrade to these updated packages, which contain a
backported patch to correct these issues. The X server must be restarted
(log out, then log back in) for this update to take effect.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-1061.html
http://www.redhat.com/security/updates/classification/#important

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:1061";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"freetype", rpm:"freetype~2.2.1~21.el5_3", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"freetype-debuginfo", rpm:"freetype-debuginfo~2.2.1~21.el5_3", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"freetype-demos", rpm:"freetype-demos~2.2.1~21.el5_3", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"freetype-devel", rpm:"freetype-devel~2.2.1~21.el5_3", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
