# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0437 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63867);
 script_cve_id("CVE-2009-0652", "CVE-2009-1303", "CVE-2009-1305", "CVE-2009-1306", "CVE-2009-1307", "CVE-2009-1309", "CVE-2009-1311", "CVE-2009-1312");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0437";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0437.

SeaMonkey is an open source Web browser, email and newsgroup client, IRC
chat client, and HTML editor.

Several flaws were found in the processing of malformed web content. A web
page containing malicious content could cause SeaMonkey to crash or,
potentially, execute arbitrary code as the user running SeaMonkey.
(CVE-2009-1303, CVE-2009-1305)

Several flaws were found in the way malformed web content was processed. A
web page containing malicious content could execute arbitrary JavaScript in
the context of the site, possibly presenting misleading data to a user, or
stealing sensitive information such as login credentials. (CVE-2009-0652,
CVE-2009-1306, CVE-2009-1307, CVE-2009-1309, CVE-2009-1312)

A flaw was found in the way SeaMonkey saved certain web pages to a local
file. If a user saved the inner frame of a web page containing POST data,
the POST data could be revealed to the inner frame, possibly surrendering
sensitive information such as login credentials. (CVE-2009-1311)

All SeaMonkey users should upgrade to these updated packages, which correct
these issues. After installing the update, SeaMonkey must be restarted for
the changes to take effect.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0437.html
http://www.redhat.com/security/updates/classification/#critical

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0437";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"seamonkey", rpm:"seamonkey~1.0.9~0.33.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-chat", rpm:"seamonkey-chat~1.0.9~0.33.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-devel", rpm:"seamonkey-devel~1.0.9~0.33.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-dom-inspector", rpm:"seamonkey-dom-inspector~1.0.9~0.33.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-js-debugger", rpm:"seamonkey-js-debugger~1.0.9~0.33.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-mail", rpm:"seamonkey-mail~1.0.9~0.33.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-nspr", rpm:"seamonkey-nspr~1.0.9~0.33.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-nspr-devel", rpm:"seamonkey-nspr-devel~1.0.9~0.33.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-nss", rpm:"seamonkey-nss~1.0.9~0.33.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-nss-devel", rpm:"seamonkey-nss-devel~1.0.9~0.33.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey", rpm:"seamonkey~1.0.9~0.37.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-chat", rpm:"seamonkey-chat~1.0.9~0.37.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-debuginfo", rpm:"seamonkey-debuginfo~1.0.9~0.37.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-devel", rpm:"seamonkey-devel~1.0.9~0.37.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-dom-inspector", rpm:"seamonkey-dom-inspector~1.0.9~0.37.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-js-debugger", rpm:"seamonkey-js-debugger~1.0.9~0.37.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-mail", rpm:"seamonkey-mail~1.0.9~0.37.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-nspr", rpm:"seamonkey-nspr~1.0.9~0.37.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-nspr-devel", rpm:"seamonkey-nspr-devel~1.0.9~0.37.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-nss", rpm:"seamonkey-nss~1.0.9~0.37.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-nss-devel", rpm:"seamonkey-nss-devel~1.0.9~0.37.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey", rpm:"seamonkey~1.0.9~41.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-chat", rpm:"seamonkey-chat~1.0.9~41.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-debuginfo", rpm:"seamonkey-debuginfo~1.0.9~41.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-devel", rpm:"seamonkey-devel~1.0.9~41.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-dom-inspector", rpm:"seamonkey-dom-inspector~1.0.9~41.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-js-debugger", rpm:"seamonkey-js-debugger~1.0.9~41.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-mail", rpm:"seamonkey-mail~1.0.9~41.el4", rls:"RHENT_4")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
