# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0398 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63710);
 script_cve_id("CVE-2009-1044", "CVE-2009-1169");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0398";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0398.

SeaMonkey is an open source Web browser, email and newsgroup client, IRC
chat client, and HTML editor.

A memory corruption flaw was discovered in the way SeaMonkey handles XML
files containing an XSLT transform. A remote attacker could use this flaw
to crash SeaMonkey or, potentially, execute arbitrary code as the user
running SeaMonkey. (CVE-2009-1169)

A flaw was discovered in the way SeaMonkey handles certain XUL garbage
collection events. A remote attacker could use this flaw to crash SeaMonkey
or, potentially, execute arbitrary code as the user running SeaMonkey.
(CVE-2009-1044)

All SeaMonkey users should upgrade to these updated packages, which correct
these issues. After installing the update, SeaMonkey must be restarted for
the changes to take effect.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0398.html
http://www.redhat.com/security/updates/classification/#critical

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0398";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"seamonkey", rpm:"seamonkey~1.0.9~0.32.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-chat", rpm:"seamonkey-chat~1.0.9~0.32.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-devel", rpm:"seamonkey-devel~1.0.9~0.32.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-dom-inspector", rpm:"seamonkey-dom-inspector~1.0.9~0.32.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-js-debugger", rpm:"seamonkey-js-debugger~1.0.9~0.32.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-mail", rpm:"seamonkey-mail~1.0.9~0.32.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-nspr", rpm:"seamonkey-nspr~1.0.9~0.32.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-nspr-devel", rpm:"seamonkey-nspr-devel~1.0.9~0.32.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-nss", rpm:"seamonkey-nss~1.0.9~0.32.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-nss-devel", rpm:"seamonkey-nss-devel~1.0.9~0.32.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey", rpm:"seamonkey~1.0.9~0.36.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-chat", rpm:"seamonkey-chat~1.0.9~0.36.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-debuginfo", rpm:"seamonkey-debuginfo~1.0.9~0.36.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-devel", rpm:"seamonkey-devel~1.0.9~0.36.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-dom-inspector", rpm:"seamonkey-dom-inspector~1.0.9~0.36.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-js-debugger", rpm:"seamonkey-js-debugger~1.0.9~0.36.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-mail", rpm:"seamonkey-mail~1.0.9~0.36.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-nspr", rpm:"seamonkey-nspr~1.0.9~0.36.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-nspr-devel", rpm:"seamonkey-nspr-devel~1.0.9~0.36.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-nss", rpm:"seamonkey-nss~1.0.9~0.36.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-nss-devel", rpm:"seamonkey-nss-devel~1.0.9~0.36.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey", rpm:"seamonkey~1.0.9~40.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-chat", rpm:"seamonkey-chat~1.0.9~40.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-debuginfo", rpm:"seamonkey-debuginfo~1.0.9~40.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-devel", rpm:"seamonkey-devel~1.0.9~40.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-dom-inspector", rpm:"seamonkey-dom-inspector~1.0.9~40.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-js-debugger", rpm:"seamonkey-js-debugger~1.0.9~40.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-mail", rpm:"seamonkey-mail~1.0.9~40.el4", rls:"RHENT_4")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
