# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0373 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63643);
 script_cve_id("CVE-2009-0784");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0373";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0373.

SystemTap is an instrumentation infrastructure for systems running version
2.6 of the Linux kernel. SystemTap scripts can collect system operations
data, greatly simplifying information gathering. Collected data can then
assist in performance measuring, functional testing, and performance and
function problem diagnosis.

A race condition was discovered in SystemTap that could allow users in the
stapusr group to elevate privileges to that of members of the stapdev group
(and hence root), bypassing directory confinement restrictions and allowing
them to insert arbitrary SystemTap kernel modules. (CVE-2009-0784)

Note: This issue was only exploitable if another SystemTap kernel module
was placed in the systemtap/ module directory for the currently running
kernel.

Red Hat would like to thank Erik Sjölund for reporting this issue.

SystemTap users should upgrade to these updated packages, which contain a
backported patch to correct this issue.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0373.html
http://www.redhat.com/security/updates/classification/#moderate

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0373";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"systemtap", rpm:"systemtap~0.6.2~2.el4_7", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"systemtap-debuginfo", rpm:"systemtap-debuginfo~0.6.2~2.el4_7", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"systemtap-runtime", rpm:"systemtap-runtime~0.6.2~2.el4_7", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"systemtap-testsuite", rpm:"systemtap-testsuite~0.6.2~2.el4_7", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"systemtap", rpm:"systemtap~0.7.2~3.el5_3", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"systemtap-client", rpm:"systemtap-client~0.7.2~3.el5_3", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"systemtap-debuginfo", rpm:"systemtap-debuginfo~0.7.2~3.el5_3", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"systemtap-runtime", rpm:"systemtap-runtime~0.7.2~3.el5_3", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"systemtap-server", rpm:"systemtap-server~0.7.2~3.el5_3", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"systemtap-testsuite", rpm:"systemtap-testsuite~0.7.2~3.el5_3", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
