# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0355 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63581);
 script_cve_id("CVE-2009-0547", "CVE-2009-0582", "CVE-2009-0587");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0355";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0355.

Evolution is the integrated collection of e-mail, calendaring, contact
management, communications, and personal information management (PIM) tools
for the GNOME desktop environment.

Evolution Data Server provides a unified back-end for applications which
interact with contacts, task and calendar information. Evolution Data
Server was originally developed as a back-end for Evolution, but is now
used by multiple other applications.

Evolution did not properly check the Secure/Multipurpose Internet Mail
Extensions (S/MIME) signatures used for public key encryption and signing
of e-mail messages. An attacker could use this flaw to spoof a signature by
modifying the text of the e-mail message displayed to the user. (CVE-2009-0547)

It was discovered that evolution did not properly validate NTLM (NT LAN
Manager) authentication challenge packets. A malicious server using NTLM
authentication could cause evolution to disclose portions of its memory or
crash during user authentication. (CVE-2009-0582)

Multiple integer overflow flaws which could cause heap-based buffer
overflows were found in the Base64 encoding routines used by evolution and
evolution-data-server. This could cause evolution, or an application using
evolution-data-server, to crash, or, possibly, execute an arbitrary code
when large untrusted data blocks were Base64-encoded. (CVE-2009-0587)

All users of evolution and evolution-data-server are advised to upgrade to
these updated packages, which contain backported patches to correct these
issues. All running instances of evolution and evolution-data-server must
be restarted for the update to take effect.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0355.html
http://www.redhat.com/security/updates/classification/#moderate

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0355";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.0.2~41.el4_7.2", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server", rpm:"evolution-data-server~1.0.2~14.el4_7.1", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server-debuginfo", rpm:"evolution-data-server-debuginfo~1.0.2~14.el4_7.1", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server-devel", rpm:"evolution-data-server-devel~1.0.2~14.el4_7.1", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-debuginfo", rpm:"evolution-debuginfo~2.0.2~41.el4_7.2", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.0.2~41.el4_7.2", rls:"RHENT_4")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
