#!/usr/bin/python

import unittest
import commands
from test.unit_test import *

## Create Test Suite
gentoo_test_suite = unittest.makeSuite(test_gentoo.GentooParserTestCase ,'test')
hpux_test_suite = unittest.makeSuite(test_hpux.HPUXParserTestCase ,'test')
mandriva_test_suite = unittest.makeSuite(test_mandriva.MandrivaParserTestCase ,'test')
ubuntu_test_suite = unittest.makeSuite(test_ubuntu.UbuntuParserTestCase ,'test')
debian_test_suite = unittest.makeSuite(test_debian.DebianParserTestCase ,'test')
centos_test_suite = unittest.makeSuite(test_centos.CentOSParserTestCase ,'test')
redhat_test_suite = unittest.makeSuite(test_redhat.RedhatParserTestCase ,'test')
fedora_test_suite = unittest.makeSuite(test_fedora.FedoraParserTestCase ,'test')
suse_test_suite = unittest.makeSuite(test_suse.SuseParserTestCase ,'test')
utils_test_suite = unittest.makeSuite(test_utils.UtilsTestCase ,'test')
id_record_test_suite = unittest.makeSuite(test_record_id.IDRecorderTestCase ,'test')
sanity_test_suite = unittest.makeSuite(test_sanity_test.SanityTestCase ,'test')
generate_test_suite = unittest.makeSuite(test_generate_script.GenerateScriptTestCase ,'test')
mantisreporter_test_suite = unittest.makeSuite(test_mantisreporter.MantisReporterTestCase ,'test')
lsc_test_suite = unittest.makeSuite(test_lscgenerator.LSCGeneratorTestCase ,'test')


## Insert into Test Suite into Test Suite List
test_suite_list = [suse_test_suite, utils_test_suite, id_record_test_suite,
                   sanity_test_suite, generate_test_suite, mantisreporter_test_suite,
                   lsc_test_suite, fedora_test_suite, redhat_test_suite,
                   centos_test_suite, debian_test_suite, ubuntu_test_suite,
                   mandriva_test_suite, hpux_test_suite, gentoo_test_suite]

runner = unittest.TextTestRunner()

## Test all Test Suite
for test_suite in test_suite_list:
    runner.run(test_suite)

print "\nCleaning up..."
cmd = 'rm -rf test/unit_test/work/output/*'
msg = commands.getoutput(cmd)
if msg:
    print "Error MSG : ", msg
