//                                               -*- C++ -*-
/**
 *  @file  DistFunc.hxx
 *  @brief OpenTURNS wrapper to a library of special functions
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: DistFunc.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_DISTFUNC_HXX
#define OPENTURNS_DISTFUNC_HXX

#include "OTprivate.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      class DistFunc
      {
      public:
	static const NumericalScalar Precision;
	static const UnsignedLong MaximumIteration;
	static const UnsignedLong NumberOfBandNormalZigurrat = 129;
	static const NumericalScalar NormalZigguratTail = 3.44508288805539135654449538289;
	// The array NormalZigguratAbscissa stores the abscissas of the bands:
        // the ith band is [NormalZigguratAbscissa[0], NormalZigguratAbscissa[i+1]] with
	// NormalZigguratAbscissa[0] = 0.0 and
	// NormalZigguratAbscissa[NumberOfBandNormalZigurrat] = NormalZigguratTail
	static const NumericalScalar NormalZigguratAbscissa[NumberOfBandNormalZigurrat + 1];
	// The array NormalZigguratRatio stores the ratio between a band and the next one,
	// starting from the smallest one:
	// NormalZigguratRatio[i] = NormalZigguratAbscissa[i] / NormalZigguratAbscissa[i+1]
	static const NumericalScalar NormalZigguratRatio[NumberOfBandNormalZigurrat];

	// For Beta distribution. WARNING: here we adopt the classical definition
	// If tail=false, compute P(X<=x), else P(X>x)
	static NumericalScalar pBeta(const NumericalScalar p1,
				     const NumericalScalar p2,
				     const NumericalScalar x,
				     const Bool tail = false);
	// If tail=false, compute x such that P(X<=x)=q, else x such that P(X>x)=q
	static NumericalScalar qBeta(const NumericalScalar p1,
				     const NumericalScalar p2,
				     const NumericalScalar q,
				     const Bool tail = false);
	static NumericalScalar rBeta(const NumericalScalar p1,
				     const NumericalScalar p2);
	// For Gamma distribution
	static NumericalScalar pGamma(const NumericalScalar k,
				      const NumericalScalar x,
				      const Bool tail = false);
	static NumericalScalar qGamma(const NumericalScalar k,
				      const NumericalScalar q,
				      const Bool tail = false);
	static NumericalScalar rGamma(const NumericalScalar k);
	// For Kolmogorov distribution
	static NumericalScalar pKolmogorov(const UnsignedLong n,
					   const NumericalScalar x,
					   const Bool tail = false);
	static NumericalScalar pKolmogorovAsymptotic(const NumericalScalar x,
						     const Bool tail = false);
	// For NonCentralStudent distribution
	static NumericalScalar dNonCentralStudent(const NumericalScalar nu,
						  const NumericalScalar delta,
						  const NumericalScalar x);
	static NumericalScalar pNonCentralStudent(const NumericalScalar nu,
						  const NumericalScalar delta,
						  const NumericalScalar x,
						  const Bool tail = false);
	//      static NumericalScalar qStudent(const NumericalScalar nu, const NumericalScalar x);
	static NumericalScalar rNonCentralStudent(const NumericalScalar nu,
						  const NumericalScalar delta);
	// For Normal distribution
	static NumericalScalar pNormal(const NumericalScalar x,
				       const Bool tail = false);
	static NumericalScalar qNormal(const NumericalScalar q,
				       const Bool tail = false);
	static NumericalScalar rNormal();
	// For Poisson distribution
	static NumericalScalar rPoisson(const NumericalScalar lambda);
	// For Student distribution
	static NumericalScalar pStudent(const NumericalScalar nu,
					const NumericalScalar x,
					const Bool tail = false);
	static NumericalScalar qStudent(const NumericalScalar nu,
					const NumericalScalar q,
					const Bool tail = false);
	static NumericalScalar rStudent(const NumericalScalar nu);
	// For TruncatedNormal distribution
	//	static NumericalScalar rTruncatedNormal(const NumericalScalar a, const NumericalScalar b);
      }; /* class DistFunc */

    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_DISTFUNC_HXX */
