//                                               -*- C++ -*-
/**
 * @file  SVMKernelRegressionEvaluation.hxx
 * @brief Abstract top-level class for all numerical math function implementations
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2008-05-05 08:50:15 +0200 (lun, 05 mai 2008) $
 *  Id:      $Id: SVMKernelRegressionEvaluation.hxx 805 2008-05-05 06:50:15Z schueller $
 */

#ifndef OPENTURNS_SVMKERNELREGRESSIONEVALUATION_HXX
#define OPENTURNS_SVMKERNELREGRESSIONEVALUATION_HXX

#include "SVMKernel.hxx"
#include "NumericalMathEvaluationImplementation.hxx"
#include "SVMKernelRegressionGradient.hxx"
#include "SVMKernelRegressionHessian.hxx"

namespace OpenTURNS 
{
  namespace Uncertainty
  {
    namespace Algorithm
    {


      /**
       * @class SVMKernelRegressionEvaluation
       *
       * This class permits prediction on a support vector machine
       */

      class SVMKernelRegressionEvaluation
	: public Base::Func::NumericalMathEvaluationImplementation
      {
	CLASSNAME;

      public:

	typedef Uncertainty::Algorithm::SVMKernel	SVMKernel;
	typedef NumericalMathEvaluationImplementation::Description Description;
	typedef NumericalMathEvaluationImplementation::NumericalPoint NumericalPoint;
	typedef NumericalMathEvaluationImplementation::InvalidArgumentException InvalidArgumentException;
	typedef NumericalMathEvaluationImplementation::InternalException InternalException;

	/** Default constructor */
	SVMKernelRegressionEvaluation();

	/** Constructor with parameters */
	SVMKernelRegressionEvaluation(const SVMKernel & kernel,
				      const NumericalPoint & lagrangeMultiplier,
				      const NumericalSample & dataIn,
				      const NumericalScalar constant);

	/** Virtual constructor */
	virtual SVMKernelRegressionEvaluation * clone() const;

	/** Comparison operator */
	Bool operator ==(const SVMKernelRegressionEvaluation & other) const;

	/** String converter */
	virtual String __repr__() const;

	/** Test for actual implementation */
	virtual Bool isActualImplementation() const;

	/** Operator () */
	virtual NumericalPoint operator() (const NumericalPoint & in) const
	  /* throw(InvalidArgumentException,InternalException) */;

	/** Accessor for input point dimension */
	virtual UnsignedLong getInputDimension() const
	  /* throw(InternalException) */;

	/** Accessor for output point dimension */
	virtual UnsignedLong getOutputDimension() const
	  /* throw(InternalException) */;

      private:

	friend class SVMKernelRegressionGradient;
	friend class SVMKernelRegressionHessian;

      protected:
	SVMKernel kernel_;
	NumericalPoint lagrangeMultiplier_;
	NumericalSample dataIn_;
	NumericalScalar constant_;

      }; /* class SVMKernelRegressionEvaluation */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_SVMKERNELREGRESSIONEVALUATION_HXX */
