//                                               -*- C++ -*-
/**
 *  @file  InverseNatafEllipticalDistributionGradient.hxx
 *  @brief Class for the InverseNataf transformation gradient for elliptical
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: InverseNatafEllipticalDistributionGradient.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_INVERSENATAFELLIPTICALDISTRIBUTIONGRADIENT_HXX
#define OPENTURNS_INVERSENATAFELLIPTICALDISTRIBUTIONGRADIENT_HXX

#include "OTprivate.hxx"
#include "ConstantNumericalMathGradientImplementation.hxx"
#include "SquareMatrix.hxx"
#include "SymmetricTensor.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {


      /**
       * @class InverseNatafEllipticalDistributionGradient
       *
       * This class offers an interface for the InverseNataf gradient for elliptical distributions
       */
      class InverseNatafEllipticalDistributionGradient
	: public Base::Func::ConstantNumericalMathGradientImplementation
      {
	CLASSNAME;
      public:

	typedef Base::Func::ConstantNumericalMathGradientImplementation ConstantNumericalMathGradientImplementation;
	typedef Base::Type::SquareMatrix                                SquareMatrix;
	typedef Base::Type::NumericalPoint                              NumericalPoint;

	/** Parameter constructor */
	InverseNatafEllipticalDistributionGradient(const SquareMatrix & inverseCholesky);

	/** String converter */
	virtual String __repr__() const;

      protected:

    
      private:

      }; /* InverseNatafEllipticalDistributionGradient */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_INVERSENATAFELLIPTICALDISTRIBUTIONGRADIENT_HXX */
