//                                               -*- C++ -*-
/**
 *  @file  t_NumericalMathFunction_linear_combination.cxx
 *  @brief The test file of class NumericalMathFunction for linear combinations
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-10 16:43:31 +0200 (jeu, 10 mai 2007) $
 *  Id:      $Id: t_NumericalMathFunction_linear_combination.cxx 434 2007-05-10 14:43:31Z dutka $
 */
#include <iostream>
#include "OT.hxx"
#include "PlatformInfo.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalMathFunction.hxx"
#include "NumericalPoint.hxx"
#include "LinearCombinationEvaluationImplementation.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    // First, build two functions from R^3->R
    Description inVar(3);
    inVar[0] = "x1";
    inVar[1] = "x2";
    inVar[2] = "x3";
    Description outVar(1);
    outVar[0] = "y";
    Description formula(1);
    formula[0] = "x1^3 * sin(x2 + 2.5 * x3) - (x1 + x2)^2 / (1.0 + x3^2)";
    LinearCombinationEvaluationImplementation::NumericalMathFunctionCollection functions(2);
    functions[0] = NumericalMathFunction(inVar, outVar, formula);
    formula[0] = "exp(-x1 * x2 + x3) / cos(1.0 + x2 * x3 - x1)";
    functions[1] = NumericalMathFunction(inVar, outVar, formula);
    // Second, build the weights
    NumericalPoint coefficients(2);
    coefficients[0] = 0.3;
    coefficients[1] = 2.9;
    // Third, build the function
    NumericalMathFunction myFunction(functions, coefficients);
    NumericalPoint inPoint(3);
    inPoint[0] = 1.2;
    inPoint[1] = 2.3;
    inPoint[2] = 3.4;
    fullprint << "myFunction=" << myFunction << std::endl;
    fullprint << "Value at " << inPoint << "=" << myFunction(inPoint) << std::endl;
    fullprint << "Gradient at " << inPoint << "=" << myFunction.gradient(inPoint) << std::endl;
    // Reduce the ouput precision because we use finite difference so only 5 digits are significant
    PlatformInfo::SetNumericalPrecision(5);
    fullprint << "Hessian at " << inPoint << "=" << myFunction.hessian(inPoint) << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
