//                                               -*- C++ -*-
/**
 *  @file  TestResponseSurface.cxx
 *  @brief 
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-02-12 14:29:13 +0100 (jeu. 12 févr. 2009) $
 *  Id:      $Id: TestResponseSurface.cxx 1132 2009-02-12 13:29:13Z dutka $
 */
#include <cmath>
#include <iostream>
#include <cstdlib>
#include "WrapperInterface.h"

namespace WrapperInternals {
  struct internalState {
    long numberOfCalls;
  };

  void internalStateInitialization(struct internalState * p_internalState)
  {
    if (p_internalState) p_internalState->numberOfCalls = 0;
  }

  void internalStateIncrement(struct internalState * p_internalState)
  {
    if (p_internalState) p_internalState->numberOfCalls++;
  }

  long internalStateGetNumberOfCalls(struct internalState * p_internalState)
  {
    return (p_internalState ? p_internalState->numberOfCalls : -1);
  }
} /* namespace WrapperInternals */

extern "C" {
  /* Function */
  enum WrapperErrorCode func_createState_TestResponseSurface(void ** p_p_state, const struct WrapperExchangedData * p_exchangedData)
  {
    *p_p_state = malloc(sizeof(struct WrapperInternals::internalState));
    internalStateInitialization(static_cast<struct WrapperInternals::internalState *>(*p_p_state));
    return WRAPPER_OK;
  }

  enum WrapperErrorCode func_deleteState_TestResponseSurface(void * p_state)
  {
    free(p_state);
    return WRAPPER_OK;
  }

  static struct WrapperInformation info_TestResponseSurface = {/* inSize_  = */ 2,
							       /* outSize_ = */ 3};

  enum WrapperErrorCode func_getInfo_TestResponseSurface(void * p_state, struct WrapperInformation * p_info)
  {
    *p_info = info_TestResponseSurface;
    return WRAPPER_OK;
  }

  enum WrapperErrorCode func_init_TestResponseSurface(void * p_state)
  {
    return WRAPPER_OK;
  }

  enum WrapperErrorCode func_exec_TestResponseSurface(void * p_state, const struct point * inPoint, struct point * outPoint)
  {
    internalStateIncrement(static_cast<struct WrapperInternals::internalState *>(p_state));
    double x1(inPoint->data_[0]);
    double x2(inPoint->data_[1]);

    // f1 = x1*sin(x2);
    // f2 = cos(x1+x2);
    // f3 = (x2+1)*exp(x1-2*x2);
    outPoint->data_[0] = x1*sin(x2);
    outPoint->data_[1] = cos(x1+x2);
    outPoint->data_[2] = (x2+1)*exp(x1-2*x2);
    return WRAPPER_OK;
  }

  enum WrapperErrorCode func_exec_sample_TestResponseSurface(void * p_state, const struct sample * inSample, struct sample * outSample)
  {
    unsigned long inDimension((inSample->data_[0]).size_);
    if (info_TestResponseSurface.inSize_ != inDimension) return WRAPPER_WRONG_ARGUMENT;
    unsigned long outDimension((outSample->data_[0]).size_);
    if (info_TestResponseSurface.outSize_ != outDimension) return WRAPPER_WRONG_ARGUMENT;
    unsigned long size(inSample->size_);
    for (unsigned long i = 0; i < size; i++)
      {
        if (func_exec_TestResponseSurface(p_state, &(inSample->data_[i]),  &(outSample->data_[i])) != WRAPPER_OK) return WRAPPER_EXECUTION_ERROR;
      }
    return WRAPPER_OK;
  }

  enum WrapperErrorCode func_finalize_TestResponseSurface(void * p_state)
  {
    return WRAPPER_OK;
  }
  /* Gradient, which is void at this time */
  enum WrapperErrorCode grad_createState_TestResponseSurface(void ** p_p_state, const struct WrapperExchangedData * p_exchangedData)
  {
    *p_p_state = malloc(sizeof(struct WrapperInternals::internalState));
    internalStateInitialization(static_cast<struct WrapperInternals::internalState *>(*p_p_state));
    return WRAPPER_OK;
  }

  enum WrapperErrorCode grad_deleteState_TestResponseSurface(void * p_state)
  {
    free(p_state);
    return WRAPPER_OK;
  }

  enum WrapperErrorCode grad_getInfo_TestResponseSurface(void * p_state, struct WrapperInformation * p_info)
  {
    *p_info = info_TestResponseSurface;
    return WRAPPER_OK;
  }

  enum WrapperErrorCode grad_init_TestResponseSurface(void * p_state)
  {
    return WRAPPER_OK;
  }

  enum WrapperErrorCode grad_exec_TestResponseSurface(void * p_state, const struct point * inPoint, struct matrix * outMatrix)
  {
    internalStateIncrement(static_cast<struct WrapperInternals::internalState *>(p_state));
    double x1(inPoint->data_[0]);
    double x2(inPoint->data_[1]);

    // f1 = x1*sin(x2);
    // f2 = cos(x1+x2);
    // f3 = (x2+1)*exp(x1-2*x2);
    outMatrix->data_[0] = sin(x2);                // df11 = df1/dx1
    outMatrix->data_[1] = x1*cos(x2);             // df21 = df1/dx2
    outMatrix->data_[2] = -sin(x1+x2);            // df12 = df2/dx1
    outMatrix->data_[3] = -sin(x1+x2);            // df22 = df2/dx2
    outMatrix->data_[4] = (x2+1)*exp(x1-2*x2);    // df13 = df3/dx1
    outMatrix->data_[5] = -(2*x2+1)*exp(x1-2*x2); // df23 = df3/dx2
    return WRAPPER_OK;
  }

  enum WrapperErrorCode grad_finalize_TestResponseSurface(void * p_state)
  {
    return WRAPPER_OK;
  }
  /* Hessian, which is void at this time */
  enum WrapperErrorCode hess_createState_TestResponseSurface(void ** p_p_state, const struct WrapperExchangedData * p_exchangedData)
  {
    *p_p_state = malloc(sizeof(struct WrapperInternals::internalState));
    internalStateInitialization(static_cast<struct WrapperInternals::internalState *>(*p_p_state));
    return WRAPPER_OK;
  }

  enum WrapperErrorCode hess_deleteState_TestResponseSurface(void * p_state)
  {
    free(p_state);
    return WRAPPER_OK;
  }

  enum WrapperErrorCode hess_getInfo_TestResponseSurface(void * p_state, struct WrapperInformation * p_info)
  {
    *p_info = info_TestResponseSurface;
    return WRAPPER_OK;
  }

  enum WrapperErrorCode hess_init_TestResponseSurface(void * p_state)
  {
    return WRAPPER_OK;
  }

  enum WrapperErrorCode hess_exec_TestResponseSurface(void * p_state, const struct point * inPoint, struct tensor * outTensor)
  {
    internalStateIncrement(static_cast<struct WrapperInternals::internalState *>(p_state));
    double x1(inPoint->data_[0]);
    double x2(inPoint->data_[1]);

    // f1 = x1*sin(x2);
    // f2 = cos(x1+x2);
    // f3 = (x2+1)*exp(x1-2*x2);
    outTensor->data_[ 0] = 0.0;                    // d2f111 = d2f1/dx1dx1
    outTensor->data_[ 1] = cos(x2);                // d2f112 = d2f1/dx1dx2
    outTensor->data_[ 2] = cos(x2);                // d2f121 = d2f1/dx2dx1
    outTensor->data_[ 3] = -x1*sin(x2);            // d2f122 = d2f1/dx2dx2
    outTensor->data_[ 4] = -cos(x1+x2);            // d2f211 = d2f2/dx1dx1
    outTensor->data_[ 5] = -cos(x1+x2);            // d2f212 = d2f2/dx1dx2
    outTensor->data_[ 6] = -cos(x1+x2);            // d2f221 = d2f2/dx2dx1
    outTensor->data_[ 7] = -cos(x1+x2);            // d2f222 = d2f2/dx2dx2
    outTensor->data_[ 8] = (x2+1)*exp(x1-2*x2);    // d2f311 = d2f3/dx1dx1
    outTensor->data_[ 9] = -(1+2*x2)*exp(x1-2*x2); // d2f312 = d2f3/dx1dx2
    outTensor->data_[10] = -(1+2*x2)*exp(x1-2*x2); // d2f321 = d2f3/dx2dx1
    outTensor->data_[11] = 4*x2*exp(x1-2*x2);      // d2f322 = d2f3/dx2dx2

    return WRAPPER_OK;
  }

  enum WrapperErrorCode hess_finalize_TestResponseSurface(void * p_state)
  {
    return WRAPPER_OK;
  }
} /* end extern "C" */
