//                                               -*- C++ -*-
/**
 * @file  EventRandomVectorImplementation.hxx
 * @brief The class that implements an event random vector, i.e. a
 *        composite random vector built upon a boolean function which
 *        is described by a threshold and a comparison operator. The
 *        antecedent of the event must be a "classical" composite random
 *        vector in the context of OpenTURNS.
 *
 * (C) Copyright 2005-2006 EDF
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * \author $LastChangedBy: dutka $
 * \date   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 */

#ifndef OPENTURNS_EVENTRANDOMVECTORIMPLEMENTATION_HXX
#define OPENTURNS_EVENTRANDOMVECTORIMPLEMENTATION_HXX

#include "CompositeRandomVector.hxx"


namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {


      /**
       * @class EventRandomVectorImplementation
       *
       * 
       */
      class EventRandomVectorImplementation 
	: public CompositeRandomVector
      {
	CLASSNAME;

      public:

	typedef CompositeRandomVector::ComparisonOperator       ComparisonOperator;
	typedef CompositeRandomVector::NumericalPoint           NumericalPoint;
	typedef CompositeRandomVector::NumericalSample          NumericalSample;
	typedef CompositeRandomVector::InvalidArgumentException InvalidArgumentException;
	typedef CompositeRandomVector::StorageManager           StorageManager;

	/** Constructor from RandomVector */
	EventRandomVectorImplementation(const RandomVectorImplementation & antecedent,
					const ComparisonOperator & op,
					const NumericalScalar threshold,
					const String & name = OT::DefaultName)
	  throw (InvalidArgumentException);


	/** String converter */
	String __repr__() const;

	/** Dimension accessor */
	virtual UnsignedLong getDimension() const;

	/** Operator accessor */
	ComparisonOperator getOperator() const;

	/** Threshold accessor */
	NumericalScalar getThreshold() const;

	/* Here is the interface that all derived class may implement */

	/** Realization accessor */
	virtual NumericalPoint getRealization() const;

	/** Numerical sample accessor */
	virtual NumericalSample getNumericalSample(UnsignedLong size) const;

	/** Method save() stores the object through the StorageManager */
	virtual void save(const StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	virtual void load(const StorageManager::Advocate & adv);

      protected:

    
      private:

	friend class Base::Common::Factory<EventRandomVectorImplementation>;

	/** Default constructor */
	EventRandomVectorImplementation(const String & name = OT::DefaultName) : CompositeRandomVector(name) {};
    
	/** The comparison operator of the eventRandomVectorImplementation */
	ComparisonOperator operator_;

	/** The threshold of the eventRandomVectorImplementation */
	NumericalScalar threshold_;
    
      }; /* class EventRandomVectorImplementation */


    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_EVENTRANDOMVECTORIMPLEMENTATION_HXX */
