//                                               -*- C++ -*-
/**
 *  @file  DiscreteDistribution.cxx
 *  @brief Abstract top-level class for Discrete distributions
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: DiscreteDistribution.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include <cstdlib>

#include "DiscreteDistribution.hxx"
#include "Exception.hxx"
#include "ResourceMap.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {

      CLASSNAMEINIT(DiscreteDistribution);

      typedef Base::Common::NotYetImplementedException NotYetImplementedException;
      typedef Base::Common::ResourceMap                ResourceMap;

      const NumericalScalar DiscreteDistribution::SupportEpsilon = 1.0e-14;//strtoul(ResourceMap::GetInstance().get("DiscreteDistribution-SupportEpsilon").c_str(), NULL, 0);

      /* Default constructor */
      DiscreteDistribution::DiscreteDistribution(const String & name)
	: UsualDistribution(name)
      {
	// Initialize any other class members here
	// At last, allocate memory space if needed, but go to destructor to free it
      }

      /* Comparison operator */
      Bool DiscreteDistribution::operator ==(const DiscreteDistribution & other) const {
	Bool sameObject = false;

	if (this != &other) { // Other is NOT me, so I have to realize the comparison
	  // sameObject = ...
	} else sameObject = true;

	return sameObject;
      }
  
      /* String converter */
      String DiscreteDistribution::__repr__() const {
	OSS oss;
	oss << "class=" << DiscreteDistribution::GetClassName();
	return oss;
      }
  
      /* Tell if the distribution is continuous */
      Bool DiscreteDistribution::isContinuous() const
      {
	return false;
      }
    
      
    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
