//                                               -*- C++ -*-
/**
 *  @file  ComputedNumericalMathGradientImplementationFactory.cxx
 *  @brief The class ComputedNumericalMathGradientImplementationFactory creates ComputedNumericalMathGradientImplementation from external codes
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: ComputedNumericalMathGradientImplementationFactory.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include "WrapperFile.hxx"
#include "Exception.hxx"
#include "OSS.hxx"
#include "Log.hxx"
#include "ComputedNumericalMathGradientImplementationFactory.hxx"
#include "NoNumericalMathGradientImplementation.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Func
    {

      using OT::Base::Common::NoWrapperFileFoundException;
      using OT::Base::Common::WrapperFileParsingException;
      using OT::Base::Common::WrapperInternalException;
      using OT::Base::Common::Log;

      CLASSNAMEINIT(ComputedNumericalMathGradientImplementationFactory);

      /* The unique instance of the Singleton model */
      ComputedNumericalMathGradientImplementationFactory::Instance ComputedNumericalMathGradientImplementationFactory::P_instance_(0);

      /* Default constructor */
      ComputedNumericalMathGradientImplementationFactory::ComputedNumericalMathGradientImplementationFactory()
	: NumericalMathGradientImplementationFactory()
      {
        // Nothing to do
      }

      /* String converter */
      String ComputedNumericalMathGradientImplementationFactory::__repr__() const
      {
	OSS oss;
	oss << "class=" << ComputedNumericalMathGradientImplementationFactory::GetClassName();
	return oss;
      }


      /* The accessor to the Singleton element */
      ComputedNumericalMathGradientImplementationFactory::Instance ComputedNumericalMathGradientImplementationFactory::getInstance()
      {
	if (P_instance_.isNull()) {
	  // this is the first call, we have to create the instance
	  P_instance_.reset(new ComputedNumericalMathGradientImplementationFactory);
	}
	return P_instance_;
      }




      /* Object builder */
      NumericalMathGradientImplementation * ComputedNumericalMathGradientImplementationFactory::buildObject(const String & functionName) const
      {
	FileName wrapperPath;
	NumericalMathGradientImplementation * implementation;
	typedef OT::Base::Common::Exception Exception;

	try {
	  // Open the wrapper file and get the name of the library and the names of
	  // the function, its gradient and its hessian if defined
	  // If the gradient or the hessian are not defined, ask for default ones
	  // Then create the actual functions
	  // Get also the data read inside the wrapper file and pass them to the wrapper
	  WrapperFile wrapperFile = WrapperFile::FindWrapperByName( functionName );
#ifdef DEBUG
	  Log::Debug(OSS() << "Successful search of wrapper file located at " << wrapperFile.getDescriptionFilePath() );
#endif

	  implementation = new ComputedNumericalMathGradientImplementation( functionName, wrapperFile );

	}
	catch (Exception & ex) {
	  // 	  throw InvalidArgumentException(HERE)
	  // 	    << "Cannot find wrapper file '" << wrapperPath << "' - " << ex;
	  implementation = new NoNumericalMathGradientImplementation();
	}

	return implementation;
      }




    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */
