//                                               -*- C++ -*-
/**
 *  @file  Less.cxx
 *  @brief Abstract top-level class for all Less
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: Less.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include "Less.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Common {

      CLASSNAMEINIT(Less);

      static Common::Factory<Less> RegisteredFactory("Less");

      /* Default constructor */
      Less::Less()
	: ComparisonOperatorImplementation()
      {
	// Nothing to do
      }

      /* String converter */
      String Less::__repr__() const {
	return OSS() << "class=" << Less::GetClassName()
		     << " name=" << getName();
      }
  

      /* Here is the interface that all derived class must implement */

      /* Virtual constructor */
      Less * Less::clone() const
      {
	return new Less(*this);
      }

      /* Return true if comparison succeeds */
      Bool Less::operator() (NumericalScalar a, NumericalScalar b) const
      {
	return (a < b);
      }


      /* Method save() stores the object through the StorageManager */
      void Less::save(const StorageManager::Advocate & adv) const
      {
	ComparisonOperatorImplementation::save(adv);
      }


      /* Method load() reloads the object from the StorageManager */
      void Less::load(const StorageManager::Advocate & adv)
      {
	ComparisonOperatorImplementation::load(adv);
      }





    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */
