#region License
//
// The Open Toolkit Library License
//
// Copyright (c) 2006 - 2009 the Open Toolkit library.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights to 
// use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
// the Software, and to permit persons to whom the Software is furnished to do
// so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//
#endregion

namespace OpenTK.Graphics.ES11
{
    using System;
    using System.Text;
    using System.Runtime.InteropServices;
    #pragma warning disable 3019
    #pragma warning disable 1591
    #pragma warning disable 1572
    #pragma warning disable 1573

    partial class GL
    {

        
        /// <summary>
        /// Select active texture unit
        /// </summary>
        /// <param name="texture">
        /// <para>
        /// Specifies which texture unit to make active. The number of texture units is implementation dependent, but must be at least two. texture must be one of GL_TEXTURE, where i ranges from 0 to the larger of (GL_MAX_TEXTURE_COORDS - 1) and (GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS - 1). The initial value is GL_TEXTURE0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glActiveTexture")]
        public static 
        void ActiveTexture(OpenTK.Graphics.ES11.All texture)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glActiveTexture((OpenTK.Graphics.ES11.All)texture);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the alpha test function
        /// </summary>
        /// <param name="func">
        /// <para>
        /// Specifies the alpha comparison function. Symbolic constants GL_NEVER, GL_LESS, GL_EQUAL, GL_LEQUAL, GL_GREATER, GL_NOTEQUAL, GL_GEQUAL, and GL_ALWAYS are accepted. The initial value is GL_ALWAYS.
        /// </para>
        /// </param>
        /// <param name="ref">
        /// <para>
        /// Specifies the reference value that incoming alpha values are compared to. This value is clamped to the range [0,1], where 0 represents the lowest possible alpha value and 1 the highest possible value. The initial reference value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glAlphaFunc")]
        public static 
        void AlphaFunc(OpenTK.Graphics.ES11.All func, Single @ref)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glAlphaFunc((OpenTK.Graphics.ES11.All)func, (Single)@ref);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glAlphaFuncx")]
        public static 
        void AlphaFuncx(OpenTK.Graphics.ES11.All func, int @ref)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glAlphaFuncx((OpenTK.Graphics.ES11.All)func, (int)@ref);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Bind a named buffer object
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target to which the buffer object is bound. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="buffer">
        /// <para>
        /// Specifies the name of a buffer object.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBindBuffer")]
        public static 
        void BindBuffer(OpenTK.Graphics.ES11.All target, Int32 buffer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBindBuffer((OpenTK.Graphics.ES11.All)target, (UInt32)buffer);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Bind a named buffer object
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target to which the buffer object is bound. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="buffer">
        /// <para>
        /// Specifies the name of a buffer object.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBindBuffer")]
        public static 
        void BindBuffer(OpenTK.Graphics.ES11.All target, UInt32 buffer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBindBuffer((OpenTK.Graphics.ES11.All)target, (UInt32)buffer);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Bind a named texture to a texturing target
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target to which the texture is bound. Must be either GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="texture">
        /// <para>
        /// Specifies the name of a texture.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBindTexture")]
        public static 
        void BindTexture(OpenTK.Graphics.ES11.All target, Int32 texture)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBindTexture((OpenTK.Graphics.ES11.All)target, (UInt32)texture);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Bind a named texture to a texturing target
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target to which the texture is bound. Must be either GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="texture">
        /// <para>
        /// Specifies the name of a texture.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBindTexture")]
        public static 
        void BindTexture(OpenTK.Graphics.ES11.All target, UInt32 texture)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBindTexture((OpenTK.Graphics.ES11.All)target, (UInt32)texture);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify pixel arithmetic
        /// </summary>
        /// <param name="sfactor">
        /// <para>
        /// Specifies how the red, green, blue, and alpha source blending factors are computed. The following symbolic constants are accepted: GL_ZERO, GL_ONE, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_DST_COLOR, GL_ONE_MINUS_DST_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, GL_DST_ALPHA, GL_ONE_MINUS_DST_ALPHA, GL_CONSTANT_COLOR, GL_ONE_MINUS_CONSTANT_COLOR, GL_CONSTANT_ALPHA, GL_ONE_MINUS_CONSTANT_ALPHA, and GL_SRC_ALPHA_SATURATE. The initial value is GL_ONE.
        /// </para>
        /// </param>
        /// <param name="dfactor">
        /// <para>
        /// Specifies how the red, green, blue, and alpha destination blending factors are computed. The following symbolic constants are accepted: GL_ZERO, GL_ONE, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_DST_COLOR, GL_ONE_MINUS_DST_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, GL_DST_ALPHA, GL_ONE_MINUS_DST_ALPHA. GL_CONSTANT_COLOR, GL_ONE_MINUS_CONSTANT_COLOR, GL_CONSTANT_ALPHA, and GL_ONE_MINUS_CONSTANT_ALPHA. The initial value is GL_ZERO.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBlendFunc")]
        public static 
        void BlendFunc(OpenTK.Graphics.ES11.All sfactor, OpenTK.Graphics.ES11.All dfactor)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBlendFunc((OpenTK.Graphics.ES11.All)sfactor, (OpenTK.Graphics.ES11.All)dfactor);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Creates and initializes a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the buffer object's new data store.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to data that will be copied into the data store for initialization, or NULL if no data is to be copied.
        /// </para>
        /// </param>
        /// <param name="usage">
        /// <para>
        /// Specifies the expected usage pattern of the data store. The symbolic constant must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ, GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBufferData")]
        public static 
        void BufferData<T2>(OpenTK.Graphics.ES11.All target, IntPtr size, [InAttribute, OutAttribute] ref T2 data, OpenTK.Graphics.ES11.All usage)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glBufferData((OpenTK.Graphics.ES11.All)target, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject(), (OpenTK.Graphics.ES11.All)usage);
                data = (T2)data_ptr.Target;
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Creates and initializes a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the buffer object's new data store.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to data that will be copied into the data store for initialization, or NULL if no data is to be copied.
        /// </para>
        /// </param>
        /// <param name="usage">
        /// <para>
        /// Specifies the expected usage pattern of the data store. The symbolic constant must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ, GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBufferData")]
        public static 
        void BufferData<T2>(OpenTK.Graphics.ES11.All target, IntPtr size, [InAttribute, OutAttribute] T2[,,] data, OpenTK.Graphics.ES11.All usage)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glBufferData((OpenTK.Graphics.ES11.All)target, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject(), (OpenTK.Graphics.ES11.All)usage);
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Creates and initializes a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the buffer object's new data store.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to data that will be copied into the data store for initialization, or NULL if no data is to be copied.
        /// </para>
        /// </param>
        /// <param name="usage">
        /// <para>
        /// Specifies the expected usage pattern of the data store. The symbolic constant must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ, GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBufferData")]
        public static 
        void BufferData<T2>(OpenTK.Graphics.ES11.All target, IntPtr size, [InAttribute, OutAttribute] T2[,] data, OpenTK.Graphics.ES11.All usage)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glBufferData((OpenTK.Graphics.ES11.All)target, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject(), (OpenTK.Graphics.ES11.All)usage);
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Creates and initializes a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the buffer object's new data store.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to data that will be copied into the data store for initialization, or NULL if no data is to be copied.
        /// </para>
        /// </param>
        /// <param name="usage">
        /// <para>
        /// Specifies the expected usage pattern of the data store. The symbolic constant must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ, GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBufferData")]
        public static 
        void BufferData<T2>(OpenTK.Graphics.ES11.All target, IntPtr size, [InAttribute, OutAttribute] T2[] data, OpenTK.Graphics.ES11.All usage)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glBufferData((OpenTK.Graphics.ES11.All)target, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject(), (OpenTK.Graphics.ES11.All)usage);
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Creates and initializes a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the buffer object's new data store.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to data that will be copied into the data store for initialization, or NULL if no data is to be copied.
        /// </para>
        /// </param>
        /// <param name="usage">
        /// <para>
        /// Specifies the expected usage pattern of the data store. The symbolic constant must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ, GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBufferData")]
        public static 
        void BufferData(OpenTK.Graphics.ES11.All target, IntPtr size, IntPtr data, OpenTK.Graphics.ES11.All usage)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBufferData((OpenTK.Graphics.ES11.All)target, (IntPtr)size, (IntPtr)data, (OpenTK.Graphics.ES11.All)usage);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Updates a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store where data replacement will begin, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being replaced.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the new data that will be copied into the data store.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBufferSubData")]
        public static 
        void BufferSubData<T3>(OpenTK.Graphics.ES11.All target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] ref T3 data)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glBufferSubData((OpenTK.Graphics.ES11.All)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
                data = (T3)data_ptr.Target;
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Updates a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store where data replacement will begin, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being replaced.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the new data that will be copied into the data store.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBufferSubData")]
        public static 
        void BufferSubData<T3>(OpenTK.Graphics.ES11.All target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] T3[,,] data)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glBufferSubData((OpenTK.Graphics.ES11.All)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Updates a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store where data replacement will begin, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being replaced.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the new data that will be copied into the data store.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBufferSubData")]
        public static 
        void BufferSubData<T3>(OpenTK.Graphics.ES11.All target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] T3[,] data)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glBufferSubData((OpenTK.Graphics.ES11.All)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Updates a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store where data replacement will begin, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being replaced.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the new data that will be copied into the data store.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBufferSubData")]
        public static 
        void BufferSubData<T3>(OpenTK.Graphics.ES11.All target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] T3[] data)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glBufferSubData((OpenTK.Graphics.ES11.All)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Updates a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store where data replacement will begin, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being replaced.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the new data that will be copied into the data store.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBufferSubData")]
        public static 
        void BufferSubData(OpenTK.Graphics.ES11.All target, IntPtr offset, IntPtr size, IntPtr data)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glBufferSubData((OpenTK.Graphics.ES11.All)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Clear buffers to preset values
        /// </summary>
        /// <param name="mask">
        /// <para>
        /// Bitwise OR of masks that indicate the buffers to be cleared. The four masks are GL_COLOR_BUFFER_BIT, GL_DEPTH_BUFFER_BIT, GL_ACCUM_BUFFER_BIT, and GL_STENCIL_BUFFER_BIT.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClear")]
        public static 
        void Clear(Int32 mask)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClear((UInt32)mask);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Clear buffers to preset values
        /// </summary>
        /// <param name="mask">
        /// <para>
        /// Bitwise OR of masks that indicate the buffers to be cleared. The four masks are GL_COLOR_BUFFER_BIT, GL_DEPTH_BUFFER_BIT, GL_ACCUM_BUFFER_BIT, and GL_STENCIL_BUFFER_BIT.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClear")]
        public static 
        void Clear(UInt32 mask)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClear((UInt32)mask);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify clear values for the color buffers
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify the red, green, blue, and alpha values used when the color buffers are cleared. The initial values are all 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClearColor")]
        public static 
        void ClearColor(Single red, Single green, Single blue, Single alpha)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClearColor((Single)red, (Single)green, (Single)blue, (Single)alpha);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClearColorx")]
        public static 
        void ClearColorx(int red, int green, int blue, int alpha)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClearColorx((int)red, (int)green, (int)blue, (int)alpha);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the clear value for the depth buffer
        /// </summary>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth value used when the depth buffer is cleared. The initial value is 1.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClearDepthf")]
        public static 
        void ClearDepth(Single depth)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClearDepthf((Single)depth);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClearDepthx")]
        public static 
        void ClearDepthx(int depth)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClearDepthx((int)depth);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the clear value for the stencil buffer
        /// </summary>
        /// <param name="s">
        /// <para>
        /// Specifies the index used when the stencil buffer is cleared. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClearStencil")]
        public static 
        void ClearStencil(Int32 s)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClearStencil((Int32)s);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Select active texture unit
        /// </summary>
        /// <param name="texture">
        /// <para>
        /// Specifies which texture unit to make active. The number of texture units is implementation dependent, but must be at least two. texture must be one of GL_TEXTURE, where i ranges from 0 to the value of GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value. The initial value is GL_TEXTURE0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClientActiveTexture")]
        public static 
        void ClientActiveTexture(OpenTK.Graphics.ES11.All texture)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClientActiveTexture((OpenTK.Graphics.ES11.All)texture);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a plane against which all geometry is clipped
        /// </summary>
        /// <param name="plane">
        /// <para>
        /// Specifies which clipping plane is being positioned. Symbolic names of the form GL_CLIP_PLANEi, where i is an integer between 0 and GL_MAX_CLIP_PLANES - 1, are accepted.
        /// </para>
        /// </param>
        /// <param name="equation">
        /// <para>
        /// Specifies the address of an array of four double-precision floating-point values. These values are interpreted as a plane equation.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClipPlanef")]
        public static 
        void ClipPlane(OpenTK.Graphics.ES11.All plane, ref Single equation)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* equation_ptr = &equation)
                {
                    Delegates.glClipPlanef((OpenTK.Graphics.ES11.All)plane, (Single*)equation_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a plane against which all geometry is clipped
        /// </summary>
        /// <param name="plane">
        /// <para>
        /// Specifies which clipping plane is being positioned. Symbolic names of the form GL_CLIP_PLANEi, where i is an integer between 0 and GL_MAX_CLIP_PLANES - 1, are accepted.
        /// </para>
        /// </param>
        /// <param name="equation">
        /// <para>
        /// Specifies the address of an array of four double-precision floating-point values. These values are interpreted as a plane equation.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClipPlanef")]
        public static 
        unsafe void ClipPlane(OpenTK.Graphics.ES11.All plane, Single* equation)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClipPlanef((OpenTK.Graphics.ES11.All)plane, (Single*)equation);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a plane against which all geometry is clipped
        /// </summary>
        /// <param name="plane">
        /// <para>
        /// Specifies which clipping plane is being positioned. Symbolic names of the form GL_CLIP_PLANEi, where i is an integer between 0 and GL_MAX_CLIP_PLANES - 1, are accepted.
        /// </para>
        /// </param>
        /// <param name="equation">
        /// <para>
        /// Specifies the address of an array of four double-precision floating-point values. These values are interpreted as a plane equation.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClipPlanef")]
        public static 
        void ClipPlane(OpenTK.Graphics.ES11.All plane, Single[] equation)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* equation_ptr = equation)
                {
                    Delegates.glClipPlanef((OpenTK.Graphics.ES11.All)plane, (Single*)equation_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClipPlanefIMG")]
        public static 
        void ClipPlanefIMG(OpenTK.Graphics.ES11.All p, ref Single eqn)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* eqn_ptr = &eqn)
                {
                    Delegates.glClipPlanefIMG((OpenTK.Graphics.ES11.All)p, (Single*)eqn_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClipPlanefIMG")]
        public static 
        unsafe void ClipPlanefIMG(OpenTK.Graphics.ES11.All p, Single* eqn)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClipPlanefIMG((OpenTK.Graphics.ES11.All)p, (Single*)eqn);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClipPlanefIMG")]
        public static 
        void ClipPlanefIMG(OpenTK.Graphics.ES11.All p, Single[] eqn)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* eqn_ptr = eqn)
                {
                    Delegates.glClipPlanefIMG((OpenTK.Graphics.ES11.All)p, (Single*)eqn_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClipPlanex")]
        public static 
        unsafe void ClipPlanex(OpenTK.Graphics.ES11.All plane, int* equation)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClipPlanex((OpenTK.Graphics.ES11.All)plane, (int*)equation);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClipPlanex")]
        public static 
        void ClipPlanex(OpenTK.Graphics.ES11.All plane, int[] equation)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* equation_ptr = equation)
                {
                    Delegates.glClipPlanex((OpenTK.Graphics.ES11.All)plane, (int*)equation_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClipPlanex")]
        public static 
        void ClipPlanex(OpenTK.Graphics.ES11.All plane, ref int equation)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* equation_ptr = &equation)
                {
                    Delegates.glClipPlanex((OpenTK.Graphics.ES11.All)plane, (int*)equation_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClipPlanexIMG")]
        public static 
        unsafe void ClipPlanexIMG(OpenTK.Graphics.ES11.All p, int* eqn)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glClipPlanexIMG((OpenTK.Graphics.ES11.All)p, (int*)eqn);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClipPlanexIMG")]
        public static 
        void ClipPlanexIMG(OpenTK.Graphics.ES11.All p, int[] eqn)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* eqn_ptr = eqn)
                {
                    Delegates.glClipPlanexIMG((OpenTK.Graphics.ES11.All)p, (int*)eqn_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClipPlanexIMG")]
        public static 
        void ClipPlanexIMG(OpenTK.Graphics.ES11.All p, ref int eqn)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* eqn_ptr = &eqn)
                {
                    Delegates.glClipPlanexIMG((OpenTK.Graphics.ES11.All)p, (int*)eqn_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glColor4f")]
        public static 
        void Color4(Single red, Single green, Single blue, Single alpha)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glColor4f((Single)red, (Single)green, (Single)blue, (Single)alpha);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glColor4ub")]
        public static 
        void Color4(Byte red, Byte green, Byte blue, Byte alpha)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glColor4ub((Byte)red, (Byte)green, (Byte)blue, (Byte)alpha);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glColor4x")]
        public static 
        void Color4x(int red, int green, int blue, int alpha)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glColor4x((int)red, (int)green, (int)blue, (int)alpha);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Enable and disable writing of frame buffer color components
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify whether red, green, blue, and alpha can or cannot be written into the frame buffer. The initial values are all GL_TRUE, indicating that the color components can be written.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glColorMask")]
        public static 
        void ColorMask(bool red, bool green, bool blue, bool alpha)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glColorMask((bool)red, (bool)green, (bool)blue, (bool)alpha);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of colors
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per color. Must be 3 or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each color component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive colors. If stride is 0, the colors are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first color element in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glColorPointer")]
        public static 
        void ColorPointer<T3>(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] ref T3 pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glColorPointer((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                pointer = (T3)pointer_ptr.Target;
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of colors
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per color. Must be 3 or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each color component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive colors. If stride is 0, the colors are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first color element in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glColorPointer")]
        public static 
        void ColorPointer<T3>(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] T3[,,] pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glColorPointer((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of colors
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per color. Must be 3 or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each color component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive colors. If stride is 0, the colors are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first color element in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glColorPointer")]
        public static 
        void ColorPointer<T3>(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] T3[,] pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glColorPointer((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of colors
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per color. Must be 3 or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each color component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive colors. If stride is 0, the colors are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first color element in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glColorPointer")]
        public static 
        void ColorPointer<T3>(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] T3[] pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glColorPointer((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of colors
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per color. Must be 3 or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each color component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive colors. If stride is 0, the colors are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first color element in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glColorPointer")]
        public static 
        void ColorPointer(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, IntPtr pointer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glColorPointer((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be Must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glCompressedTexImage2D")]
        public static 
        void CompressedTexImage2D<T7>(OpenTK.Graphics.ES11.All target, Int32 level, OpenTK.Graphics.ES11.All internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] ref T7 data)
            where T7 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (OpenTK.Graphics.ES11.All)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                data = (T7)data_ptr.Target;
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be Must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glCompressedTexImage2D")]
        public static 
        void CompressedTexImage2D<T7>(OpenTK.Graphics.ES11.All target, Int32 level, OpenTK.Graphics.ES11.All internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T7[,,] data)
            where T7 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (OpenTK.Graphics.ES11.All)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be Must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glCompressedTexImage2D")]
        public static 
        void CompressedTexImage2D<T7>(OpenTK.Graphics.ES11.All target, Int32 level, OpenTK.Graphics.ES11.All internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T7[,] data)
            where T7 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (OpenTK.Graphics.ES11.All)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be Must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glCompressedTexImage2D")]
        public static 
        void CompressedTexImage2D<T7>(OpenTK.Graphics.ES11.All target, Int32 level, OpenTK.Graphics.ES11.All internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T7[] data)
            where T7 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (OpenTK.Graphics.ES11.All)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be Must be 2 sup n + 2 ( border ) for some integer . All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glCompressedTexImage2D")]
        public static 
        void CompressedTexImage2D(OpenTK.Graphics.ES11.All target, Int32 level, OpenTK.Graphics.ES11.All internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, IntPtr data)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glCompressedTexImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (OpenTK.Graphics.ES11.All)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glCompressedTexSubImage2D")]
        public static 
        void CompressedTexSubImage2D<T8>(OpenTK.Graphics.ES11.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES11.All format, Int32 imageSize, [InAttribute, OutAttribute] ref T8 data)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexSubImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES11.All)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                data = (T8)data_ptr.Target;
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glCompressedTexSubImage2D")]
        public static 
        void CompressedTexSubImage2D<T8>(OpenTK.Graphics.ES11.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES11.All format, Int32 imageSize, [InAttribute, OutAttribute] T8[,,] data)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexSubImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES11.All)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glCompressedTexSubImage2D")]
        public static 
        void CompressedTexSubImage2D<T8>(OpenTK.Graphics.ES11.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES11.All format, Int32 imageSize, [InAttribute, OutAttribute] T8[,] data)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexSubImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES11.All)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glCompressedTexSubImage2D")]
        public static 
        void CompressedTexSubImage2D<T8>(OpenTK.Graphics.ES11.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES11.All format, Int32 imageSize, [InAttribute, OutAttribute] T8[] data)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Delegates.glCompressedTexSubImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES11.All)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glCompressedTexSubImage2D")]
        public static 
        void CompressedTexSubImage2D(OpenTK.Graphics.ES11.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES11.All format, Int32 imageSize, IntPtr data)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glCompressedTexSubImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES11.All)format, (Int32)imageSize, (IntPtr)data);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Copy pixels into a 2D texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the internal format of the texture. Must be one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_DEPTH_COMPONENT, GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_RGB, GL_R3_G3_B2, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the lower left corner of the rectangular region of pixels to be copied.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image. Must be 0 or 2 sup n + 2 ( border ) for some integer .
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image. Must be 0 or 2 sup m + 2 ( border ) for some integer .
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glCopyTexImage2D")]
        public static 
        void CopyTexImage2D(OpenTK.Graphics.ES11.All target, Int32 level, OpenTK.Graphics.ES11.All internalformat, Int32 x, Int32 y, Int32 width, Int32 height, Int32 border)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glCopyTexImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (OpenTK.Graphics.ES11.All)internalformat, (Int32)x, (Int32)y, (Int32)width, (Int32)height, (Int32)border);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Copy a two-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the lower left corner of the rectangular region of pixels to be copied.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glCopyTexSubImage2D")]
        public static 
        void CopyTexSubImage2D(OpenTK.Graphics.ES11.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 x, Int32 y, Int32 width, Int32 height)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glCopyTexSubImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)x, (Int32)y, (Int32)width, (Int32)height);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify whether front- or back-facing facets can be culled
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies whether front- or back-facing facets are candidates for culling. Symbolic constants GL_FRONT, GL_BACK, and GL_FRONT_AND_BACK are accepted. The initial value is GL_BACK.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glCullFace")]
        public static 
        void CullFace(OpenTK.Graphics.ES11.All mode)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glCullFace((OpenTK.Graphics.ES11.All)mode);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteBuffers")]
        public static 
        unsafe void DeleteBuffers(Int32 n, Int32* buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDeleteBuffers((Int32)n, (UInt32*)buffers);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteBuffers")]
        public static 
        void DeleteBuffers(Int32 n, Int32[] buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* buffers_ptr = buffers)
                {
                    Delegates.glDeleteBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteBuffers")]
        public static 
        void DeleteBuffers(Int32 n, ref Int32 buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* buffers_ptr = &buffers)
                {
                    Delegates.glDeleteBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteBuffers")]
        public static 
        void DeleteBuffers(Int32 n, ref UInt32 buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* buffers_ptr = &buffers)
                {
                    Delegates.glDeleteBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteBuffers")]
        public static 
        unsafe void DeleteBuffers(Int32 n, UInt32* buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDeleteBuffers((Int32)n, (UInt32*)buffers);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteBuffers")]
        public static 
        void DeleteBuffers(Int32 n, UInt32[] buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* buffers_ptr = buffers)
                {
                    Delegates.glDeleteBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteTextures")]
        public static 
        unsafe void DeleteTextures(Int32 n, Int32* textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDeleteTextures((Int32)n, (UInt32*)textures);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteTextures")]
        public static 
        void DeleteTextures(Int32 n, Int32[] textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* textures_ptr = textures)
                {
                    Delegates.glDeleteTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteTextures")]
        public static 
        void DeleteTextures(Int32 n, ref Int32 textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* textures_ptr = &textures)
                {
                    Delegates.glDeleteTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteTextures")]
        public static 
        void DeleteTextures(Int32 n, ref UInt32 textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* textures_ptr = &textures)
                {
                    Delegates.glDeleteTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteTextures")]
        public static 
        unsafe void DeleteTextures(Int32 n, UInt32* textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDeleteTextures((Int32)n, (UInt32*)textures);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteTextures")]
        public static 
        void DeleteTextures(Int32 n, UInt32[] textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* textures_ptr = textures)
                {
                    Delegates.glDeleteTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the value used for depth buffer comparisons
        /// </summary>
        /// <param name="func">
        /// <para>
        /// Specifies the depth comparison function. Symbolic constants GL_NEVER, GL_LESS, GL_EQUAL, GL_LEQUAL, GL_GREATER, GL_NOTEQUAL, GL_GEQUAL, and GL_ALWAYS are accepted. The initial value is GL_LESS.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDepthFunc")]
        public static 
        void DepthFunc(OpenTK.Graphics.ES11.All func)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDepthFunc((OpenTK.Graphics.ES11.All)func);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Enable or disable writing into the depth buffer
        /// </summary>
        /// <param name="flag">
        /// <para>
        /// Specifies whether the depth buffer is enabled for writing. If flag is GL_FALSE, depth buffer writing is disabled. Otherwise, it is enabled. Initially, depth buffer writing is enabled.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDepthMask")]
        public static 
        void DepthMask(bool flag)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDepthMask((bool)flag);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify mapping of depth values from normalized device coordinates to window coordinates
        /// </summary>
        /// <param name="nearVal">
        /// <para>
        /// Specifies the mapping of the near clipping plane to window coordinates. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="farVal">
        /// <para>
        /// Specifies the mapping of the far clipping plane to window coordinates. The initial value is 1.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDepthRangef")]
        public static 
        void DepthRange(Single zNear, Single zFar)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDepthRangef((Single)zNear, (Single)zFar);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDepthRangex")]
        public static 
        void DepthRangex(int zNear, int zFar)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDepthRangex((int)zNear, (int)zFar);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDisable")]
        public static 
        void Disable(OpenTK.Graphics.ES11.All cap)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDisable((OpenTK.Graphics.ES11.All)cap);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDisableClientState")]
        public static 
        void DisableClientState(OpenTK.Graphics.ES11.All array)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDisableClientState((OpenTK.Graphics.ES11.All)array);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDisableDriverControlQCOM")]
        public static 
        void DisableDriverControlQCOM(Int32 driverControl)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDisableDriverControlQCOM((UInt32)driverControl);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDisableDriverControlQCOM")]
        public static 
        void DisableDriverControlQCOM(UInt32 driverControl)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDisableDriverControlQCOM((UInt32)driverControl);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_QUAD_STRIP, GL_QUADS, and GL_POLYGON are accepted.
        /// </para>
        /// </param>
        /// <param name="first">
        /// <para>
        /// Specifies the starting index in the enabled arrays.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of indices to be rendered.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawArrays")]
        public static 
        void DrawArrays(OpenTK.Graphics.ES11.All mode, Int32 first, Int32 count)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDrawArrays((OpenTK.Graphics.ES11.All)mode, (Int32)first, (Int32)count);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_QUAD_STRIP, GL_QUADS, and GL_POLYGON are accepted.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawElements")]
        public static 
        void DrawElements<T3>(OpenTK.Graphics.ES11.All mode, Int32 count, OpenTK.Graphics.ES11.All type, [InAttribute, OutAttribute] ref T3 indices)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Delegates.glDrawElements((OpenTK.Graphics.ES11.All)mode, (Int32)count, (OpenTK.Graphics.ES11.All)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
                indices = (T3)indices_ptr.Target;
            }
            finally
            {
                indices_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_QUAD_STRIP, GL_QUADS, and GL_POLYGON are accepted.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawElements")]
        public static 
        void DrawElements<T3>(OpenTK.Graphics.ES11.All mode, Int32 count, OpenTK.Graphics.ES11.All type, [InAttribute, OutAttribute] T3[,,] indices)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Delegates.glDrawElements((OpenTK.Graphics.ES11.All)mode, (Int32)count, (OpenTK.Graphics.ES11.All)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
            }
            finally
            {
                indices_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_QUAD_STRIP, GL_QUADS, and GL_POLYGON are accepted.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawElements")]
        public static 
        void DrawElements<T3>(OpenTK.Graphics.ES11.All mode, Int32 count, OpenTK.Graphics.ES11.All type, [InAttribute, OutAttribute] T3[,] indices)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Delegates.glDrawElements((OpenTK.Graphics.ES11.All)mode, (Int32)count, (OpenTK.Graphics.ES11.All)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
            }
            finally
            {
                indices_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_QUAD_STRIP, GL_QUADS, and GL_POLYGON are accepted.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawElements")]
        public static 
        void DrawElements<T3>(OpenTK.Graphics.ES11.All mode, Int32 count, OpenTK.Graphics.ES11.All type, [InAttribute, OutAttribute] T3[] indices)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Delegates.glDrawElements((OpenTK.Graphics.ES11.All)mode, (Int32)count, (OpenTK.Graphics.ES11.All)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
            }
            finally
            {
                indices_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_QUAD_STRIP, GL_QUADS, and GL_POLYGON are accepted.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawElements")]
        public static 
        void DrawElements(OpenTK.Graphics.ES11.All mode, Int32 count, OpenTK.Graphics.ES11.All type, IntPtr indices)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glDrawElements((OpenTK.Graphics.ES11.All)mode, (Int32)count, (OpenTK.Graphics.ES11.All)type, (IntPtr)indices);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Enable or disable server-side GL capabilities
        /// </summary>
        /// <param name="cap">
        /// <para>
        /// Specifies a symbolic constant indicating a GL capability.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glEnable")]
        public static 
        void Enable(OpenTK.Graphics.ES11.All cap)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glEnable((OpenTK.Graphics.ES11.All)cap);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Enable or disable client-side capability
        /// </summary>
        /// <param name="cap">
        /// <para>
        /// Specifies the capability to enable. Symbolic constants GL_COLOR_ARRAY, GL_EDGE_FLAG_ARRAY, GL_FOG_COORD_ARRAY, GL_INDEX_ARRAY, GL_NORMAL_ARRAY, GL_SECONDARY_COLOR_ARRAY, GL_TEXTURE_COORD_ARRAY, and GL_VERTEX_ARRAY are accepted.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glEnableClientState")]
        public static 
        void EnableClientState(OpenTK.Graphics.ES11.All array)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glEnableClientState((OpenTK.Graphics.ES11.All)array);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glEnableDriverControlQCOM")]
        public static 
        void EnableDriverControlQCOM(Int32 driverControl)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glEnableDriverControlQCOM((UInt32)driverControl);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glEnableDriverControlQCOM")]
        public static 
        void EnableDriverControlQCOM(UInt32 driverControl)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glEnableDriverControlQCOM((UInt32)driverControl);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Block until all GL execution is complete
        /// </summary>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFinish")]
        public static 
        void Finish()
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFinish();
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Force execution of GL commands in finite time
        /// </summary>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFlush")]
        public static 
        void Flush()
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFlush();
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify fog parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued fog parameter. GL_FOG_MODE, GL_FOG_DENSITY, GL_FOG_START, GL_FOG_END, GL_FOG_INDEX, and GL_FOG_COORD_SRC are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that pname will be set to.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFogf")]
        public static 
        void Fog(OpenTK.Graphics.ES11.All pname, Single param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFogf((OpenTK.Graphics.ES11.All)pname, (Single)param);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify fog parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued fog parameter. GL_FOG_MODE, GL_FOG_DENSITY, GL_FOG_START, GL_FOG_END, GL_FOG_INDEX, and GL_FOG_COORD_SRC are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that pname will be set to.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFogfv")]
        public static 
        unsafe void Fog(OpenTK.Graphics.ES11.All pname, Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFogfv((OpenTK.Graphics.ES11.All)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify fog parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued fog parameter. GL_FOG_MODE, GL_FOG_DENSITY, GL_FOG_START, GL_FOG_END, GL_FOG_INDEX, and GL_FOG_COORD_SRC are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that pname will be set to.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFogfv")]
        public static 
        void Fog(OpenTK.Graphics.ES11.All pname, Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glFogfv((OpenTK.Graphics.ES11.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFogx")]
        public static 
        void Fogx(OpenTK.Graphics.ES11.All pname, int param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFogx((OpenTK.Graphics.ES11.All)pname, (int)param);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFogxv")]
        public static 
        unsafe void Fogx(OpenTK.Graphics.ES11.All pname, int* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFogxv((OpenTK.Graphics.ES11.All)pname, (int*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFogxv")]
        public static 
        void Fogx(OpenTK.Graphics.ES11.All pname, int[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = @params)
                {
                    Delegates.glFogxv((OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define front- and back-facing polygons
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies the orientation of front-facing polygons. GL_CW and GL_CCW are accepted. The initial value is GL_CCW.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFrontFace")]
        public static 
        void FrontFace(OpenTK.Graphics.ES11.All mode)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFrontFace((OpenTK.Graphics.ES11.All)mode);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Multiply the current matrix by a perspective matrix
        /// </summary>
        /// <param name="left">
        /// <para>
        /// Specify the coordinates for the left and right vertical clipping planes.
        /// </para>
        /// </param>
        /// <param name="bottom">
        /// <para>
        /// Specify the coordinates for the bottom and top horizontal clipping planes.
        /// </para>
        /// </param>
        /// <param name="nearVal">
        /// <para>
        /// Specify the distances to the near and far depth clipping planes. Both distances must be positive.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFrustumf")]
        public static 
        void Frustum(Single left, Single right, Single bottom, Single top, Single zNear, Single zFar)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFrustumf((Single)left, (Single)right, (Single)bottom, (Single)top, (Single)zNear, (Single)zFar);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFrustumx")]
        public static 
        void Frustumx(int left, int right, int bottom, int top, int zNear, int zFar)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glFrustumx((int)left, (int)right, (int)bottom, (int)top, (int)zNear, (int)zFar);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenBuffers")]
        public static 
        unsafe void GenBuffers(Int32 n, Int32* buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGenBuffers((Int32)n, (UInt32*)buffers);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenBuffers")]
        public static 
        void GenBuffers(Int32 n, Int32[] buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* buffers_ptr = buffers)
                {
                    Delegates.glGenBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenBuffers")]
        public static 
        void GenBuffers(Int32 n, ref Int32 buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* buffers_ptr = &buffers)
                {
                    Delegates.glGenBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenBuffers")]
        public static 
        void GenBuffers(Int32 n, ref UInt32 buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* buffers_ptr = &buffers)
                {
                    Delegates.glGenBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenBuffers")]
        public static 
        unsafe void GenBuffers(Int32 n, UInt32* buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGenBuffers((Int32)n, (UInt32*)buffers);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenBuffers")]
        public static 
        void GenBuffers(Int32 n, UInt32[] buffers)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* buffers_ptr = buffers)
                {
                    Delegates.glGenBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenTextures")]
        public static 
        unsafe void GenTextures(Int32 n, Int32* textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGenTextures((Int32)n, (UInt32*)textures);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenTextures")]
        public static 
        void GenTextures(Int32 n, Int32[] textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* textures_ptr = textures)
                {
                    Delegates.glGenTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenTextures")]
        public static 
        void GenTextures(Int32 n, ref Int32 textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* textures_ptr = &textures)
                {
                    Delegates.glGenTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenTextures")]
        public static 
        void GenTextures(Int32 n, ref UInt32 textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* textures_ptr = &textures)
                {
                    Delegates.glGenTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenTextures")]
        public static 
        unsafe void GenTextures(Int32 n, UInt32* textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGenTextures((Int32)n, (UInt32*)textures);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenTextures")]
        public static 
        void GenTextures(Int32 n, UInt32[] textures)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (UInt32* textures_ptr = textures)
                {
                    Delegates.glGenTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetBooleanv")]
        public static 
        unsafe void GetBoolean(OpenTK.Graphics.ES11.All pname, bool* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetBooleanv((OpenTK.Graphics.ES11.All)pname, (bool*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetBooleanv")]
        public static 
        void GetBoolean(OpenTK.Graphics.ES11.All pname, bool[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (bool* @params_ptr = @params)
                {
                    Delegates.glGetBooleanv((OpenTK.Graphics.ES11.All)pname, (bool*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetBooleanv")]
        public static 
        void GetBoolean(OpenTK.Graphics.ES11.All pname, ref bool @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (bool* @params_ptr = &@params)
                {
                    Delegates.glGetBooleanv((OpenTK.Graphics.ES11.All)pname, (bool*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return parameters of a buffer object
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="value">
        /// <para>
        /// Specifies the symbolic name of a buffer object parameter. Accepted values are GL_BUFFER_ACCESS, GL_BUFFER_MAPPED, GL_BUFFER_SIZE, or GL_BUFFER_USAGE.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the requested parameter.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetBufferParameteriv")]
        public static 
        unsafe void GetBufferParameter(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, Int32* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetBufferParameteriv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return parameters of a buffer object
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="value">
        /// <para>
        /// Specifies the symbolic name of a buffer object parameter. Accepted values are GL_BUFFER_ACCESS, GL_BUFFER_MAPPED, GL_BUFFER_SIZE, or GL_BUFFER_USAGE.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the requested parameter.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetBufferParameteriv")]
        public static 
        void GetBufferParameter(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, Int32[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetBufferParameteriv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return parameters of a buffer object
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="value">
        /// <para>
        /// Specifies the symbolic name of a buffer object parameter. Accepted values are GL_BUFFER_ACCESS, GL_BUFFER_MAPPED, GL_BUFFER_SIZE, or GL_BUFFER_USAGE.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the requested parameter.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetBufferParameteriv")]
        public static 
        void GetBufferParameter(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, ref Int32 @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetBufferParameteriv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return the coefficients of the specified clipping plane
        /// </summary>
        /// <param name="plane">
        /// <para>
        /// Specifies a clipping plane. The number of clipping planes depends on the implementation, but at least six clipping planes are supported. They are identified by symbolic names of the form GL_CLIP_PLANE where i ranges from 0 to the value of GL_MAX_CLIP_PLANES - 1.
        /// </para>
        /// </param>
        /// <param name="equation">
        /// <para>
        /// Returns four double-precision values that are the coefficients of the plane equation of plane in eye coordinates. The initial value is (0, 0, 0, 0).
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetClipPlanef")]
        public static 
        void GetClipPlane(OpenTK.Graphics.ES11.All pname, ref Single eqn)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* eqn_ptr = &eqn)
                {
                    Delegates.glGetClipPlanef((OpenTK.Graphics.ES11.All)pname, (Single*)eqn_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return the coefficients of the specified clipping plane
        /// </summary>
        /// <param name="plane">
        /// <para>
        /// Specifies a clipping plane. The number of clipping planes depends on the implementation, but at least six clipping planes are supported. They are identified by symbolic names of the form GL_CLIP_PLANE where i ranges from 0 to the value of GL_MAX_CLIP_PLANES - 1.
        /// </para>
        /// </param>
        /// <param name="equation">
        /// <para>
        /// Returns four double-precision values that are the coefficients of the plane equation of plane in eye coordinates. The initial value is (0, 0, 0, 0).
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetClipPlanef")]
        public static 
        unsafe void GetClipPlane(OpenTK.Graphics.ES11.All pname, Single* eqn)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetClipPlanef((OpenTK.Graphics.ES11.All)pname, (Single*)eqn);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return the coefficients of the specified clipping plane
        /// </summary>
        /// <param name="plane">
        /// <para>
        /// Specifies a clipping plane. The number of clipping planes depends on the implementation, but at least six clipping planes are supported. They are identified by symbolic names of the form GL_CLIP_PLANE where i ranges from 0 to the value of GL_MAX_CLIP_PLANES - 1.
        /// </para>
        /// </param>
        /// <param name="equation">
        /// <para>
        /// Returns four double-precision values that are the coefficients of the plane equation of plane in eye coordinates. The initial value is (0, 0, 0, 0).
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetClipPlanef")]
        public static 
        void GetClipPlane(OpenTK.Graphics.ES11.All pname, Single[] eqn)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* eqn_ptr = eqn)
                {
                    Delegates.glGetClipPlanef((OpenTK.Graphics.ES11.All)pname, (Single*)eqn_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetClipPlanex")]
        public static 
        unsafe void GetClipPlanex(OpenTK.Graphics.ES11.All pname, int* eqn)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetClipPlanex((OpenTK.Graphics.ES11.All)pname, (int*)eqn);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetClipPlanex")]
        public static 
        void GetClipPlanex(OpenTK.Graphics.ES11.All pname, int[] eqn)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* eqn_ptr = eqn)
                {
                    Delegates.glGetClipPlanex((OpenTK.Graphics.ES11.All)pname, (int*)eqn_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetClipPlanex")]
        public static 
        void GetClipPlanex(OpenTK.Graphics.ES11.All pname, ref int eqn)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* eqn_ptr = &eqn)
                {
                    Delegates.glGetClipPlanex((OpenTK.Graphics.ES11.All)pname, (int*)eqn_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetDriverControlsQCOM")]
        public static 
        unsafe void GetDriverControlsQCOM(Int32* num, Int32 size, Int32* driverControls)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetDriverControlsQCOM((Int32*)num, (Int32)size, (UInt32*)driverControls);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetDriverControlsQCOM")]
        public static 
        unsafe void GetDriverControlsQCOM(Int32* num, Int32 size, UInt32* driverControls)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetDriverControlsQCOM((Int32*)num, (Int32)size, (UInt32*)driverControls);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetDriverControlsQCOM")]
        public static 
        void GetDriverControlsQCOM(Int32[] num, Int32 size, Int32[] driverControls)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* num_ptr = num)
                fixed (Int32* driverControls_ptr = driverControls)
                {
                    Delegates.glGetDriverControlsQCOM((Int32*)num_ptr, (Int32)size, (UInt32*)driverControls_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetDriverControlsQCOM")]
        public static 
        void GetDriverControlsQCOM(Int32[] num, Int32 size, UInt32[] driverControls)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* num_ptr = num)
                fixed (UInt32* driverControls_ptr = driverControls)
                {
                    Delegates.glGetDriverControlsQCOM((Int32*)num_ptr, (Int32)size, (UInt32*)driverControls_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetDriverControlsQCOM")]
        public static 
        void GetDriverControlsQCOM(ref Int32 num, Int32 size, ref Int32 driverControls)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* num_ptr = &num)
                fixed (Int32* driverControls_ptr = &driverControls)
                {
                    Delegates.glGetDriverControlsQCOM((Int32*)num_ptr, (Int32)size, (UInt32*)driverControls_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetDriverControlsQCOM")]
        public static 
        void GetDriverControlsQCOM(ref Int32 num, Int32 size, ref UInt32 driverControls)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* num_ptr = &num)
                fixed (UInt32* driverControls_ptr = &driverControls)
                {
                    Delegates.glGetDriverControlsQCOM((Int32*)num_ptr, (Int32)size, (UInt32*)driverControls_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetDriverControlStringQCOM")]
        public static 
        unsafe void GetDriverControlStringQCOM(Int32 driverControl, Int32 bufSize, Int32* length, String driverControlString)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetDriverControlStringQCOM((UInt32)driverControl, (Int32)bufSize, (Int32*)length, (String)driverControlString);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetDriverControlStringQCOM")]
        public static 
        void GetDriverControlStringQCOM(Int32 driverControl, Int32 bufSize, Int32[] length, String driverControlString)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glGetDriverControlStringQCOM((UInt32)driverControl, (Int32)bufSize, (Int32*)length_ptr, (String)driverControlString);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetDriverControlStringQCOM")]
        public static 
        void GetDriverControlStringQCOM(Int32 driverControl, Int32 bufSize, ref Int32 length, String driverControlString)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glGetDriverControlStringQCOM((UInt32)driverControl, (Int32)bufSize, (Int32*)length_ptr, (String)driverControlString);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetDriverControlStringQCOM")]
        public static 
        unsafe void GetDriverControlStringQCOM(UInt32 driverControl, Int32 bufSize, Int32* length, String driverControlString)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetDriverControlStringQCOM((UInt32)driverControl, (Int32)bufSize, (Int32*)length, (String)driverControlString);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetDriverControlStringQCOM")]
        public static 
        void GetDriverControlStringQCOM(UInt32 driverControl, Int32 bufSize, Int32[] length, String driverControlString)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glGetDriverControlStringQCOM((UInt32)driverControl, (Int32)bufSize, (Int32*)length_ptr, (String)driverControlString);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetDriverControlStringQCOM")]
        public static 
        void GetDriverControlStringQCOM(UInt32 driverControl, Int32 bufSize, ref Int32 length, String driverControlString)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glGetDriverControlStringQCOM((UInt32)driverControl, (Int32)bufSize, (Int32*)length_ptr, (String)driverControlString);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return error information
        /// </summary>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetError")]
        public static 
        OpenTK.Graphics.ES11.All GetError()
        {
            return Delegates.glGetError();
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetFixedv")]
        public static 
        unsafe void GetFixed(OpenTK.Graphics.ES11.All pname, int* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetFixedv((OpenTK.Graphics.ES11.All)pname, (int*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetFixedv")]
        public static 
        void GetFixed(OpenTK.Graphics.ES11.All pname, int[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = @params)
                {
                    Delegates.glGetFixedv((OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetFixedv")]
        public static 
        void GetFixed(OpenTK.Graphics.ES11.All pname, ref int @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = &@params)
                {
                    Delegates.glGetFixedv((OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetFloatv")]
        public static 
        void GetFloat(OpenTK.Graphics.ES11.All pname, ref Single @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetFloatv((OpenTK.Graphics.ES11.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetFloatv")]
        public static 
        unsafe void GetFloat(OpenTK.Graphics.ES11.All pname, Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetFloatv((OpenTK.Graphics.ES11.All)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetFloatv")]
        public static 
        void GetFloat(OpenTK.Graphics.ES11.All pname, Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetFloatv((OpenTK.Graphics.ES11.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetIntegerv")]
        public static 
        unsafe void GetInteger(OpenTK.Graphics.ES11.All pname, Int32* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetIntegerv((OpenTK.Graphics.ES11.All)pname, (Int32*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetIntegerv")]
        public static 
        void GetInteger(OpenTK.Graphics.ES11.All pname, Int32[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetIntegerv((OpenTK.Graphics.ES11.All)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetIntegerv")]
        public static 
        void GetInteger(OpenTK.Graphics.ES11.All pname, ref Int32 @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetIntegerv((OpenTK.Graphics.ES11.All)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return light source parameter values
        /// </summary>
        /// <param name="light">
        /// <para>
        /// Specifies a light source. The number of possible lights depends on the implementation, but at least eight lights are supported. They are identified by symbolic names of the form GL_LIGHT where ranges from 0 to the value of GL_MAX_LIGHTS - 1.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies a light source parameter for light. Accepted symbolic names are GL_AMBIENT, GL_DIFFUSE, GL_SPECULAR, GL_POSITION, GL_SPOT_DIRECTION, GL_SPOT_EXPONENT, GL_SPOT_CUTOFF, GL_CONSTANT_ATTENUATION, GL_LINEAR_ATTENUATION, and GL_QUADRATIC_ATTENUATION.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetLightfv")]
        public static 
        void GetLight(OpenTK.Graphics.ES11.All light, OpenTK.Graphics.ES11.All pname, ref Single @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetLightfv((OpenTK.Graphics.ES11.All)light, (OpenTK.Graphics.ES11.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return light source parameter values
        /// </summary>
        /// <param name="light">
        /// <para>
        /// Specifies a light source. The number of possible lights depends on the implementation, but at least eight lights are supported. They are identified by symbolic names of the form GL_LIGHT where ranges from 0 to the value of GL_MAX_LIGHTS - 1.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies a light source parameter for light. Accepted symbolic names are GL_AMBIENT, GL_DIFFUSE, GL_SPECULAR, GL_POSITION, GL_SPOT_DIRECTION, GL_SPOT_EXPONENT, GL_SPOT_CUTOFF, GL_CONSTANT_ATTENUATION, GL_LINEAR_ATTENUATION, and GL_QUADRATIC_ATTENUATION.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetLightfv")]
        public static 
        unsafe void GetLight(OpenTK.Graphics.ES11.All light, OpenTK.Graphics.ES11.All pname, Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetLightfv((OpenTK.Graphics.ES11.All)light, (OpenTK.Graphics.ES11.All)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return light source parameter values
        /// </summary>
        /// <param name="light">
        /// <para>
        /// Specifies a light source. The number of possible lights depends on the implementation, but at least eight lights are supported. They are identified by symbolic names of the form GL_LIGHT where ranges from 0 to the value of GL_MAX_LIGHTS - 1.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies a light source parameter for light. Accepted symbolic names are GL_AMBIENT, GL_DIFFUSE, GL_SPECULAR, GL_POSITION, GL_SPOT_DIRECTION, GL_SPOT_EXPONENT, GL_SPOT_CUTOFF, GL_CONSTANT_ATTENUATION, GL_LINEAR_ATTENUATION, and GL_QUADRATIC_ATTENUATION.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetLightfv")]
        public static 
        void GetLight(OpenTK.Graphics.ES11.All light, OpenTK.Graphics.ES11.All pname, Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetLightfv((OpenTK.Graphics.ES11.All)light, (OpenTK.Graphics.ES11.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetLightxv")]
        public static 
        unsafe void GetLightx(OpenTK.Graphics.ES11.All light, OpenTK.Graphics.ES11.All pname, int* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetLightxv((OpenTK.Graphics.ES11.All)light, (OpenTK.Graphics.ES11.All)pname, (int*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetLightxv")]
        public static 
        void GetLightx(OpenTK.Graphics.ES11.All light, OpenTK.Graphics.ES11.All pname, int[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = @params)
                {
                    Delegates.glGetLightxv((OpenTK.Graphics.ES11.All)light, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetLightxv")]
        public static 
        void GetLightx(OpenTK.Graphics.ES11.All light, OpenTK.Graphics.ES11.All pname, ref int @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = &@params)
                {
                    Delegates.glGetLightxv((OpenTK.Graphics.ES11.All)light, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return material parameters
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies which of the two materials is being queried. GL_FRONT or GL_BACK are accepted, representing the front and back materials, respectively.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the material parameter to return. GL_AMBIENT, GL_DIFFUSE, GL_SPECULAR, GL_EMISSION, GL_SHININESS, and GL_COLOR_INDEXES are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetMaterialfv")]
        public static 
        void GetMaterial(OpenTK.Graphics.ES11.All face, OpenTK.Graphics.ES11.All pname, ref Single @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetMaterialfv((OpenTK.Graphics.ES11.All)face, (OpenTK.Graphics.ES11.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return material parameters
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies which of the two materials is being queried. GL_FRONT or GL_BACK are accepted, representing the front and back materials, respectively.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the material parameter to return. GL_AMBIENT, GL_DIFFUSE, GL_SPECULAR, GL_EMISSION, GL_SHININESS, and GL_COLOR_INDEXES are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetMaterialfv")]
        public static 
        unsafe void GetMaterial(OpenTK.Graphics.ES11.All face, OpenTK.Graphics.ES11.All pname, Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetMaterialfv((OpenTK.Graphics.ES11.All)face, (OpenTK.Graphics.ES11.All)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return material parameters
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies which of the two materials is being queried. GL_FRONT or GL_BACK are accepted, representing the front and back materials, respectively.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the material parameter to return. GL_AMBIENT, GL_DIFFUSE, GL_SPECULAR, GL_EMISSION, GL_SHININESS, and GL_COLOR_INDEXES are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetMaterialfv")]
        public static 
        void GetMaterial(OpenTK.Graphics.ES11.All face, OpenTK.Graphics.ES11.All pname, Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetMaterialfv((OpenTK.Graphics.ES11.All)face, (OpenTK.Graphics.ES11.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetMaterialxv")]
        public static 
        unsafe void GetMaterialx(OpenTK.Graphics.ES11.All face, OpenTK.Graphics.ES11.All pname, int* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetMaterialxv((OpenTK.Graphics.ES11.All)face, (OpenTK.Graphics.ES11.All)pname, (int*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetMaterialxv")]
        public static 
        void GetMaterialx(OpenTK.Graphics.ES11.All face, OpenTK.Graphics.ES11.All pname, int[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = @params)
                {
                    Delegates.glGetMaterialxv((OpenTK.Graphics.ES11.All)face, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetMaterialxv")]
        public static 
        void GetMaterialx(OpenTK.Graphics.ES11.All face, OpenTK.Graphics.ES11.All pname, ref int @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = &@params)
                {
                    Delegates.glGetMaterialxv((OpenTK.Graphics.ES11.All)face, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return the address of the specified pointer
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies the array or buffer pointer to be returned. Symbolic constants GL_COLOR_ARRAY_POINTER, GL_EDGE_FLAG_ARRAY_POINTER, GL_FOG_COORD_ARRAY_POINTER, GL_FEEDBACK_BUFFER_POINTER, GL_INDEX_ARRAY_POINTER, GL_NORMAL_ARRAY_POINTER, GL_SECONDARY_COLOR_ARRAY_POINTER, GL_SELECTION_BUFFER_POINTER, GL_TEXTURE_COORD_ARRAY_POINTER, or GL_VERTEX_ARRAY_POINTER are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the pointer value specified by pname.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetPointerv")]
        public static 
        void GetPointer<T1>(OpenTK.Graphics.ES11.All pname, [InAttribute, OutAttribute] ref T1 @params)
            where T1 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
            try
            {
                Delegates.glGetPointerv((OpenTK.Graphics.ES11.All)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                @params = (T1)@params_ptr.Target;
            }
            finally
            {
                @params_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return the address of the specified pointer
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies the array or buffer pointer to be returned. Symbolic constants GL_COLOR_ARRAY_POINTER, GL_EDGE_FLAG_ARRAY_POINTER, GL_FOG_COORD_ARRAY_POINTER, GL_FEEDBACK_BUFFER_POINTER, GL_INDEX_ARRAY_POINTER, GL_NORMAL_ARRAY_POINTER, GL_SECONDARY_COLOR_ARRAY_POINTER, GL_SELECTION_BUFFER_POINTER, GL_TEXTURE_COORD_ARRAY_POINTER, or GL_VERTEX_ARRAY_POINTER are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the pointer value specified by pname.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetPointerv")]
        public static 
        void GetPointer<T1>(OpenTK.Graphics.ES11.All pname, [InAttribute, OutAttribute] T1[,,] @params)
            where T1 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
            try
            {
                Delegates.glGetPointerv((OpenTK.Graphics.ES11.All)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
            }
            finally
            {
                @params_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return the address of the specified pointer
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies the array or buffer pointer to be returned. Symbolic constants GL_COLOR_ARRAY_POINTER, GL_EDGE_FLAG_ARRAY_POINTER, GL_FOG_COORD_ARRAY_POINTER, GL_FEEDBACK_BUFFER_POINTER, GL_INDEX_ARRAY_POINTER, GL_NORMAL_ARRAY_POINTER, GL_SECONDARY_COLOR_ARRAY_POINTER, GL_SELECTION_BUFFER_POINTER, GL_TEXTURE_COORD_ARRAY_POINTER, or GL_VERTEX_ARRAY_POINTER are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the pointer value specified by pname.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetPointerv")]
        public static 
        void GetPointer<T1>(OpenTK.Graphics.ES11.All pname, [InAttribute, OutAttribute] T1[,] @params)
            where T1 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
            try
            {
                Delegates.glGetPointerv((OpenTK.Graphics.ES11.All)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
            }
            finally
            {
                @params_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return the address of the specified pointer
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies the array or buffer pointer to be returned. Symbolic constants GL_COLOR_ARRAY_POINTER, GL_EDGE_FLAG_ARRAY_POINTER, GL_FOG_COORD_ARRAY_POINTER, GL_FEEDBACK_BUFFER_POINTER, GL_INDEX_ARRAY_POINTER, GL_NORMAL_ARRAY_POINTER, GL_SECONDARY_COLOR_ARRAY_POINTER, GL_SELECTION_BUFFER_POINTER, GL_TEXTURE_COORD_ARRAY_POINTER, or GL_VERTEX_ARRAY_POINTER are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the pointer value specified by pname.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetPointerv")]
        public static 
        void GetPointer<T1>(OpenTK.Graphics.ES11.All pname, [InAttribute, OutAttribute] T1[] @params)
            where T1 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
            try
            {
                Delegates.glGetPointerv((OpenTK.Graphics.ES11.All)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
            }
            finally
            {
                @params_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return the address of the specified pointer
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies the array or buffer pointer to be returned. Symbolic constants GL_COLOR_ARRAY_POINTER, GL_EDGE_FLAG_ARRAY_POINTER, GL_FOG_COORD_ARRAY_POINTER, GL_FEEDBACK_BUFFER_POINTER, GL_INDEX_ARRAY_POINTER, GL_NORMAL_ARRAY_POINTER, GL_SECONDARY_COLOR_ARRAY_POINTER, GL_SELECTION_BUFFER_POINTER, GL_TEXTURE_COORD_ARRAY_POINTER, or GL_VERTEX_ARRAY_POINTER are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the pointer value specified by pname.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetPointerv")]
        public static 
        void GetPointer(OpenTK.Graphics.ES11.All pname, IntPtr @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetPointerv((OpenTK.Graphics.ES11.All)pname, (IntPtr)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return a string describing the current GL connection
        /// </summary>
        /// <param name="name">
        /// <para>
        /// Specifies a symbolic constant, one of GL_VENDOR, GL_RENDERER, GL_VERSION, GL_SHADING_LANGUAGE_VERSION, or GL_EXTENSIONS.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetString")]
        public static 
        unsafe System.String GetString(OpenTK.Graphics.ES11.All name)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe { return new string((sbyte*)Delegates.glGetString((OpenTK.Graphics.ES11.All)name)); }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return texture environment parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies a texture environment. May be GL_TEXTURE_ENV, GL_TEXTURE_FILTER_CONTROL, or GL_POINT_SPRITE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a texture environment parameter. Accepted values are GL_TEXTURE_ENV_MODE, GL_TEXTURE_ENV_COLOR, GL_TEXTURE_LOD_BIAS, GL_COMBINE_RGB, GL_COMBINE_ALPHA, GL_SRC0_RGB, GL_SRC1_RGB, GL_SRC2_RGB, GL_SRC0_ALPHA, GL_SRC1_ALPHA, GL_SRC2_ALPHA, GL_OPERAND0_RGB, GL_OPERAND1_RGB, GL_OPERAND2_RGB, GL_OPERAND0_ALPHA, GL_OPERAND1_ALPHA, GL_OPERAND2_ALPHA, GL_RGB_SCALE, GL_ALPHA_SCALE, or GL_COORD_REPLACE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexEnvfv")]
        public static 
        void GetTexEnv(OpenTK.Graphics.ES11.All env, OpenTK.Graphics.ES11.All pname, ref Single @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetTexEnvfv((OpenTK.Graphics.ES11.All)env, (OpenTK.Graphics.ES11.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return texture environment parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies a texture environment. May be GL_TEXTURE_ENV, GL_TEXTURE_FILTER_CONTROL, or GL_POINT_SPRITE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a texture environment parameter. Accepted values are GL_TEXTURE_ENV_MODE, GL_TEXTURE_ENV_COLOR, GL_TEXTURE_LOD_BIAS, GL_COMBINE_RGB, GL_COMBINE_ALPHA, GL_SRC0_RGB, GL_SRC1_RGB, GL_SRC2_RGB, GL_SRC0_ALPHA, GL_SRC1_ALPHA, GL_SRC2_ALPHA, GL_OPERAND0_RGB, GL_OPERAND1_RGB, GL_OPERAND2_RGB, GL_OPERAND0_ALPHA, GL_OPERAND1_ALPHA, GL_OPERAND2_ALPHA, GL_RGB_SCALE, GL_ALPHA_SCALE, or GL_COORD_REPLACE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexEnvfv")]
        public static 
        unsafe void GetTexEnv(OpenTK.Graphics.ES11.All env, OpenTK.Graphics.ES11.All pname, Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetTexEnvfv((OpenTK.Graphics.ES11.All)env, (OpenTK.Graphics.ES11.All)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return texture environment parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies a texture environment. May be GL_TEXTURE_ENV, GL_TEXTURE_FILTER_CONTROL, or GL_POINT_SPRITE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a texture environment parameter. Accepted values are GL_TEXTURE_ENV_MODE, GL_TEXTURE_ENV_COLOR, GL_TEXTURE_LOD_BIAS, GL_COMBINE_RGB, GL_COMBINE_ALPHA, GL_SRC0_RGB, GL_SRC1_RGB, GL_SRC2_RGB, GL_SRC0_ALPHA, GL_SRC1_ALPHA, GL_SRC2_ALPHA, GL_OPERAND0_RGB, GL_OPERAND1_RGB, GL_OPERAND2_RGB, GL_OPERAND0_ALPHA, GL_OPERAND1_ALPHA, GL_OPERAND2_ALPHA, GL_RGB_SCALE, GL_ALPHA_SCALE, or GL_COORD_REPLACE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexEnvfv")]
        public static 
        void GetTexEnv(OpenTK.Graphics.ES11.All env, OpenTK.Graphics.ES11.All pname, Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetTexEnvfv((OpenTK.Graphics.ES11.All)env, (OpenTK.Graphics.ES11.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return texture environment parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies a texture environment. May be GL_TEXTURE_ENV, GL_TEXTURE_FILTER_CONTROL, or GL_POINT_SPRITE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a texture environment parameter. Accepted values are GL_TEXTURE_ENV_MODE, GL_TEXTURE_ENV_COLOR, GL_TEXTURE_LOD_BIAS, GL_COMBINE_RGB, GL_COMBINE_ALPHA, GL_SRC0_RGB, GL_SRC1_RGB, GL_SRC2_RGB, GL_SRC0_ALPHA, GL_SRC1_ALPHA, GL_SRC2_ALPHA, GL_OPERAND0_RGB, GL_OPERAND1_RGB, GL_OPERAND2_RGB, GL_OPERAND0_ALPHA, GL_OPERAND1_ALPHA, GL_OPERAND2_ALPHA, GL_RGB_SCALE, GL_ALPHA_SCALE, or GL_COORD_REPLACE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexEnviv")]
        public static 
        unsafe void GetTexEnv(OpenTK.Graphics.ES11.All env, OpenTK.Graphics.ES11.All pname, Int32* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetTexEnviv((OpenTK.Graphics.ES11.All)env, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return texture environment parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies a texture environment. May be GL_TEXTURE_ENV, GL_TEXTURE_FILTER_CONTROL, or GL_POINT_SPRITE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a texture environment parameter. Accepted values are GL_TEXTURE_ENV_MODE, GL_TEXTURE_ENV_COLOR, GL_TEXTURE_LOD_BIAS, GL_COMBINE_RGB, GL_COMBINE_ALPHA, GL_SRC0_RGB, GL_SRC1_RGB, GL_SRC2_RGB, GL_SRC0_ALPHA, GL_SRC1_ALPHA, GL_SRC2_ALPHA, GL_OPERAND0_RGB, GL_OPERAND1_RGB, GL_OPERAND2_RGB, GL_OPERAND0_ALPHA, GL_OPERAND1_ALPHA, GL_OPERAND2_ALPHA, GL_RGB_SCALE, GL_ALPHA_SCALE, or GL_COORD_REPLACE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexEnviv")]
        public static 
        void GetTexEnv(OpenTK.Graphics.ES11.All env, OpenTK.Graphics.ES11.All pname, Int32[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetTexEnviv((OpenTK.Graphics.ES11.All)env, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return texture environment parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies a texture environment. May be GL_TEXTURE_ENV, GL_TEXTURE_FILTER_CONTROL, or GL_POINT_SPRITE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a texture environment parameter. Accepted values are GL_TEXTURE_ENV_MODE, GL_TEXTURE_ENV_COLOR, GL_TEXTURE_LOD_BIAS, GL_COMBINE_RGB, GL_COMBINE_ALPHA, GL_SRC0_RGB, GL_SRC1_RGB, GL_SRC2_RGB, GL_SRC0_ALPHA, GL_SRC1_ALPHA, GL_SRC2_ALPHA, GL_OPERAND0_RGB, GL_OPERAND1_RGB, GL_OPERAND2_RGB, GL_OPERAND0_ALPHA, GL_OPERAND1_ALPHA, GL_OPERAND2_ALPHA, GL_RGB_SCALE, GL_ALPHA_SCALE, or GL_COORD_REPLACE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexEnviv")]
        public static 
        void GetTexEnv(OpenTK.Graphics.ES11.All env, OpenTK.Graphics.ES11.All pname, ref Int32 @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetTexEnviv((OpenTK.Graphics.ES11.All)env, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexEnvxv")]
        public static 
        unsafe void GetTexEnvx(OpenTK.Graphics.ES11.All env, OpenTK.Graphics.ES11.All pname, int* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetTexEnvxv((OpenTK.Graphics.ES11.All)env, (OpenTK.Graphics.ES11.All)pname, (int*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexEnvxv")]
        public static 
        void GetTexEnvx(OpenTK.Graphics.ES11.All env, OpenTK.Graphics.ES11.All pname, int[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = @params)
                {
                    Delegates.glGetTexEnvxv((OpenTK.Graphics.ES11.All)env, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexEnvxv")]
        public static 
        void GetTexEnvx(OpenTK.Graphics.ES11.All env, OpenTK.Graphics.ES11.All pname, ref int @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = &@params)
                {
                    Delegates.glGetTexEnvxv((OpenTK.Graphics.ES11.All)env, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return texture parameter values
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the symbolic name of the target texture. GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, and GL_TEXTURE_CUBE_MAP are accepted.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a texture parameter. GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_PRIORITY, GL_TEXTURE_RESIDENT, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, and GL_GENERATE_MIPMAP are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the texture parameters.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexParameterfv")]
        public static 
        void GetTexParameter(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, ref Single @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetTexParameterfv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return texture parameter values
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the symbolic name of the target texture. GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, and GL_TEXTURE_CUBE_MAP are accepted.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a texture parameter. GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_PRIORITY, GL_TEXTURE_RESIDENT, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, and GL_GENERATE_MIPMAP are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the texture parameters.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexParameterfv")]
        public static 
        unsafe void GetTexParameter(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetTexParameterfv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return texture parameter values
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the symbolic name of the target texture. GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, and GL_TEXTURE_CUBE_MAP are accepted.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a texture parameter. GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_PRIORITY, GL_TEXTURE_RESIDENT, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, and GL_GENERATE_MIPMAP are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the texture parameters.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexParameterfv")]
        public static 
        void GetTexParameter(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetTexParameterfv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return texture parameter values
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the symbolic name of the target texture. GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, and GL_TEXTURE_CUBE_MAP are accepted.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a texture parameter. GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_PRIORITY, GL_TEXTURE_RESIDENT, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, and GL_GENERATE_MIPMAP are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the texture parameters.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexParameteriv")]
        public static 
        unsafe void GetTexParameter(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, Int32* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetTexParameteriv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return texture parameter values
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the symbolic name of the target texture. GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, and GL_TEXTURE_CUBE_MAP are accepted.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a texture parameter. GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_PRIORITY, GL_TEXTURE_RESIDENT, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, and GL_GENERATE_MIPMAP are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the texture parameters.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexParameteriv")]
        public static 
        void GetTexParameter(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, Int32[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetTexParameteriv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Return texture parameter values
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the symbolic name of the target texture. GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, and GL_TEXTURE_CUBE_MAP are accepted.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a texture parameter. GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_BORDER_COLOR, GL_TEXTURE_PRIORITY, GL_TEXTURE_RESIDENT, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, and GL_GENERATE_MIPMAP are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the texture parameters.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexParameteriv")]
        public static 
        void GetTexParameter(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, ref Int32 @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetTexParameteriv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexParameterxv")]
        public static 
        unsafe void GetTexParameterx(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, int* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glGetTexParameterxv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (int*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexParameterxv")]
        public static 
        void GetTexParameterx(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, int[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = @params)
                {
                    Delegates.glGetTexParameterxv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexParameterxv")]
        public static 
        void GetTexParameterx(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, ref int @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = &@params)
                {
                    Delegates.glGetTexParameterxv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify implementation-specific hints
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies a symbolic constant indicating the behavior to be controlled. GL_FOG_HINT, GL_GENERATE_MIPMAP_HINT, GL_LINE_SMOOTH_HINT, GL_PERSPECTIVE_CORRECTION_HINT, GL_POINT_SMOOTH_HINT, GL_POLYGON_SMOOTH_HINT, GL_TEXTURE_COMPRESSION_HINT, and GL_FRAGMENT_SHADER_DERIVATIVE_HINT are accepted.
        /// </para>
        /// </param>
        /// <param name="mode">
        /// <para>
        /// Specifies a symbolic constant indicating the desired behavior. GL_FASTEST, GL_NICEST, and GL_DONT_CARE are accepted.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glHint")]
        public static 
        void Hint(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All mode)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glHint((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)mode);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Determine if a name corresponds to a buffer object
        /// </summary>
        /// <param name="buffer">
        /// <para>
        /// Specifies a value that may be the name of a buffer object.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glIsBuffer")]
        public static 
        bool IsBuffer(Int32 buffer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glIsBuffer((UInt32)buffer);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Determine if a name corresponds to a buffer object
        /// </summary>
        /// <param name="buffer">
        /// <para>
        /// Specifies a value that may be the name of a buffer object.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glIsBuffer")]
        public static 
        bool IsBuffer(UInt32 buffer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glIsBuffer((UInt32)buffer);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Test whether a capability is enabled
        /// </summary>
        /// <param name="cap">
        /// <para>
        /// Specifies a symbolic constant indicating a GL capability.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glIsEnabled")]
        public static 
        bool IsEnabled(OpenTK.Graphics.ES11.All cap)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glIsEnabled((OpenTK.Graphics.ES11.All)cap);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Determine if a name corresponds to a texture
        /// </summary>
        /// <param name="texture">
        /// <para>
        /// Specifies a value that may be the name of a texture.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glIsTexture")]
        public static 
        bool IsTexture(Int32 texture)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glIsTexture((UInt32)texture);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Determine if a name corresponds to a texture
        /// </summary>
        /// <param name="texture">
        /// <para>
        /// Specifies a value that may be the name of a texture.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glIsTexture")]
        public static 
        bool IsTexture(UInt32 texture)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            return Delegates.glIsTexture((UInt32)texture);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set light source parameters
        /// </summary>
        /// <param name="light">
        /// <para>
        /// Specifies a light. The number of lights depends on the implementation, but at least eight lights are supported. They are identified by symbolic names of the form GL_LIGHT , where i ranges from 0 to the value of GL_MAX_LIGHTS - 1.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued light source parameter for light. GL_SPOT_EXPONENT, GL_SPOT_CUTOFF, GL_CONSTANT_ATTENUATION, GL_LINEAR_ATTENUATION, and GL_QUADRATIC_ATTENUATION are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that parameter pname of light source light will be set to.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLightf")]
        public static 
        void Light(OpenTK.Graphics.ES11.All light, OpenTK.Graphics.ES11.All pname, Single param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLightf((OpenTK.Graphics.ES11.All)light, (OpenTK.Graphics.ES11.All)pname, (Single)param);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set light source parameters
        /// </summary>
        /// <param name="light">
        /// <para>
        /// Specifies a light. The number of lights depends on the implementation, but at least eight lights are supported. They are identified by symbolic names of the form GL_LIGHT , where i ranges from 0 to the value of GL_MAX_LIGHTS - 1.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued light source parameter for light. GL_SPOT_EXPONENT, GL_SPOT_CUTOFF, GL_CONSTANT_ATTENUATION, GL_LINEAR_ATTENUATION, and GL_QUADRATIC_ATTENUATION are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that parameter pname of light source light will be set to.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLightfv")]
        public static 
        unsafe void Light(OpenTK.Graphics.ES11.All light, OpenTK.Graphics.ES11.All pname, Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLightfv((OpenTK.Graphics.ES11.All)light, (OpenTK.Graphics.ES11.All)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set light source parameters
        /// </summary>
        /// <param name="light">
        /// <para>
        /// Specifies a light. The number of lights depends on the implementation, but at least eight lights are supported. They are identified by symbolic names of the form GL_LIGHT , where i ranges from 0 to the value of GL_MAX_LIGHTS - 1.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued light source parameter for light. GL_SPOT_EXPONENT, GL_SPOT_CUTOFF, GL_CONSTANT_ATTENUATION, GL_LINEAR_ATTENUATION, and GL_QUADRATIC_ATTENUATION are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that parameter pname of light source light will be set to.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLightfv")]
        public static 
        void Light(OpenTK.Graphics.ES11.All light, OpenTK.Graphics.ES11.All pname, Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glLightfv((OpenTK.Graphics.ES11.All)light, (OpenTK.Graphics.ES11.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set the lighting model parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued lighting model parameter. GL_LIGHT_MODEL_LOCAL_VIEWER, GL_LIGHT_MODEL_COLOR_CONTROL, and GL_LIGHT_MODEL_TWO_SIDE are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that param will be set to.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLightModelf")]
        public static 
        void LightModel(OpenTK.Graphics.ES11.All pname, Single param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLightModelf((OpenTK.Graphics.ES11.All)pname, (Single)param);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set the lighting model parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued lighting model parameter. GL_LIGHT_MODEL_LOCAL_VIEWER, GL_LIGHT_MODEL_COLOR_CONTROL, and GL_LIGHT_MODEL_TWO_SIDE are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that param will be set to.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLightModelfv")]
        public static 
        unsafe void LightModel(OpenTK.Graphics.ES11.All pname, Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLightModelfv((OpenTK.Graphics.ES11.All)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set the lighting model parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued lighting model parameter. GL_LIGHT_MODEL_LOCAL_VIEWER, GL_LIGHT_MODEL_COLOR_CONTROL, and GL_LIGHT_MODEL_TWO_SIDE are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that param will be set to.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLightModelfv")]
        public static 
        void LightModel(OpenTK.Graphics.ES11.All pname, Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glLightModelfv((OpenTK.Graphics.ES11.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLightModelx")]
        public static 
        void LightModelx(OpenTK.Graphics.ES11.All pname, int param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLightModelx((OpenTK.Graphics.ES11.All)pname, (int)param);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLightModelxv")]
        public static 
        unsafe void LightModelx(OpenTK.Graphics.ES11.All pname, int* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLightModelxv((OpenTK.Graphics.ES11.All)pname, (int*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLightModelxv")]
        public static 
        void LightModelx(OpenTK.Graphics.ES11.All pname, int[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = @params)
                {
                    Delegates.glLightModelxv((OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLightx")]
        public static 
        void Lightx(OpenTK.Graphics.ES11.All light, OpenTK.Graphics.ES11.All pname, int param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLightx((OpenTK.Graphics.ES11.All)light, (OpenTK.Graphics.ES11.All)pname, (int)param);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLightxv")]
        public static 
        unsafe void Lightx(OpenTK.Graphics.ES11.All light, OpenTK.Graphics.ES11.All pname, int* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLightxv((OpenTK.Graphics.ES11.All)light, (OpenTK.Graphics.ES11.All)pname, (int*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLightxv")]
        public static 
        void Lightx(OpenTK.Graphics.ES11.All light, OpenTK.Graphics.ES11.All pname, int[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = @params)
                {
                    Delegates.glLightxv((OpenTK.Graphics.ES11.All)light, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the width of rasterized lines
        /// </summary>
        /// <param name="width">
        /// <para>
        /// Specifies the width of rasterized lines. The initial value is 1.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLineWidth")]
        public static 
        void LineWidth(Single width)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLineWidth((Single)width);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLineWidthx")]
        public static 
        void LineWidthx(int width)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLineWidthx((int)width);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Replace the current matrix with the identity matrix
        /// </summary>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLoadIdentity")]
        public static 
        void LoadIdentity()
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLoadIdentity();
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Replace the current matrix with the specified matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Specifies a pointer to 16 consecutive values, which are used as the elements of a 4 times 4 column-major matrix.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLoadMatrixf")]
        public static 
        void LoadMatrix(ref Single m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* m_ptr = &m)
                {
                    Delegates.glLoadMatrixf((Single*)m_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Replace the current matrix with the specified matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Specifies a pointer to 16 consecutive values, which are used as the elements of a 4 times 4 column-major matrix.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLoadMatrixf")]
        public static 
        unsafe void LoadMatrix(Single* m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLoadMatrixf((Single*)m);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Replace the current matrix with the specified matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Specifies a pointer to 16 consecutive values, which are used as the elements of a 4 times 4 column-major matrix.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLoadMatrixf")]
        public static 
        void LoadMatrix(Single[] m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* m_ptr = m)
                {
                    Delegates.glLoadMatrixf((Single*)m_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLoadMatrixx")]
        public static 
        unsafe void LoadMatrixx(int* m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLoadMatrixx((int*)m);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLoadMatrixx")]
        public static 
        void LoadMatrixx(int[] m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* m_ptr = m)
                {
                    Delegates.glLoadMatrixx((int*)m_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLoadMatrixx")]
        public static 
        void LoadMatrixx(ref int m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* m_ptr = &m)
                {
                    Delegates.glLoadMatrixx((int*)m_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a logical pixel operation for color index rendering
        /// </summary>
        /// <param name="opcode">
        /// <para>
        /// Specifies a symbolic constant that selects a logical operation. The following symbols are accepted: GL_CLEAR, GL_SET, GL_COPY, GL_COPY_INVERTED, GL_NOOP, GL_INVERT, GL_AND, GL_NAND, GL_OR, GL_NOR, GL_XOR, GL_EQUIV, GL_AND_REVERSE, GL_AND_INVERTED, GL_OR_REVERSE, and GL_OR_INVERTED. The initial value is GL_COPY.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLogicOp")]
        public static 
        void LogicOp(OpenTK.Graphics.ES11.All opcode)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glLogicOp((OpenTK.Graphics.ES11.All)opcode);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify material parameters for the lighting model
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies which face or faces are being updated. Must be one of GL_FRONT, GL_BACK, or GL_FRONT_AND_BACK.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the single-valued material parameter of the face or faces that is being updated. Must be GL_SHININESS.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that parameter GL_SHININESS will be set to.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMaterialf")]
        public static 
        void Material(OpenTK.Graphics.ES11.All face, OpenTK.Graphics.ES11.All pname, Single param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glMaterialf((OpenTK.Graphics.ES11.All)face, (OpenTK.Graphics.ES11.All)pname, (Single)param);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify material parameters for the lighting model
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies which face or faces are being updated. Must be one of GL_FRONT, GL_BACK, or GL_FRONT_AND_BACK.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the single-valued material parameter of the face or faces that is being updated. Must be GL_SHININESS.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that parameter GL_SHININESS will be set to.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMaterialfv")]
        public static 
        unsafe void Material(OpenTK.Graphics.ES11.All face, OpenTK.Graphics.ES11.All pname, Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glMaterialfv((OpenTK.Graphics.ES11.All)face, (OpenTK.Graphics.ES11.All)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify material parameters for the lighting model
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies which face or faces are being updated. Must be one of GL_FRONT, GL_BACK, or GL_FRONT_AND_BACK.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the single-valued material parameter of the face or faces that is being updated. Must be GL_SHININESS.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that parameter GL_SHININESS will be set to.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMaterialfv")]
        public static 
        void Material(OpenTK.Graphics.ES11.All face, OpenTK.Graphics.ES11.All pname, Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glMaterialfv((OpenTK.Graphics.ES11.All)face, (OpenTK.Graphics.ES11.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMaterialx")]
        public static 
        void Materialx(OpenTK.Graphics.ES11.All face, OpenTK.Graphics.ES11.All pname, int param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glMaterialx((OpenTK.Graphics.ES11.All)face, (OpenTK.Graphics.ES11.All)pname, (int)param);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMaterialxv")]
        public static 
        unsafe void Materialx(OpenTK.Graphics.ES11.All face, OpenTK.Graphics.ES11.All pname, int* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glMaterialxv((OpenTK.Graphics.ES11.All)face, (OpenTK.Graphics.ES11.All)pname, (int*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMaterialxv")]
        public static 
        void Materialx(OpenTK.Graphics.ES11.All face, OpenTK.Graphics.ES11.All pname, int[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = @params)
                {
                    Delegates.glMaterialxv((OpenTK.Graphics.ES11.All)face, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify which matrix is the current matrix
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies which matrix stack is the target for subsequent matrix operations. Three values are accepted: GL_MODELVIEW, GL_PROJECTION, and GL_TEXTURE. The initial value is GL_MODELVIEW. Additionally, if the ARB_imaging extension is supported, GL_COLOR is also accepted.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMatrixMode")]
        public static 
        void MatrixMode(OpenTK.Graphics.ES11.All mode)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glMatrixMode((OpenTK.Graphics.ES11.All)mode);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set the current texture coordinates
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the texture unit whose coordinates should be modified. The number of texture units is implementation dependent, but must be at least two. Symbolic constant must be one of GL_TEXTURE, where i ranges from 0 to GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value.
        /// </para>
        /// </param>
        /// <param name="s">
        /// <para>
        /// Specify s, t, r, and q texture coordinates for target texture unit. Not all parameters are present in all forms of the command.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMultiTexCoord4f")]
        public static 
        void MultiTexCoord4(OpenTK.Graphics.ES11.All target, Single s, Single t, Single r, Single q)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glMultiTexCoord4f((OpenTK.Graphics.ES11.All)target, (Single)s, (Single)t, (Single)r, (Single)q);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMultiTexCoord4x")]
        public static 
        void MultiTexCoord4x(OpenTK.Graphics.ES11.All target, int s, int t, int r, int q)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glMultiTexCoord4x((OpenTK.Graphics.ES11.All)target, (int)s, (int)t, (int)r, (int)q);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Multiply the current matrix with the specified matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Points to 16 consecutive values that are used as the elements of a 4 times 4 column-major matrix.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMultMatrixf")]
        public static 
        void MultMatrix(ref Single m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* m_ptr = &m)
                {
                    Delegates.glMultMatrixf((Single*)m_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Multiply the current matrix with the specified matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Points to 16 consecutive values that are used as the elements of a 4 times 4 column-major matrix.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMultMatrixf")]
        public static 
        unsafe void MultMatrix(Single* m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glMultMatrixf((Single*)m);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Multiply the current matrix with the specified matrix
        /// </summary>
        /// <param name="m">
        /// <para>
        /// Points to 16 consecutive values that are used as the elements of a 4 times 4 column-major matrix.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMultMatrixf")]
        public static 
        void MultMatrix(Single[] m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* m_ptr = m)
                {
                    Delegates.glMultMatrixf((Single*)m_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMultMatrixx")]
        public static 
        unsafe void MultMatrixx(int* m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glMultMatrixx((int*)m);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMultMatrixx")]
        public static 
        void MultMatrixx(int[] m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* m_ptr = m)
                {
                    Delegates.glMultMatrixx((int*)m_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMultMatrixx")]
        public static 
        void MultMatrixx(ref int m)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* m_ptr = &m)
                {
                    Delegates.glMultMatrixx((int*)m_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set the current normal vector
        /// </summary>
        /// <param name="nx">
        /// <para>
        /// Specify the , , and coordinates of the new current normal. The initial value of the current normal is the unit vector, (0, 0, 1).
        /// </para>
        /// <para>
        /// 
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glNormal3f")]
        public static 
        void Normal3(Single nx, Single ny, Single nz)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glNormal3f((Single)nx, (Single)ny, (Single)nz);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glNormal3x")]
        public static 
        void Normal3x(int nx, int ny, int nz)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glNormal3x((int)nx, (int)ny, (int)nz);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of normals
        /// </summary>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each coordinate in the array. Symbolic constants GL_BYTE, GL_SHORT, GL_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive normals. If stride is 0, the normals are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first normal in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glNormalPointer")]
        public static 
        void NormalPointer<T2>(OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] ref T2 pointer)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glNormalPointer((OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                pointer = (T2)pointer_ptr.Target;
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of normals
        /// </summary>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each coordinate in the array. Symbolic constants GL_BYTE, GL_SHORT, GL_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive normals. If stride is 0, the normals are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first normal in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glNormalPointer")]
        public static 
        void NormalPointer<T2>(OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] T2[,,] pointer)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glNormalPointer((OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of normals
        /// </summary>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each coordinate in the array. Symbolic constants GL_BYTE, GL_SHORT, GL_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive normals. If stride is 0, the normals are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first normal in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glNormalPointer")]
        public static 
        void NormalPointer<T2>(OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] T2[,] pointer)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glNormalPointer((OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of normals
        /// </summary>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each coordinate in the array. Symbolic constants GL_BYTE, GL_SHORT, GL_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive normals. If stride is 0, the normals are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first normal in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glNormalPointer")]
        public static 
        void NormalPointer<T2>(OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] T2[] pointer)
            where T2 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glNormalPointer((OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of normals
        /// </summary>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each coordinate in the array. Symbolic constants GL_BYTE, GL_SHORT, GL_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive normals. If stride is 0, the normals are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first normal in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glNormalPointer")]
        public static 
        void NormalPointer(OpenTK.Graphics.ES11.All type, Int32 stride, IntPtr pointer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glNormalPointer((OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Multiply the current matrix with an orthographic matrix
        /// </summary>
        /// <param name="left">
        /// <para>
        /// Specify the coordinates for the left and right vertical clipping planes.
        /// </para>
        /// </param>
        /// <param name="bottom">
        /// <para>
        /// Specify the coordinates for the bottom and top horizontal clipping planes.
        /// </para>
        /// </param>
        /// <param name="nearVal">
        /// <para>
        /// Specify the distances to the nearer and farther depth clipping planes. These values are negative if the plane is to be behind the viewer.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glOrthof")]
        public static 
        void Ortho(Single left, Single right, Single bottom, Single top, Single zNear, Single zFar)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glOrthof((Single)left, (Single)right, (Single)bottom, (Single)top, (Single)zNear, (Single)zFar);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glOrthox")]
        public static 
        void Orthox(int left, int right, int bottom, int top, int zNear, int zFar)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glOrthox((int)left, (int)right, (int)bottom, (int)top, (int)zNear, (int)zFar);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set pixel storage modes
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the parameter to be set. Six values affect the packing of pixel data into memory: GL_PACK_SWAP_BYTES, GL_PACK_LSB_FIRST, GL_PACK_ROW_LENGTH, GL_PACK_IMAGE_HEIGHT, GL_PACK_SKIP_PIXELS, GL_PACK_SKIP_ROWS, GL_PACK_SKIP_IMAGES, and GL_PACK_ALIGNMENT. Six more affect the unpacking of pixel data from memory: GL_UNPACK_SWAP_BYTES, GL_UNPACK_LSB_FIRST, GL_UNPACK_ROW_LENGTH, GL_UNPACK_IMAGE_HEIGHT, GL_UNPACK_SKIP_PIXELS, GL_UNPACK_SKIP_ROWS, GL_UNPACK_SKIP_IMAGES, and GL_UNPACK_ALIGNMENT.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that pname is set to.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPixelStorei")]
        public static 
        void PixelStore(OpenTK.Graphics.ES11.All pname, Int32 param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glPixelStorei((OpenTK.Graphics.ES11.All)pname, (Int32)param);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify point parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued point parameter. GL_POINT_SIZE_MIN, GL_POINT_SIZE_MAX, GL_POINT_FADE_THRESHOLD_SIZE, and GL_POINT_SPRITE_COORD_ORIGIN are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that pname will be set to.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPointParameterf")]
        public static 
        void PointParameter(OpenTK.Graphics.ES11.All pname, Single param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glPointParameterf((OpenTK.Graphics.ES11.All)pname, (Single)param);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify point parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued point parameter. GL_POINT_SIZE_MIN, GL_POINT_SIZE_MAX, GL_POINT_FADE_THRESHOLD_SIZE, and GL_POINT_SPRITE_COORD_ORIGIN are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that pname will be set to.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPointParameterfv")]
        public static 
        unsafe void PointParameter(OpenTK.Graphics.ES11.All pname, Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glPointParameterfv((OpenTK.Graphics.ES11.All)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify point parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued point parameter. GL_POINT_SIZE_MIN, GL_POINT_SIZE_MAX, GL_POINT_FADE_THRESHOLD_SIZE, and GL_POINT_SPRITE_COORD_ORIGIN are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that pname will be set to.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPointParameterfv")]
        public static 
        void PointParameter(OpenTK.Graphics.ES11.All pname, Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glPointParameterfv((OpenTK.Graphics.ES11.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPointParameterx")]
        public static 
        void PointParameterx(OpenTK.Graphics.ES11.All pname, int param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glPointParameterx((OpenTK.Graphics.ES11.All)pname, (int)param);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPointParameterxv")]
        public static 
        unsafe void PointParameterx(OpenTK.Graphics.ES11.All pname, int* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glPointParameterxv((OpenTK.Graphics.ES11.All)pname, (int*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPointParameterxv")]
        public static 
        void PointParameterx(OpenTK.Graphics.ES11.All pname, int[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = @params)
                {
                    Delegates.glPointParameterxv((OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify the diameter of rasterized points
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the diameter of rasterized points. The initial value is 1.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPointSize")]
        public static 
        void PointSize(Single size)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glPointSize((Single)size);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPointSizex")]
        public static 
        void PointSizex(int size)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glPointSizex((int)size);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set the scale and units used to calculate depth values
        /// </summary>
        /// <param name="factor">
        /// <para>
        /// Specifies a scale factor that is used to create a variable depth offset for each polygon. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="units">
        /// <para>
        /// Is multiplied by an implementation-specific value to create a constant depth offset. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPolygonOffset")]
        public static 
        void PolygonOffset(Single factor, Single units)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glPolygonOffset((Single)factor, (Single)units);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPolygonOffsetx")]
        public static 
        void PolygonOffsetx(int factor, int units)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glPolygonOffsetx((int)factor, (int)units);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPopMatrix")]
        public static 
        void PopMatrix()
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glPopMatrix();
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Push and pop the current matrix stack
        /// </summary>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPushMatrix")]
        public static 
        void PushMatrix()
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glPushMatrix();
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Read a block of pixels from the frame buffer
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the first pixel that is read from the frame buffer. This location is the lower left corner of a rectangular block of pixels.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the dimensions of the pixel rectangle. width and height of one correspond to a single pixel.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. Must be one of GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, or GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glReadPixels")]
        public static 
        void ReadPixels<T6>(Int32 x, Int32 y, Int32 width, Int32 height, OpenTK.Graphics.ES11.All format, OpenTK.Graphics.ES11.All type, [InAttribute, OutAttribute] ref T6 pixels)
            where T6 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glReadPixels((Int32)x, (Int32)y, (Int32)width, (Int32)height, (OpenTK.Graphics.ES11.All)format, (OpenTK.Graphics.ES11.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                pixels = (T6)pixels_ptr.Target;
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Read a block of pixels from the frame buffer
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the first pixel that is read from the frame buffer. This location is the lower left corner of a rectangular block of pixels.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the dimensions of the pixel rectangle. width and height of one correspond to a single pixel.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. Must be one of GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, or GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glReadPixels")]
        public static 
        void ReadPixels<T6>(Int32 x, Int32 y, Int32 width, Int32 height, OpenTK.Graphics.ES11.All format, OpenTK.Graphics.ES11.All type, [InAttribute, OutAttribute] T6[,,] pixels)
            where T6 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glReadPixels((Int32)x, (Int32)y, (Int32)width, (Int32)height, (OpenTK.Graphics.ES11.All)format, (OpenTK.Graphics.ES11.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Read a block of pixels from the frame buffer
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the first pixel that is read from the frame buffer. This location is the lower left corner of a rectangular block of pixels.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the dimensions of the pixel rectangle. width and height of one correspond to a single pixel.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. Must be one of GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, or GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glReadPixels")]
        public static 
        void ReadPixels<T6>(Int32 x, Int32 y, Int32 width, Int32 height, OpenTK.Graphics.ES11.All format, OpenTK.Graphics.ES11.All type, [InAttribute, OutAttribute] T6[,] pixels)
            where T6 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glReadPixels((Int32)x, (Int32)y, (Int32)width, (Int32)height, (OpenTK.Graphics.ES11.All)format, (OpenTK.Graphics.ES11.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Read a block of pixels from the frame buffer
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the first pixel that is read from the frame buffer. This location is the lower left corner of a rectangular block of pixels.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the dimensions of the pixel rectangle. width and height of one correspond to a single pixel.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. Must be one of GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, or GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glReadPixels")]
        public static 
        void ReadPixels<T6>(Int32 x, Int32 y, Int32 width, Int32 height, OpenTK.Graphics.ES11.All format, OpenTK.Graphics.ES11.All type, [InAttribute, OutAttribute] T6[] pixels)
            where T6 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glReadPixels((Int32)x, (Int32)y, (Int32)width, (Int32)height, (OpenTK.Graphics.ES11.All)format, (OpenTK.Graphics.ES11.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Read a block of pixels from the frame buffer
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the first pixel that is read from the frame buffer. This location is the lower left corner of a rectangular block of pixels.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the dimensions of the pixel rectangle. width and height of one correspond to a single pixel.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. Must be one of GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, or GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel data.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glReadPixels")]
        public static 
        void ReadPixels(Int32 x, Int32 y, Int32 width, Int32 height, OpenTK.Graphics.ES11.All format, OpenTK.Graphics.ES11.All type, IntPtr pixels)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glReadPixels((Int32)x, (Int32)y, (Int32)width, (Int32)height, (OpenTK.Graphics.ES11.All)format, (OpenTK.Graphics.ES11.All)type, (IntPtr)pixels);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Multiply the current matrix by a rotation matrix
        /// </summary>
        /// <param name="angle">
        /// <para>
        /// Specifies the angle of rotation, in degrees.
        /// </para>
        /// </param>
        /// <param name="x">
        /// <para>
        /// Specify the x, y, and z coordinates of a vector, respectively.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glRotatef")]
        public static 
        void Rotate(Single angle, Single x, Single y, Single z)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glRotatef((Single)angle, (Single)x, (Single)y, (Single)z);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glRotatex")]
        public static 
        void Rotatex(int angle, int x, int y, int z)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glRotatex((int)angle, (int)x, (int)y, (int)z);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify multisample coverage parameters
        /// </summary>
        /// <param name="value">
        /// <para>
        /// Specify a single floating-point sample coverage value. The value is clamped to the range [0 ,1]. The initial value is 1.0.
        /// </para>
        /// </param>
        /// <param name="invert">
        /// <para>
        /// Specify a single boolean value representing if the coverage masks should be inverted. GL_TRUE and GL_FALSE are accepted. The initial value is GL_FALSE.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glSampleCoverage")]
        public static 
        void SampleCoverage(Single value, bool invert)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glSampleCoverage((Single)value, (bool)invert);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glSampleCoveragex")]
        public static 
        void SampleCoveragex(int value, bool invert)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glSampleCoveragex((int)value, (bool)invert);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Multiply the current matrix by a general scaling matrix
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify scale factors along the x, y, and z axes, respectively.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glScalef")]
        public static 
        void Scale(Single x, Single y, Single z)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glScalef((Single)x, (Single)y, (Single)z);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glScalex")]
        public static 
        void Scalex(int x, int y, int z)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glScalex((int)x, (int)y, (int)z);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define the scissor box
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the lower left corner of the scissor box. Initially (0, 0).
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the width and height of the scissor box. When a GL context is first attached to a window, width and height are set to the dimensions of that window.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glScissor")]
        public static 
        void Scissor(Int32 x, Int32 y, Int32 width, Int32 height)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glScissor((Int32)x, (Int32)y, (Int32)width, (Int32)height);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Select flat or smooth shading
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies a symbolic value representing a shading technique. Accepted values are GL_FLAT and GL_SMOOTH. The initial value is GL_SMOOTH.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glShadeModel")]
        public static 
        void ShadeModel(OpenTK.Graphics.ES11.All mode)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glShadeModel((OpenTK.Graphics.ES11.All)mode);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set front and back function and reference value for stencil testing
        /// </summary>
        /// <param name="func">
        /// <para>
        /// Specifies the test function. Eight symbolic constants are valid: GL_NEVER, GL_LESS, GL_LEQUAL, GL_GREATER, GL_GEQUAL, GL_EQUAL, GL_NOTEQUAL, and GL_ALWAYS. The initial value is GL_ALWAYS.
        /// </para>
        /// </param>
        /// <param name="ref">
        /// <para>
        /// Specifies the reference value for the stencil test. ref is clamped to the range [0, 2 sup n - 1], where is the number of bitplanes in the stencil buffer. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="mask">
        /// <para>
        /// Specifies a mask that is ANDed with both the reference value and the stored stencil value when the test is done. The initial value is all 1's.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glStencilFunc")]
        public static 
        void StencilFunc(OpenTK.Graphics.ES11.All func, Int32 @ref, Int32 mask)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glStencilFunc((OpenTK.Graphics.ES11.All)func, (Int32)@ref, (UInt32)mask);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set front and back function and reference value for stencil testing
        /// </summary>
        /// <param name="func">
        /// <para>
        /// Specifies the test function. Eight symbolic constants are valid: GL_NEVER, GL_LESS, GL_LEQUAL, GL_GREATER, GL_GEQUAL, GL_EQUAL, GL_NOTEQUAL, and GL_ALWAYS. The initial value is GL_ALWAYS.
        /// </para>
        /// </param>
        /// <param name="ref">
        /// <para>
        /// Specifies the reference value for the stencil test. ref is clamped to the range [0, 2 sup n - 1], where is the number of bitplanes in the stencil buffer. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="mask">
        /// <para>
        /// Specifies a mask that is ANDed with both the reference value and the stored stencil value when the test is done. The initial value is all 1's.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glStencilFunc")]
        public static 
        void StencilFunc(OpenTK.Graphics.ES11.All func, Int32 @ref, UInt32 mask)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glStencilFunc((OpenTK.Graphics.ES11.All)func, (Int32)@ref, (UInt32)mask);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Control the front and back writing of individual bits in the stencil planes
        /// </summary>
        /// <param name="mask">
        /// <para>
        /// Specifies a bit mask to enable and disable writing of individual bits in the stencil planes. Initially, the mask is all 1's.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glStencilMask")]
        public static 
        void StencilMask(Int32 mask)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glStencilMask((UInt32)mask);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Control the front and back writing of individual bits in the stencil planes
        /// </summary>
        /// <param name="mask">
        /// <para>
        /// Specifies a bit mask to enable and disable writing of individual bits in the stencil planes. Initially, the mask is all 1's.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glStencilMask")]
        public static 
        void StencilMask(UInt32 mask)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glStencilMask((UInt32)mask);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set front and back stencil test actions
        /// </summary>
        /// <param name="sfail">
        /// <para>
        /// Specifies the action to take when the stencil test fails. Eight symbolic constants are accepted: GL_KEEP, GL_ZERO, GL_REPLACE, GL_INCR, GL_INCR_WRAP, GL_DECR, GL_DECR_WRAP, and GL_INVERT. The initial value is GL_KEEP.
        /// </para>
        /// </param>
        /// <param name="dpfail">
        /// <para>
        /// Specifies the stencil action when the stencil test passes, but the depth test fails. dpfail accepts the same symbolic constants as sfail. The initial value is GL_KEEP.
        /// </para>
        /// </param>
        /// <param name="dppass">
        /// <para>
        /// Specifies the stencil action when both the stencil test and the depth test pass, or when the stencil test passes and either there is no depth buffer or depth testing is not enabled. dppass accepts the same symbolic constants as sfail. The initial value is GL_KEEP.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glStencilOp")]
        public static 
        void StencilOp(OpenTK.Graphics.ES11.All fail, OpenTK.Graphics.ES11.All zfail, OpenTK.Graphics.ES11.All zpass)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glStencilOp((OpenTK.Graphics.ES11.All)fail, (OpenTK.Graphics.ES11.All)zfail, (OpenTK.Graphics.ES11.All)zpass);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of texture coordinates
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of coordinates per array element. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each texture coordinate. Symbolic constants GL_SHORT, GL_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive texture coordinate sets. If stride is 0, the array elements are understood to be tightly packed. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first texture coordinate set in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexCoordPointer")]
        public static 
        void TexCoordPointer<T3>(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] ref T3 pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glTexCoordPointer((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                pointer = (T3)pointer_ptr.Target;
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of texture coordinates
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of coordinates per array element. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each texture coordinate. Symbolic constants GL_SHORT, GL_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive texture coordinate sets. If stride is 0, the array elements are understood to be tightly packed. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first texture coordinate set in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexCoordPointer")]
        public static 
        void TexCoordPointer<T3>(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] T3[,,] pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glTexCoordPointer((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of texture coordinates
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of coordinates per array element. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each texture coordinate. Symbolic constants GL_SHORT, GL_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive texture coordinate sets. If stride is 0, the array elements are understood to be tightly packed. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first texture coordinate set in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexCoordPointer")]
        public static 
        void TexCoordPointer<T3>(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] T3[,] pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glTexCoordPointer((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of texture coordinates
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of coordinates per array element. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each texture coordinate. Symbolic constants GL_SHORT, GL_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive texture coordinate sets. If stride is 0, the array elements are understood to be tightly packed. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first texture coordinate set in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexCoordPointer")]
        public static 
        void TexCoordPointer<T3>(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] T3[] pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glTexCoordPointer((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of texture coordinates
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of coordinates per array element. Must be 1, 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each texture coordinate. Symbolic constants GL_SHORT, GL_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive texture coordinate sets. If stride is 0, the array elements are understood to be tightly packed. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first texture coordinate set in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexCoordPointer")]
        public static 
        void TexCoordPointer(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, IntPtr pointer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexCoordPointer((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture environment parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies a texture environment. May be GL_TEXTURE_ENV, GL_TEXTURE_FILTER_CONTROL or GL_POINT_SPRITE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture environment parameter. May be either GL_TEXTURE_ENV_MODE, GL_TEXTURE_LOD_BIAS, GL_COMBINE_RGB, GL_COMBINE_ALPHA, GL_SRC0_RGB, GL_SRC1_RGB, GL_SRC2_RGB, GL_SRC0_ALPHA, GL_SRC1_ALPHA, GL_SRC2_ALPHA, GL_OPERAND0_RGB, GL_OPERAND1_RGB, GL_OPERAND2_RGB, GL_OPERAND0_ALPHA, GL_OPERAND1_ALPHA, GL_OPERAND2_ALPHA, GL_RGB_SCALE, GL_ALPHA_SCALE, or GL_COORD_REPLACE.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies a single symbolic constant, one of GL_ADD, GL_ADD_SIGNED, GL_INTERPOLATE, GL_MODULATE, GL_DECAL, GL_BLEND, GL_REPLACE, GL_SUBTRACT, GL_COMBINE, GL_TEXTURE, GL_CONSTANT, GL_PRIMARY_COLOR, GL_PREVIOUS, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, a single boolean value for the point sprite texture coordinate replacement, a single floating-point value for the texture level-of-detail bias, or 1.0, 2.0, or 4.0 when specifying the GL_RGB_SCALE or GL_ALPHA_SCALE.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexEnvf")]
        public static 
        void TexEnv(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, Single param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexEnvf((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Single)param);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture environment parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies a texture environment. May be GL_TEXTURE_ENV, GL_TEXTURE_FILTER_CONTROL or GL_POINT_SPRITE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture environment parameter. May be either GL_TEXTURE_ENV_MODE, GL_TEXTURE_LOD_BIAS, GL_COMBINE_RGB, GL_COMBINE_ALPHA, GL_SRC0_RGB, GL_SRC1_RGB, GL_SRC2_RGB, GL_SRC0_ALPHA, GL_SRC1_ALPHA, GL_SRC2_ALPHA, GL_OPERAND0_RGB, GL_OPERAND1_RGB, GL_OPERAND2_RGB, GL_OPERAND0_ALPHA, GL_OPERAND1_ALPHA, GL_OPERAND2_ALPHA, GL_RGB_SCALE, GL_ALPHA_SCALE, or GL_COORD_REPLACE.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies a single symbolic constant, one of GL_ADD, GL_ADD_SIGNED, GL_INTERPOLATE, GL_MODULATE, GL_DECAL, GL_BLEND, GL_REPLACE, GL_SUBTRACT, GL_COMBINE, GL_TEXTURE, GL_CONSTANT, GL_PRIMARY_COLOR, GL_PREVIOUS, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, a single boolean value for the point sprite texture coordinate replacement, a single floating-point value for the texture level-of-detail bias, or 1.0, 2.0, or 4.0 when specifying the GL_RGB_SCALE or GL_ALPHA_SCALE.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexEnvfv")]
        public static 
        unsafe void TexEnv(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexEnvfv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture environment parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies a texture environment. May be GL_TEXTURE_ENV, GL_TEXTURE_FILTER_CONTROL or GL_POINT_SPRITE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture environment parameter. May be either GL_TEXTURE_ENV_MODE, GL_TEXTURE_LOD_BIAS, GL_COMBINE_RGB, GL_COMBINE_ALPHA, GL_SRC0_RGB, GL_SRC1_RGB, GL_SRC2_RGB, GL_SRC0_ALPHA, GL_SRC1_ALPHA, GL_SRC2_ALPHA, GL_OPERAND0_RGB, GL_OPERAND1_RGB, GL_OPERAND2_RGB, GL_OPERAND0_ALPHA, GL_OPERAND1_ALPHA, GL_OPERAND2_ALPHA, GL_RGB_SCALE, GL_ALPHA_SCALE, or GL_COORD_REPLACE.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies a single symbolic constant, one of GL_ADD, GL_ADD_SIGNED, GL_INTERPOLATE, GL_MODULATE, GL_DECAL, GL_BLEND, GL_REPLACE, GL_SUBTRACT, GL_COMBINE, GL_TEXTURE, GL_CONSTANT, GL_PRIMARY_COLOR, GL_PREVIOUS, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, a single boolean value for the point sprite texture coordinate replacement, a single floating-point value for the texture level-of-detail bias, or 1.0, 2.0, or 4.0 when specifying the GL_RGB_SCALE or GL_ALPHA_SCALE.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexEnvfv")]
        public static 
        void TexEnv(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glTexEnvfv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture environment parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies a texture environment. May be GL_TEXTURE_ENV, GL_TEXTURE_FILTER_CONTROL or GL_POINT_SPRITE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture environment parameter. May be either GL_TEXTURE_ENV_MODE, GL_TEXTURE_LOD_BIAS, GL_COMBINE_RGB, GL_COMBINE_ALPHA, GL_SRC0_RGB, GL_SRC1_RGB, GL_SRC2_RGB, GL_SRC0_ALPHA, GL_SRC1_ALPHA, GL_SRC2_ALPHA, GL_OPERAND0_RGB, GL_OPERAND1_RGB, GL_OPERAND2_RGB, GL_OPERAND0_ALPHA, GL_OPERAND1_ALPHA, GL_OPERAND2_ALPHA, GL_RGB_SCALE, GL_ALPHA_SCALE, or GL_COORD_REPLACE.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies a single symbolic constant, one of GL_ADD, GL_ADD_SIGNED, GL_INTERPOLATE, GL_MODULATE, GL_DECAL, GL_BLEND, GL_REPLACE, GL_SUBTRACT, GL_COMBINE, GL_TEXTURE, GL_CONSTANT, GL_PRIMARY_COLOR, GL_PREVIOUS, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, a single boolean value for the point sprite texture coordinate replacement, a single floating-point value for the texture level-of-detail bias, or 1.0, 2.0, or 4.0 when specifying the GL_RGB_SCALE or GL_ALPHA_SCALE.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexEnvi")]
        public static 
        void TexEnv(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, Int32 param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexEnvi((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Int32)param);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture environment parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies a texture environment. May be GL_TEXTURE_ENV, GL_TEXTURE_FILTER_CONTROL or GL_POINT_SPRITE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture environment parameter. May be either GL_TEXTURE_ENV_MODE, GL_TEXTURE_LOD_BIAS, GL_COMBINE_RGB, GL_COMBINE_ALPHA, GL_SRC0_RGB, GL_SRC1_RGB, GL_SRC2_RGB, GL_SRC0_ALPHA, GL_SRC1_ALPHA, GL_SRC2_ALPHA, GL_OPERAND0_RGB, GL_OPERAND1_RGB, GL_OPERAND2_RGB, GL_OPERAND0_ALPHA, GL_OPERAND1_ALPHA, GL_OPERAND2_ALPHA, GL_RGB_SCALE, GL_ALPHA_SCALE, or GL_COORD_REPLACE.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies a single symbolic constant, one of GL_ADD, GL_ADD_SIGNED, GL_INTERPOLATE, GL_MODULATE, GL_DECAL, GL_BLEND, GL_REPLACE, GL_SUBTRACT, GL_COMBINE, GL_TEXTURE, GL_CONSTANT, GL_PRIMARY_COLOR, GL_PREVIOUS, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, a single boolean value for the point sprite texture coordinate replacement, a single floating-point value for the texture level-of-detail bias, or 1.0, 2.0, or 4.0 when specifying the GL_RGB_SCALE or GL_ALPHA_SCALE.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexEnviv")]
        public static 
        unsafe void TexEnv(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, Int32* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexEnviv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture environment parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies a texture environment. May be GL_TEXTURE_ENV, GL_TEXTURE_FILTER_CONTROL or GL_POINT_SPRITE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture environment parameter. May be either GL_TEXTURE_ENV_MODE, GL_TEXTURE_LOD_BIAS, GL_COMBINE_RGB, GL_COMBINE_ALPHA, GL_SRC0_RGB, GL_SRC1_RGB, GL_SRC2_RGB, GL_SRC0_ALPHA, GL_SRC1_ALPHA, GL_SRC2_ALPHA, GL_OPERAND0_RGB, GL_OPERAND1_RGB, GL_OPERAND2_RGB, GL_OPERAND0_ALPHA, GL_OPERAND1_ALPHA, GL_OPERAND2_ALPHA, GL_RGB_SCALE, GL_ALPHA_SCALE, or GL_COORD_REPLACE.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies a single symbolic constant, one of GL_ADD, GL_ADD_SIGNED, GL_INTERPOLATE, GL_MODULATE, GL_DECAL, GL_BLEND, GL_REPLACE, GL_SUBTRACT, GL_COMBINE, GL_TEXTURE, GL_CONSTANT, GL_PRIMARY_COLOR, GL_PREVIOUS, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, a single boolean value for the point sprite texture coordinate replacement, a single floating-point value for the texture level-of-detail bias, or 1.0, 2.0, or 4.0 when specifying the GL_RGB_SCALE or GL_ALPHA_SCALE.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexEnviv")]
        public static 
        void TexEnv(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, Int32[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glTexEnviv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexEnvx")]
        public static 
        void TexEnvx(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, int param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexEnvx((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (int)param);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexEnvxv")]
        public static 
        unsafe void TexEnvx(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, int* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexEnvxv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (int*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexEnvxv")]
        public static 
        void TexEnvx(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, int[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = @params)
                {
                    Delegates.glTexEnvxv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalFormat">
        /// <para>
        /// Specifies the number of color components in the texture. Must be 1, 2, 3, or 4, or one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_DEPTH_COMPONENT, GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup m + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexImage2D")]
        public static 
        void TexImage2D<T8>(OpenTK.Graphics.ES11.All target, Int32 level, Int32 internalformat, Int32 width, Int32 height, Int32 border, OpenTK.Graphics.ES11.All format, OpenTK.Graphics.ES11.All type, [InAttribute, OutAttribute] ref T8 pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (Int32)internalformat, (Int32)width, (Int32)height, (Int32)border, (OpenTK.Graphics.ES11.All)format, (OpenTK.Graphics.ES11.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                pixels = (T8)pixels_ptr.Target;
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalFormat">
        /// <para>
        /// Specifies the number of color components in the texture. Must be 1, 2, 3, or 4, or one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_DEPTH_COMPONENT, GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup m + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexImage2D")]
        public static 
        void TexImage2D<T8>(OpenTK.Graphics.ES11.All target, Int32 level, Int32 internalformat, Int32 width, Int32 height, Int32 border, OpenTK.Graphics.ES11.All format, OpenTK.Graphics.ES11.All type, [InAttribute, OutAttribute] T8[,,] pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (Int32)internalformat, (Int32)width, (Int32)height, (Int32)border, (OpenTK.Graphics.ES11.All)format, (OpenTK.Graphics.ES11.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalFormat">
        /// <para>
        /// Specifies the number of color components in the texture. Must be 1, 2, 3, or 4, or one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_DEPTH_COMPONENT, GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup m + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexImage2D")]
        public static 
        void TexImage2D<T8>(OpenTK.Graphics.ES11.All target, Int32 level, Int32 internalformat, Int32 width, Int32 height, Int32 border, OpenTK.Graphics.ES11.All format, OpenTK.Graphics.ES11.All type, [InAttribute, OutAttribute] T8[,] pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (Int32)internalformat, (Int32)width, (Int32)height, (Int32)border, (OpenTK.Graphics.ES11.All)format, (OpenTK.Graphics.ES11.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalFormat">
        /// <para>
        /// Specifies the number of color components in the texture. Must be 1, 2, 3, or 4, or one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_DEPTH_COMPONENT, GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup m + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexImage2D")]
        public static 
        void TexImage2D<T8>(OpenTK.Graphics.ES11.All target, Int32 level, Int32 internalformat, Int32 width, Int32 height, Int32 border, OpenTK.Graphics.ES11.All format, OpenTK.Graphics.ES11.All type, [InAttribute, OutAttribute] T8[] pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (Int32)internalformat, (Int32)width, (Int32)height, (Int32)border, (OpenTK.Graphics.ES11.All)format, (OpenTK.Graphics.ES11.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalFormat">
        /// <para>
        /// Specifies the number of color components in the texture. Must be 1, 2, 3, or 4, or one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_COMPRESSED_ALPHA, GL_COMPRESSED_LUMINANCE, GL_COMPRESSED_LUMINANCE_ALPHA, GL_COMPRESSED_INTENSITY, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA, GL_DEPTH_COMPONENT, GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SLUMINANCE, GL_SLUMINANCE8, GL_SLUMINANCE_ALPHA, GL_SLUMINANCE8_ALPHA8, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup n + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image including the border if any. If the GL version does not support non-power-of-two sizes, this value must be 2 sup m + 2 ( border ) for some integer . All implementations support texture images that are at least 64 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexImage2D")]
        public static 
        void TexImage2D(OpenTK.Graphics.ES11.All target, Int32 level, Int32 internalformat, Int32 width, Int32 height, Int32 border, OpenTK.Graphics.ES11.All format, OpenTK.Graphics.ES11.All type, IntPtr pixels)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (Int32)internalformat, (Int32)width, (Int32)height, (Int32)border, (OpenTK.Graphics.ES11.All)format, (OpenTK.Graphics.ES11.All)type, (IntPtr)pixels);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture, which must be either GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture parameter. pname can be one of the following: GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_PRIORITY, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, or GL_GENERATE_MIPMAP.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value of pname.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexParameterf")]
        public static 
        void TexParameter(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, Single param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexParameterf((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Single)param);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture, which must be either GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture parameter. pname can be one of the following: GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_PRIORITY, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, or GL_GENERATE_MIPMAP.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value of pname.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexParameterfv")]
        public static 
        unsafe void TexParameter(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, Single* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexParameterfv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Single*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture, which must be either GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture parameter. pname can be one of the following: GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_PRIORITY, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, or GL_GENERATE_MIPMAP.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value of pname.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexParameterfv")]
        public static 
        void TexParameter(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, Single[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glTexParameterfv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Single*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture, which must be either GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture parameter. pname can be one of the following: GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_PRIORITY, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, or GL_GENERATE_MIPMAP.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value of pname.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexParameteri")]
        public static 
        void TexParameter(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, Int32 param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexParameteri((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Int32)param);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture, which must be either GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture parameter. pname can be one of the following: GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_PRIORITY, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, or GL_GENERATE_MIPMAP.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value of pname.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexParameteriv")]
        public static 
        unsafe void TexParameter(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, Int32* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexParameteriv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set texture parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture, which must be either GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of a single-valued texture parameter. pname can be one of the following: GL_TEXTURE_MIN_FILTER, GL_TEXTURE_MAG_FILTER, GL_TEXTURE_MIN_LOD, GL_TEXTURE_MAX_LOD, GL_TEXTURE_BASE_LEVEL, GL_TEXTURE_MAX_LEVEL, GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, GL_TEXTURE_WRAP_R, GL_TEXTURE_PRIORITY, GL_TEXTURE_COMPARE_MODE, GL_TEXTURE_COMPARE_FUNC, GL_DEPTH_TEXTURE_MODE, or GL_GENERATE_MIPMAP.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value of pname.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexParameteriv")]
        public static 
        void TexParameter(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, Int32[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glTexParameteriv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexParameterx")]
        public static 
        void TexParameterx(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, int param)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexParameterx((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (int)param);
            #if DEBUG
            }
            #endif
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexParameterxv")]
        public static 
        unsafe void TexParameterx(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, int* @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexParameterxv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (int*)@params);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexParameterxv")]
        public static 
        void TexParameterx(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, int[] @params)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            unsafe
            {
                fixed (int* @params_ptr = @params)
                {
                    Delegates.glTexParameterxv((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                }
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexSubImage2D")]
        public static 
        void TexSubImage2D<T8>(OpenTK.Graphics.ES11.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES11.All format, OpenTK.Graphics.ES11.All type, [InAttribute, OutAttribute] ref T8 pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexSubImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES11.All)format, (OpenTK.Graphics.ES11.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                pixels = (T8)pixels_ptr.Target;
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexSubImage2D")]
        public static 
        void TexSubImage2D<T8>(OpenTK.Graphics.ES11.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES11.All format, OpenTK.Graphics.ES11.All type, [InAttribute, OutAttribute] T8[,,] pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexSubImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES11.All)format, (OpenTK.Graphics.ES11.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexSubImage2D")]
        public static 
        void TexSubImage2D<T8>(OpenTK.Graphics.ES11.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES11.All format, OpenTK.Graphics.ES11.All type, [InAttribute, OutAttribute] T8[,] pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexSubImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES11.All)format, (OpenTK.Graphics.ES11.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexSubImage2D")]
        public static 
        void TexSubImage2D<T8>(OpenTK.Graphics.ES11.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES11.All format, OpenTK.Graphics.ES11.All type, [InAttribute, OutAttribute] T8[] pixels)
            where T8 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Delegates.glTexSubImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES11.All)format, (OpenTK.Graphics.ES11.All)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Specify a two-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. The following symbolic values are accepted: GL_COLOR_INDEX, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of the pixel data. The following symbolic values are accepted: GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the image data in memory.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexSubImage2D")]
        public static 
        void TexSubImage2D(OpenTK.Graphics.ES11.All target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, OpenTK.Graphics.ES11.All format, OpenTK.Graphics.ES11.All type, IntPtr pixels)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTexSubImage2D((OpenTK.Graphics.ES11.All)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (OpenTK.Graphics.ES11.All)format, (OpenTK.Graphics.ES11.All)type, (IntPtr)pixels);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Multiply the current matrix by a translation matrix
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the x, y, and z coordinates of a translation vector.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTranslatef")]
        public static 
        void Translate(Single x, Single y, Single z)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTranslatef((Single)x, (Single)y, (Single)z);
            #if DEBUG
            }
            #endif
        }

        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTranslatex")]
        public static 
        void Translatex(int x, int y, int z)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glTranslatex((int)x, (int)y, (int)z);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of vertex data
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of coordinates per vertex. Must be 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each coordinate in the array. Symbolic constants GL_SHORT, GL_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive vertices. If stride is 0, the vertices are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first vertex in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glVertexPointer")]
        public static 
        void VertexPointer<T3>(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] ref T3 pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glVertexPointer((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                pointer = (T3)pointer_ptr.Target;
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of vertex data
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of coordinates per vertex. Must be 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each coordinate in the array. Symbolic constants GL_SHORT, GL_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive vertices. If stride is 0, the vertices are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first vertex in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glVertexPointer")]
        public static 
        void VertexPointer<T3>(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] T3[,,] pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glVertexPointer((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of vertex data
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of coordinates per vertex. Must be 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each coordinate in the array. Symbolic constants GL_SHORT, GL_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive vertices. If stride is 0, the vertices are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first vertex in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glVertexPointer")]
        public static 
        void VertexPointer<T3>(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] T3[,] pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glVertexPointer((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of vertex data
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of coordinates per vertex. Must be 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each coordinate in the array. Symbolic constants GL_SHORT, GL_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive vertices. If stride is 0, the vertices are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first vertex in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glVertexPointer")]
        public static 
        void VertexPointer<T3>(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] T3[] pointer)
            where T3 : struct
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Delegates.glVertexPointer((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Define an array of vertex data
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of coordinates per vertex. Must be 2, 3, or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each coordinate in the array. Symbolic constants GL_SHORT, GL_INT, GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive vertices. If stride is 0, the vertices are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first vertex in the array. The initial value is 0.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glVertexPointer")]
        public static 
        void VertexPointer(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, IntPtr pointer)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glVertexPointer((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer);
            #if DEBUG
            }
            #endif
        }

        
        /// <summary>
        /// Set the viewport
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the lower left corner of the viewport rectangle, in pixels. The initial value is (0,0).
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the width and height of the viewport. When a GL context is first attached to a window, width and height are set to the dimensions of that window.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glViewport")]
        public static 
        void Viewport(Int32 x, Int32 y, Int32 width, Int32 height)
        {
            #if DEBUG
            using (new ErrorHelper(GraphicsContext.CurrentContext))
            {
            #endif
            Delegates.glViewport((Int32)x, (Int32)y, (Int32)width, (Int32)height);
            #if DEBUG
            }
            #endif
        }

        public static partial class NV
        {
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteFencesNV")]
            public static 
            unsafe void DeleteFences(Int32 n, Int32* fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteFencesNV((Int32)n, (UInt32*)fences);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteFencesNV")]
            public static 
            void DeleteFences(Int32 n, Int32[] fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* fences_ptr = fences)
                    {
                        Delegates.glDeleteFencesNV((Int32)n, (UInt32*)fences_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteFencesNV")]
            public static 
            void DeleteFences(Int32 n, ref Int32 fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* fences_ptr = &fences)
                    {
                        Delegates.glDeleteFencesNV((Int32)n, (UInt32*)fences_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteFencesNV")]
            public static 
            void DeleteFences(Int32 n, ref UInt32 fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* fences_ptr = &fences)
                    {
                        Delegates.glDeleteFencesNV((Int32)n, (UInt32*)fences_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteFencesNV")]
            public static 
            unsafe void DeleteFences(Int32 n, UInt32* fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteFencesNV((Int32)n, (UInt32*)fences);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteFencesNV")]
            public static 
            void DeleteFences(Int32 n, UInt32[] fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* fences_ptr = fences)
                    {
                        Delegates.glDeleteFencesNV((Int32)n, (UInt32*)fences_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFinishFenceNV")]
            public static 
            void FinishFence(Int32 fence)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFinishFenceNV((UInt32)fence);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFinishFenceNV")]
            public static 
            void FinishFence(UInt32 fence)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFinishFenceNV((UInt32)fence);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenFencesNV")]
            public static 
            unsafe void GenFences(Int32 n, Int32* fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenFencesNV((Int32)n, (UInt32*)fences);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenFencesNV")]
            public static 
            void GenFences(Int32 n, Int32[] fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* fences_ptr = fences)
                    {
                        Delegates.glGenFencesNV((Int32)n, (UInt32*)fences_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenFencesNV")]
            public static 
            void GenFences(Int32 n, ref Int32 fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* fences_ptr = &fences)
                    {
                        Delegates.glGenFencesNV((Int32)n, (UInt32*)fences_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenFencesNV")]
            public static 
            void GenFences(Int32 n, ref UInt32 fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* fences_ptr = &fences)
                    {
                        Delegates.glGenFencesNV((Int32)n, (UInt32*)fences_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenFencesNV")]
            public static 
            unsafe void GenFences(Int32 n, UInt32* fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenFencesNV((Int32)n, (UInt32*)fences);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenFencesNV")]
            public static 
            void GenFences(Int32 n, UInt32[] fences)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* fences_ptr = fences)
                    {
                        Delegates.glGenFencesNV((Int32)n, (UInt32*)fences_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetFenceivNV")]
            public static 
            unsafe void GetFence(Int32 fence, OpenTK.Graphics.ES11.All pname, Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetFenceivNV((UInt32)fence, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetFenceivNV")]
            public static 
            void GetFence(Int32 fence, OpenTK.Graphics.ES11.All pname, Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glGetFenceivNV((UInt32)fence, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetFenceivNV")]
            public static 
            void GetFence(Int32 fence, OpenTK.Graphics.ES11.All pname, ref Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetFenceivNV((UInt32)fence, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetFenceivNV")]
            public static 
            unsafe void GetFence(UInt32 fence, OpenTK.Graphics.ES11.All pname, Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetFenceivNV((UInt32)fence, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetFenceivNV")]
            public static 
            void GetFence(UInt32 fence, OpenTK.Graphics.ES11.All pname, Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glGetFenceivNV((UInt32)fence, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetFenceivNV")]
            public static 
            void GetFence(UInt32 fence, OpenTK.Graphics.ES11.All pname, ref Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetFenceivNV((UInt32)fence, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glIsFenceNV")]
            public static 
            bool IsFence(Int32 fence)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsFenceNV((UInt32)fence);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glIsFenceNV")]
            public static 
            bool IsFence(UInt32 fence)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsFenceNV((UInt32)fence);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glSetFenceNV")]
            public static 
            void SetFence(Int32 fence, OpenTK.Graphics.ES11.All condition)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glSetFenceNV((UInt32)fence, (OpenTK.Graphics.ES11.All)condition);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glSetFenceNV")]
            public static 
            void SetFence(UInt32 fence, OpenTK.Graphics.ES11.All condition)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glSetFenceNV((UInt32)fence, (OpenTK.Graphics.ES11.All)condition);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTestFenceNV")]
            public static 
            bool TestFence(Int32 fence)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glTestFenceNV((UInt32)fence);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTestFenceNV")]
            public static 
            bool TestFence(UInt32 fence)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glTestFenceNV((UInt32)fence);
                #if DEBUG
                }
                #endif
            }

        }

        public static partial class Oes
        {
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glAlphaFuncxOES")]
            public static 
            void AlphaFuncx(OpenTK.Graphics.ES11.All func, int @ref)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glAlphaFuncxOES((OpenTK.Graphics.ES11.All)func, (int)@ref);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBindFramebufferOES")]
            public static 
            void BindFramebuffer(OpenTK.Graphics.ES11.All target, Int32 framebuffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBindFramebufferOES((OpenTK.Graphics.ES11.All)target, (UInt32)framebuffer);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBindFramebufferOES")]
            public static 
            void BindFramebuffer(OpenTK.Graphics.ES11.All target, UInt32 framebuffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBindFramebufferOES((OpenTK.Graphics.ES11.All)target, (UInt32)framebuffer);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBindRenderbufferOES")]
            public static 
            void BindRenderbuffer(OpenTK.Graphics.ES11.All target, Int32 renderbuffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBindRenderbufferOES((OpenTK.Graphics.ES11.All)target, (UInt32)renderbuffer);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBindRenderbufferOES")]
            public static 
            void BindRenderbuffer(OpenTK.Graphics.ES11.All target, UInt32 renderbuffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBindRenderbufferOES((OpenTK.Graphics.ES11.All)target, (UInt32)renderbuffer);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the equation used for both the RGB blend equation and the Alpha blend equation
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// specifies how source and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT, GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBlendEquationOES")]
            public static 
            void BlendEquation(OpenTK.Graphics.ES11.All mode)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBlendEquationOES((OpenTK.Graphics.ES11.All)mode);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Set the RGB blend equation and the alpha blend equation separately
        /// </summary>
        /// <param name="modeRGB">
        /// <para>
        /// specifies the RGB blend equation, how the red, green, and blue components of the source and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT, GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX.
        /// </para>
        /// </param>
        /// <param name="modeAlpha">
        /// <para>
        /// specifies the alpha blend equation, how the alpha component of the source and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT, GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBlendEquationSeparateOES")]
            public static 
            void BlendEquationSeparate(OpenTK.Graphics.ES11.All modeRGB, OpenTK.Graphics.ES11.All modeAlpha)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBlendEquationSeparateOES((OpenTK.Graphics.ES11.All)modeRGB, (OpenTK.Graphics.ES11.All)modeAlpha);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify pixel arithmetic for RGB and alpha components separately
        /// </summary>
        /// <param name="srcRGB">
        /// <para>
        /// Specifies how the red, green, and blue blending factors are computed. The following symbolic constants are accepted: GL_ZERO, GL_ONE, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_DST_COLOR, GL_ONE_MINUS_DST_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, GL_DST_ALPHA, GL_ONE_MINUS_DST_ALPHA, GL_CONSTANT_COLOR, GL_ONE_MINUS_CONSTANT_COLOR, GL_CONSTANT_ALPHA, GL_ONE_MINUS_CONSTANT_ALPHA, and GL_SRC_ALPHA_SATURATE. The initial value is GL_ONE.
        /// </para>
        /// </param>
        /// <param name="dstRGB">
        /// <para>
        /// Specifies how the red, green, and blue destination blending factors are computed. The following symbolic constants are accepted: GL_ZERO, GL_ONE, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_DST_COLOR, GL_ONE_MINUS_DST_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, GL_DST_ALPHA, GL_ONE_MINUS_DST_ALPHA. GL_CONSTANT_COLOR, GL_ONE_MINUS_CONSTANT_COLOR, GL_CONSTANT_ALPHA, and GL_ONE_MINUS_CONSTANT_ALPHA. The initial value is GL_ZERO.
        /// </para>
        /// </param>
        /// <param name="srcAlpha">
        /// <para>
        /// Specified how the alpha source blending factor is computed. The same symbolic constants are accepted as for srcRGB. The initial value is GL_ONE.
        /// </para>
        /// </param>
        /// <param name="dstAlpha">
        /// <para>
        /// Specified how the alpha destination blending factor is computed. The same symbolic constants are accepted as for dstRGB. The initial value is GL_ZERO.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glBlendFuncSeparateOES")]
            public static 
            void BlendFuncSeparate(OpenTK.Graphics.ES11.All srcRGB, OpenTK.Graphics.ES11.All dstRGB, OpenTK.Graphics.ES11.All srcAlpha, OpenTK.Graphics.ES11.All dstAlpha)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glBlendFuncSeparateOES((OpenTK.Graphics.ES11.All)srcRGB, (OpenTK.Graphics.ES11.All)dstRGB, (OpenTK.Graphics.ES11.All)srcAlpha, (OpenTK.Graphics.ES11.All)dstAlpha);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glCheckFramebufferStatusOES")]
            public static 
            OpenTK.Graphics.ES11.All CheckFramebufferStatus(OpenTK.Graphics.ES11.All target)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glCheckFramebufferStatusOES((OpenTK.Graphics.ES11.All)target);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClearColorxOES")]
            public static 
            void ClearColorx(int red, int green, int blue, int alpha)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glClearColorxOES((int)red, (int)green, (int)blue, (int)alpha);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify the clear value for the depth buffer
        /// </summary>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth value used when the depth buffer is cleared. The initial value is 1.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClearDepthfOES")]
            public static 
            void ClearDepth(Single depth)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glClearDepthfOES((Single)depth);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClearDepthxOES")]
            public static 
            void ClearDepthx(int depth)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glClearDepthxOES((int)depth);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a plane against which all geometry is clipped
        /// </summary>
        /// <param name="plane">
        /// <para>
        /// Specifies which clipping plane is being positioned. Symbolic names of the form GL_CLIP_PLANEi, where i is an integer between 0 and GL_MAX_CLIP_PLANES - 1, are accepted.
        /// </para>
        /// </param>
        /// <param name="equation">
        /// <para>
        /// Specifies the address of an array of four double-precision floating-point values. These values are interpreted as a plane equation.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClipPlanefOES")]
            public static 
            void ClipPlane(OpenTK.Graphics.ES11.All plane, ref Single equation)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* equation_ptr = &equation)
                    {
                        Delegates.glClipPlanefOES((OpenTK.Graphics.ES11.All)plane, (Single*)equation_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a plane against which all geometry is clipped
        /// </summary>
        /// <param name="plane">
        /// <para>
        /// Specifies which clipping plane is being positioned. Symbolic names of the form GL_CLIP_PLANEi, where i is an integer between 0 and GL_MAX_CLIP_PLANES - 1, are accepted.
        /// </para>
        /// </param>
        /// <param name="equation">
        /// <para>
        /// Specifies the address of an array of four double-precision floating-point values. These values are interpreted as a plane equation.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClipPlanefOES")]
            public static 
            unsafe void ClipPlane(OpenTK.Graphics.ES11.All plane, Single* equation)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glClipPlanefOES((OpenTK.Graphics.ES11.All)plane, (Single*)equation);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify a plane against which all geometry is clipped
        /// </summary>
        /// <param name="plane">
        /// <para>
        /// Specifies which clipping plane is being positioned. Symbolic names of the form GL_CLIP_PLANEi, where i is an integer between 0 and GL_MAX_CLIP_PLANES - 1, are accepted.
        /// </para>
        /// </param>
        /// <param name="equation">
        /// <para>
        /// Specifies the address of an array of four double-precision floating-point values. These values are interpreted as a plane equation.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClipPlanefOES")]
            public static 
            void ClipPlane(OpenTK.Graphics.ES11.All plane, Single[] equation)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* equation_ptr = equation)
                    {
                        Delegates.glClipPlanefOES((OpenTK.Graphics.ES11.All)plane, (Single*)equation_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClipPlanexOES")]
            public static 
            unsafe void ClipPlanex(OpenTK.Graphics.ES11.All plane, int* equation)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glClipPlanexOES((OpenTK.Graphics.ES11.All)plane, (int*)equation);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClipPlanexOES")]
            public static 
            void ClipPlanex(OpenTK.Graphics.ES11.All plane, int[] equation)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* equation_ptr = equation)
                    {
                        Delegates.glClipPlanexOES((OpenTK.Graphics.ES11.All)plane, (int*)equation_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glClipPlanexOES")]
            public static 
            void ClipPlanex(OpenTK.Graphics.ES11.All plane, ref int equation)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* equation_ptr = &equation)
                    {
                        Delegates.glClipPlanexOES((OpenTK.Graphics.ES11.All)plane, (int*)equation_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glColor4xOES")]
            public static 
            void Color4x(int red, int green, int blue, int alpha)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glColor4xOES((int)red, (int)green, (int)blue, (int)alpha);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glCurrentPaletteMatrixOES")]
            public static 
            void CurrentPaletteMatrix(Int32 matrixpaletteindex)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glCurrentPaletteMatrixOES((UInt32)matrixpaletteindex);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glCurrentPaletteMatrixOES")]
            public static 
            void CurrentPaletteMatrix(UInt32 matrixpaletteindex)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glCurrentPaletteMatrixOES((UInt32)matrixpaletteindex);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteFramebuffersOES")]
            public static 
            unsafe void DeleteFramebuffers(Int32 n, Int32* framebuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteFramebuffersOES((Int32)n, (UInt32*)framebuffers);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteFramebuffersOES")]
            public static 
            void DeleteFramebuffers(Int32 n, Int32[] framebuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* framebuffers_ptr = framebuffers)
                    {
                        Delegates.glDeleteFramebuffersOES((Int32)n, (UInt32*)framebuffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteFramebuffersOES")]
            public static 
            void DeleteFramebuffers(Int32 n, ref Int32 framebuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* framebuffers_ptr = &framebuffers)
                    {
                        Delegates.glDeleteFramebuffersOES((Int32)n, (UInt32*)framebuffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteFramebuffersOES")]
            public static 
            void DeleteFramebuffers(Int32 n, ref UInt32 framebuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* framebuffers_ptr = &framebuffers)
                    {
                        Delegates.glDeleteFramebuffersOES((Int32)n, (UInt32*)framebuffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteFramebuffersOES")]
            public static 
            unsafe void DeleteFramebuffers(Int32 n, UInt32* framebuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteFramebuffersOES((Int32)n, (UInt32*)framebuffers);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteFramebuffersOES")]
            public static 
            void DeleteFramebuffers(Int32 n, UInt32[] framebuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* framebuffers_ptr = framebuffers)
                    {
                        Delegates.glDeleteFramebuffersOES((Int32)n, (UInt32*)framebuffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteRenderbuffersOES")]
            public static 
            unsafe void DeleteRenderbuffers(Int32 n, Int32* renderbuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteRenderbuffersOES((Int32)n, (UInt32*)renderbuffers);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteRenderbuffersOES")]
            public static 
            void DeleteRenderbuffers(Int32 n, Int32[] renderbuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* renderbuffers_ptr = renderbuffers)
                    {
                        Delegates.glDeleteRenderbuffersOES((Int32)n, (UInt32*)renderbuffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteRenderbuffersOES")]
            public static 
            void DeleteRenderbuffers(Int32 n, ref Int32 renderbuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* renderbuffers_ptr = &renderbuffers)
                    {
                        Delegates.glDeleteRenderbuffersOES((Int32)n, (UInt32*)renderbuffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteRenderbuffersOES")]
            public static 
            void DeleteRenderbuffers(Int32 n, ref UInt32 renderbuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* renderbuffers_ptr = &renderbuffers)
                    {
                        Delegates.glDeleteRenderbuffersOES((Int32)n, (UInt32*)renderbuffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteRenderbuffersOES")]
            public static 
            unsafe void DeleteRenderbuffers(Int32 n, UInt32* renderbuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDeleteRenderbuffersOES((Int32)n, (UInt32*)renderbuffers);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDeleteRenderbuffersOES")]
            public static 
            void DeleteRenderbuffers(Int32 n, UInt32[] renderbuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* renderbuffers_ptr = renderbuffers)
                    {
                        Delegates.glDeleteRenderbuffersOES((Int32)n, (UInt32*)renderbuffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Specify mapping of depth values from normalized device coordinates to window coordinates
        /// </summary>
        /// <param name="nearVal">
        /// <para>
        /// Specifies the mapping of the near clipping plane to window coordinates. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="farVal">
        /// <para>
        /// Specifies the mapping of the far clipping plane to window coordinates. The initial value is 1.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDepthRangefOES")]
            public static 
            void DepthRange(Single zNear, Single zFar)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDepthRangefOES((Single)zNear, (Single)zFar);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDepthRangexOES")]
            public static 
            void DepthRangex(int zNear, int zFar)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDepthRangexOES((int)zNear, (int)zFar);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawTexfOES")]
            public static 
            void DrawTex(Single x, Single y, Single z, Single width, Single height)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDrawTexfOES((Single)x, (Single)y, (Single)z, (Single)width, (Single)height);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawTexfvOES")]
            public static 
            void DrawTex(ref Single coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* coords_ptr = &coords)
                    {
                        Delegates.glDrawTexfvOES((Single*)coords_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawTexfvOES")]
            public static 
            unsafe void DrawTex(Single* coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDrawTexfvOES((Single*)coords);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawTexfvOES")]
            public static 
            void DrawTex(Single[] coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* coords_ptr = coords)
                    {
                        Delegates.glDrawTexfvOES((Single*)coords_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawTexiOES")]
            public static 
            void DrawTex(Int32 x, Int32 y, Int32 z, Int32 width, Int32 height)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDrawTexiOES((Int32)x, (Int32)y, (Int32)z, (Int32)width, (Int32)height);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawTexivOES")]
            public static 
            unsafe void DrawTex(Int32* coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDrawTexivOES((Int32*)coords);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawTexivOES")]
            public static 
            void DrawTex(Int32[] coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* coords_ptr = coords)
                    {
                        Delegates.glDrawTexivOES((Int32*)coords_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawTexivOES")]
            public static 
            void DrawTex(ref Int32 coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* coords_ptr = &coords)
                    {
                        Delegates.glDrawTexivOES((Int32*)coords_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawTexsOES")]
            public static 
            void DrawTex(Int16 x, Int16 y, Int16 z, Int16 width, Int16 height)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDrawTexsOES((Int16)x, (Int16)y, (Int16)z, (Int16)width, (Int16)height);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawTexsvOES")]
            public static 
            unsafe void DrawTex(Int16* coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDrawTexsvOES((Int16*)coords);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawTexsvOES")]
            public static 
            void DrawTex(Int16[] coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* coords_ptr = coords)
                    {
                        Delegates.glDrawTexsvOES((Int16*)coords_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawTexsvOES")]
            public static 
            void DrawTex(ref Int16 coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int16* coords_ptr = &coords)
                    {
                        Delegates.glDrawTexsvOES((Int16*)coords_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawTexxOES")]
            public static 
            void DrawTexx(int x, int y, int z, int width, int height)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDrawTexxOES((int)x, (int)y, (int)z, (int)width, (int)height);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawTexxvOES")]
            public static 
            unsafe void DrawTexx(int* coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glDrawTexxvOES((int*)coords);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawTexxvOES")]
            public static 
            void DrawTexx(int[] coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* coords_ptr = coords)
                    {
                        Delegates.glDrawTexxvOES((int*)coords_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glDrawTexxvOES")]
            public static 
            void DrawTexx(ref int coords)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* coords_ptr = &coords)
                    {
                        Delegates.glDrawTexxvOES((int*)coords_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glEGLImageTargetRenderbufferStorageOES")]
            public static 
            void EGLImageTargetRenderbufferStorage(OpenTK.Graphics.ES11.All target, IntPtr image)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glEGLImageTargetRenderbufferStorageOES((OpenTK.Graphics.ES11.All)target, (IntPtr)image);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glEGLImageTargetTexture2DOES")]
            public static 
            void EGLImageTargetTexture2D(OpenTK.Graphics.ES11.All target, IntPtr image)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glEGLImageTargetTexture2DOES((OpenTK.Graphics.ES11.All)target, (IntPtr)image);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFogxOES")]
            public static 
            void Fogx(OpenTK.Graphics.ES11.All pname, int param)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFogxOES((OpenTK.Graphics.ES11.All)pname, (int)param);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFogxvOES")]
            public static 
            unsafe void Fogx(OpenTK.Graphics.ES11.All pname, int* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFogxvOES((OpenTK.Graphics.ES11.All)pname, (int*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFogxvOES")]
            public static 
            void Fogx(OpenTK.Graphics.ES11.All pname, int[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* @params_ptr = @params)
                    {
                        Delegates.glFogxvOES((OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFramebufferRenderbufferOES")]
            public static 
            void FramebufferRenderbuffer(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All attachment, OpenTK.Graphics.ES11.All renderbuffertarget, Int32 renderbuffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFramebufferRenderbufferOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)attachment, (OpenTK.Graphics.ES11.All)renderbuffertarget, (UInt32)renderbuffer);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFramebufferRenderbufferOES")]
            public static 
            void FramebufferRenderbuffer(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All attachment, OpenTK.Graphics.ES11.All renderbuffertarget, UInt32 renderbuffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFramebufferRenderbufferOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)attachment, (OpenTK.Graphics.ES11.All)renderbuffertarget, (UInt32)renderbuffer);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFramebufferTexture2DOES")]
            public static 
            void FramebufferTexture2D(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All attachment, OpenTK.Graphics.ES11.All textarget, Int32 texture, Int32 level)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFramebufferTexture2DOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)attachment, (OpenTK.Graphics.ES11.All)textarget, (UInt32)texture, (Int32)level);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFramebufferTexture2DOES")]
            public static 
            void FramebufferTexture2D(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All attachment, OpenTK.Graphics.ES11.All textarget, UInt32 texture, Int32 level)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFramebufferTexture2DOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)attachment, (OpenTK.Graphics.ES11.All)textarget, (UInt32)texture, (Int32)level);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Multiply the current matrix by a perspective matrix
        /// </summary>
        /// <param name="left">
        /// <para>
        /// Specify the coordinates for the left and right vertical clipping planes.
        /// </para>
        /// </param>
        /// <param name="bottom">
        /// <para>
        /// Specify the coordinates for the bottom and top horizontal clipping planes.
        /// </para>
        /// </param>
        /// <param name="nearVal">
        /// <para>
        /// Specify the distances to the near and far depth clipping planes. Both distances must be positive.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFrustumfOES")]
            public static 
            void Frustum(Single left, Single right, Single bottom, Single top, Single zNear, Single zFar)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFrustumfOES((Single)left, (Single)right, (Single)bottom, (Single)top, (Single)zNear, (Single)zFar);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glFrustumxOES")]
            public static 
            void Frustumx(int left, int right, int bottom, int top, int zNear, int zFar)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glFrustumxOES((int)left, (int)right, (int)bottom, (int)top, (int)zNear, (int)zFar);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenerateMipmapOES")]
            public static 
            void GenerateMipmap(OpenTK.Graphics.ES11.All target)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenerateMipmapOES((OpenTK.Graphics.ES11.All)target);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenFramebuffersOES")]
            public static 
            unsafe void GenFramebuffers(Int32 n, Int32* framebuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenFramebuffersOES((Int32)n, (UInt32*)framebuffers);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenFramebuffersOES")]
            public static 
            void GenFramebuffers(Int32 n, Int32[] framebuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* framebuffers_ptr = framebuffers)
                    {
                        Delegates.glGenFramebuffersOES((Int32)n, (UInt32*)framebuffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenFramebuffersOES")]
            public static 
            void GenFramebuffers(Int32 n, ref Int32 framebuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* framebuffers_ptr = &framebuffers)
                    {
                        Delegates.glGenFramebuffersOES((Int32)n, (UInt32*)framebuffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenFramebuffersOES")]
            public static 
            void GenFramebuffers(Int32 n, ref UInt32 framebuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* framebuffers_ptr = &framebuffers)
                    {
                        Delegates.glGenFramebuffersOES((Int32)n, (UInt32*)framebuffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenFramebuffersOES")]
            public static 
            unsafe void GenFramebuffers(Int32 n, UInt32* framebuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenFramebuffersOES((Int32)n, (UInt32*)framebuffers);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenFramebuffersOES")]
            public static 
            void GenFramebuffers(Int32 n, UInt32[] framebuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* framebuffers_ptr = framebuffers)
                    {
                        Delegates.glGenFramebuffersOES((Int32)n, (UInt32*)framebuffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenRenderbuffersOES")]
            public static 
            unsafe void GenRenderbuffers(Int32 n, Int32* renderbuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenRenderbuffersOES((Int32)n, (UInt32*)renderbuffers);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenRenderbuffersOES")]
            public static 
            void GenRenderbuffers(Int32 n, Int32[] renderbuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* renderbuffers_ptr = renderbuffers)
                    {
                        Delegates.glGenRenderbuffersOES((Int32)n, (UInt32*)renderbuffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenRenderbuffersOES")]
            public static 
            void GenRenderbuffers(Int32 n, ref Int32 renderbuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* renderbuffers_ptr = &renderbuffers)
                    {
                        Delegates.glGenRenderbuffersOES((Int32)n, (UInt32*)renderbuffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenRenderbuffersOES")]
            public static 
            void GenRenderbuffers(Int32 n, ref UInt32 renderbuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* renderbuffers_ptr = &renderbuffers)
                    {
                        Delegates.glGenRenderbuffersOES((Int32)n, (UInt32*)renderbuffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenRenderbuffersOES")]
            public static 
            unsafe void GenRenderbuffers(Int32 n, UInt32* renderbuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGenRenderbuffersOES((Int32)n, (UInt32*)renderbuffers);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGenRenderbuffersOES")]
            public static 
            void GenRenderbuffers(Int32 n, UInt32[] renderbuffers)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (UInt32* renderbuffers_ptr = renderbuffers)
                    {
                        Delegates.glGenRenderbuffersOES((Int32)n, (UInt32*)renderbuffers_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetBufferPointervOES")]
            public static 
            void GetBufferPointer<T2>(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, [InAttribute, OutAttribute] ref T2 @params)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetBufferPointervOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                    @params = (T2)@params_ptr.Target;
                }
                finally
                {
                    @params_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetBufferPointervOES")]
            public static 
            void GetBufferPointer<T2>(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, [InAttribute, OutAttribute] T2[,,] @params)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetBufferPointervOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @params_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetBufferPointervOES")]
            public static 
            void GetBufferPointer<T2>(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, [InAttribute, OutAttribute] T2[,] @params)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetBufferPointervOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @params_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetBufferPointervOES")]
            public static 
            void GetBufferPointer<T2>(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, [InAttribute, OutAttribute] T2[] @params)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
                try
                {
                    Delegates.glGetBufferPointervOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @params_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetBufferPointervOES")]
            public static 
            void GetBufferPointer(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, IntPtr @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetBufferPointervOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (IntPtr)@params);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return the coefficients of the specified clipping plane
        /// </summary>
        /// <param name="plane">
        /// <para>
        /// Specifies a clipping plane. The number of clipping planes depends on the implementation, but at least six clipping planes are supported. They are identified by symbolic names of the form GL_CLIP_PLANE where i ranges from 0 to the value of GL_MAX_CLIP_PLANES - 1.
        /// </para>
        /// </param>
        /// <param name="equation">
        /// <para>
        /// Returns four double-precision values that are the coefficients of the plane equation of plane in eye coordinates. The initial value is (0, 0, 0, 0).
        /// </para>
        /// </param>
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetClipPlanefOES")]
            public static 
            void GetClipPlane(OpenTK.Graphics.ES11.All pname, ref Single eqn)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* eqn_ptr = &eqn)
                    {
                        Delegates.glGetClipPlanefOES((OpenTK.Graphics.ES11.All)pname, (Single*)eqn_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return the coefficients of the specified clipping plane
        /// </summary>
        /// <param name="plane">
        /// <para>
        /// Specifies a clipping plane. The number of clipping planes depends on the implementation, but at least six clipping planes are supported. They are identified by symbolic names of the form GL_CLIP_PLANE where i ranges from 0 to the value of GL_MAX_CLIP_PLANES - 1.
        /// </para>
        /// </param>
        /// <param name="equation">
        /// <para>
        /// Returns four double-precision values that are the coefficients of the plane equation of plane in eye coordinates. The initial value is (0, 0, 0, 0).
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetClipPlanefOES")]
            public static 
            unsafe void GetClipPlane(OpenTK.Graphics.ES11.All pname, Single* eqn)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetClipPlanefOES((OpenTK.Graphics.ES11.All)pname, (Single*)eqn);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return the coefficients of the specified clipping plane
        /// </summary>
        /// <param name="plane">
        /// <para>
        /// Specifies a clipping plane. The number of clipping planes depends on the implementation, but at least six clipping planes are supported. They are identified by symbolic names of the form GL_CLIP_PLANE where i ranges from 0 to the value of GL_MAX_CLIP_PLANES - 1.
        /// </para>
        /// </param>
        /// <param name="equation">
        /// <para>
        /// Returns four double-precision values that are the coefficients of the plane equation of plane in eye coordinates. The initial value is (0, 0, 0, 0).
        /// </para>
        /// </param>
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetClipPlanefOES")]
            public static 
            void GetClipPlane(OpenTK.Graphics.ES11.All pname, Single[] eqn)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* eqn_ptr = eqn)
                    {
                        Delegates.glGetClipPlanefOES((OpenTK.Graphics.ES11.All)pname, (Single*)eqn_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetClipPlanexOES")]
            public static 
            unsafe void GetClipPlanex(OpenTK.Graphics.ES11.All pname, int* eqn)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetClipPlanexOES((OpenTK.Graphics.ES11.All)pname, (int*)eqn);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetClipPlanexOES")]
            public static 
            void GetClipPlanex(OpenTK.Graphics.ES11.All pname, int[] eqn)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* eqn_ptr = eqn)
                    {
                        Delegates.glGetClipPlanexOES((OpenTK.Graphics.ES11.All)pname, (int*)eqn_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetClipPlanexOES")]
            public static 
            void GetClipPlanex(OpenTK.Graphics.ES11.All pname, ref int eqn)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* eqn_ptr = &eqn)
                    {
                        Delegates.glGetClipPlanexOES((OpenTK.Graphics.ES11.All)pname, (int*)eqn_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetFixedvOES")]
            public static 
            unsafe void GetFixed(OpenTK.Graphics.ES11.All pname, int* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetFixedvOES((OpenTK.Graphics.ES11.All)pname, (int*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetFixedvOES")]
            public static 
            void GetFixed(OpenTK.Graphics.ES11.All pname, int[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* @params_ptr = @params)
                    {
                        Delegates.glGetFixedvOES((OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetFixedvOES")]
            public static 
            void GetFixed(OpenTK.Graphics.ES11.All pname, ref int @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* @params_ptr = &@params)
                    {
                        Delegates.glGetFixedvOES((OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetFramebufferAttachmentParameterivOES")]
            public static 
            unsafe void GetFramebufferAttachmentParameter(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All attachment, OpenTK.Graphics.ES11.All pname, Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetFramebufferAttachmentParameterivOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)attachment, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetFramebufferAttachmentParameterivOES")]
            public static 
            void GetFramebufferAttachmentParameter(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All attachment, OpenTK.Graphics.ES11.All pname, Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glGetFramebufferAttachmentParameterivOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)attachment, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetFramebufferAttachmentParameterivOES")]
            public static 
            void GetFramebufferAttachmentParameter(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All attachment, OpenTK.Graphics.ES11.All pname, ref Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetFramebufferAttachmentParameterivOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)attachment, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetLightxvOES")]
            public static 
            unsafe void GetLightx(OpenTK.Graphics.ES11.All light, OpenTK.Graphics.ES11.All pname, int* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetLightxvOES((OpenTK.Graphics.ES11.All)light, (OpenTK.Graphics.ES11.All)pname, (int*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetLightxvOES")]
            public static 
            void GetLightx(OpenTK.Graphics.ES11.All light, OpenTK.Graphics.ES11.All pname, int[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* @params_ptr = @params)
                    {
                        Delegates.glGetLightxvOES((OpenTK.Graphics.ES11.All)light, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetLightxvOES")]
            public static 
            void GetLightx(OpenTK.Graphics.ES11.All light, OpenTK.Graphics.ES11.All pname, ref int @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* @params_ptr = &@params)
                    {
                        Delegates.glGetLightxvOES((OpenTK.Graphics.ES11.All)light, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetMaterialxvOES")]
            public static 
            unsafe void GetMaterialx(OpenTK.Graphics.ES11.All face, OpenTK.Graphics.ES11.All pname, int* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetMaterialxvOES((OpenTK.Graphics.ES11.All)face, (OpenTK.Graphics.ES11.All)pname, (int*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetMaterialxvOES")]
            public static 
            void GetMaterialx(OpenTK.Graphics.ES11.All face, OpenTK.Graphics.ES11.All pname, int[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* @params_ptr = @params)
                    {
                        Delegates.glGetMaterialxvOES((OpenTK.Graphics.ES11.All)face, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetMaterialxvOES")]
            public static 
            void GetMaterialx(OpenTK.Graphics.ES11.All face, OpenTK.Graphics.ES11.All pname, ref int @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* @params_ptr = &@params)
                    {
                        Delegates.glGetMaterialxvOES((OpenTK.Graphics.ES11.All)face, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetRenderbufferParameterivOES")]
            public static 
            unsafe void GetRenderbufferParameter(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetRenderbufferParameterivOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetRenderbufferParameterivOES")]
            public static 
            void GetRenderbufferParameter(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glGetRenderbufferParameterivOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetRenderbufferParameterivOES")]
            public static 
            void GetRenderbufferParameter(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, ref Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetRenderbufferParameterivOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexEnvxvOES")]
            public static 
            unsafe void GetTexEnvx(OpenTK.Graphics.ES11.All env, OpenTK.Graphics.ES11.All pname, int* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetTexEnvxvOES((OpenTK.Graphics.ES11.All)env, (OpenTK.Graphics.ES11.All)pname, (int*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexEnvxvOES")]
            public static 
            void GetTexEnvx(OpenTK.Graphics.ES11.All env, OpenTK.Graphics.ES11.All pname, int[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* @params_ptr = @params)
                    {
                        Delegates.glGetTexEnvxvOES((OpenTK.Graphics.ES11.All)env, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexEnvxvOES")]
            public static 
            void GetTexEnvx(OpenTK.Graphics.ES11.All env, OpenTK.Graphics.ES11.All pname, ref int @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* @params_ptr = &@params)
                    {
                        Delegates.glGetTexEnvxvOES((OpenTK.Graphics.ES11.All)env, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return texture coordinate generation parameters
        /// </summary>
        /// <param name="coord">
        /// <para>
        /// Specifies a texture coordinate. Must be GL_S, GL_T, GL_R, or GL_Q.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the value(s) to be returned. Must be either GL_TEXTURE_GEN_MODE or the name of one of the texture generation plane equations: GL_OBJECT_PLANE or GL_EYE_PLANE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexGenfvOES")]
            public static 
            void GetTexGen(OpenTK.Graphics.ES11.All coord, OpenTK.Graphics.ES11.All pname, ref Single @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = &@params)
                    {
                        Delegates.glGetTexGenfvOES((OpenTK.Graphics.ES11.All)coord, (OpenTK.Graphics.ES11.All)pname, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return texture coordinate generation parameters
        /// </summary>
        /// <param name="coord">
        /// <para>
        /// Specifies a texture coordinate. Must be GL_S, GL_T, GL_R, or GL_Q.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the value(s) to be returned. Must be either GL_TEXTURE_GEN_MODE or the name of one of the texture generation plane equations: GL_OBJECT_PLANE or GL_EYE_PLANE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexGenfvOES")]
            public static 
            unsafe void GetTexGen(OpenTK.Graphics.ES11.All coord, OpenTK.Graphics.ES11.All pname, Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetTexGenfvOES((OpenTK.Graphics.ES11.All)coord, (OpenTK.Graphics.ES11.All)pname, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return texture coordinate generation parameters
        /// </summary>
        /// <param name="coord">
        /// <para>
        /// Specifies a texture coordinate. Must be GL_S, GL_T, GL_R, or GL_Q.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the value(s) to be returned. Must be either GL_TEXTURE_GEN_MODE or the name of one of the texture generation plane equations: GL_OBJECT_PLANE or GL_EYE_PLANE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexGenfvOES")]
            public static 
            void GetTexGen(OpenTK.Graphics.ES11.All coord, OpenTK.Graphics.ES11.All pname, Single[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = @params)
                    {
                        Delegates.glGetTexGenfvOES((OpenTK.Graphics.ES11.All)coord, (OpenTK.Graphics.ES11.All)pname, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return texture coordinate generation parameters
        /// </summary>
        /// <param name="coord">
        /// <para>
        /// Specifies a texture coordinate. Must be GL_S, GL_T, GL_R, or GL_Q.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the value(s) to be returned. Must be either GL_TEXTURE_GEN_MODE or the name of one of the texture generation plane equations: GL_OBJECT_PLANE or GL_EYE_PLANE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexGenivOES")]
            public static 
            unsafe void GetTexGen(OpenTK.Graphics.ES11.All coord, OpenTK.Graphics.ES11.All pname, Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetTexGenivOES((OpenTK.Graphics.ES11.All)coord, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return texture coordinate generation parameters
        /// </summary>
        /// <param name="coord">
        /// <para>
        /// Specifies a texture coordinate. Must be GL_S, GL_T, GL_R, or GL_Q.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the value(s) to be returned. Must be either GL_TEXTURE_GEN_MODE or the name of one of the texture generation plane equations: GL_OBJECT_PLANE or GL_EYE_PLANE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexGenivOES")]
            public static 
            void GetTexGen(OpenTK.Graphics.ES11.All coord, OpenTK.Graphics.ES11.All pname, Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glGetTexGenivOES((OpenTK.Graphics.ES11.All)coord, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Return texture coordinate generation parameters
        /// </summary>
        /// <param name="coord">
        /// <para>
        /// Specifies a texture coordinate. Must be GL_S, GL_T, GL_R, or GL_Q.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the value(s) to be returned. Must be either GL_TEXTURE_GEN_MODE or the name of one of the texture generation plane equations: GL_OBJECT_PLANE or GL_EYE_PLANE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexGenivOES")]
            public static 
            void GetTexGen(OpenTK.Graphics.ES11.All coord, OpenTK.Graphics.ES11.All pname, ref Int32 @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = &@params)
                    {
                        Delegates.glGetTexGenivOES((OpenTK.Graphics.ES11.All)coord, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexGenxvOES")]
            public static 
            unsafe void GetTexGenx(OpenTK.Graphics.ES11.All coord, OpenTK.Graphics.ES11.All pname, int* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetTexGenxvOES((OpenTK.Graphics.ES11.All)coord, (OpenTK.Graphics.ES11.All)pname, (int*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexGenxvOES")]
            public static 
            void GetTexGenx(OpenTK.Graphics.ES11.All coord, OpenTK.Graphics.ES11.All pname, int[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* @params_ptr = @params)
                    {
                        Delegates.glGetTexGenxvOES((OpenTK.Graphics.ES11.All)coord, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexGenxvOES")]
            public static 
            void GetTexGenx(OpenTK.Graphics.ES11.All coord, OpenTK.Graphics.ES11.All pname, ref int @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* @params_ptr = &@params)
                    {
                        Delegates.glGetTexGenxvOES((OpenTK.Graphics.ES11.All)coord, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexParameterxvOES")]
            public static 
            unsafe void GetTexParameterx(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, int* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glGetTexParameterxvOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (int*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexParameterxvOES")]
            public static 
            void GetTexParameterx(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, int[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* @params_ptr = @params)
                    {
                        Delegates.glGetTexParameterxvOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glGetTexParameterxvOES")]
            public static 
            void GetTexParameterx(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, ref int @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* @params_ptr = &@params)
                    {
                        Delegates.glGetTexParameterxvOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glIsFramebufferOES")]
            public static 
            bool IsFramebuffer(Int32 framebuffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsFramebufferOES((UInt32)framebuffer);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glIsFramebufferOES")]
            public static 
            bool IsFramebuffer(UInt32 framebuffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsFramebufferOES((UInt32)framebuffer);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glIsRenderbufferOES")]
            public static 
            bool IsRenderbuffer(Int32 renderbuffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsRenderbufferOES((UInt32)renderbuffer);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glIsRenderbufferOES")]
            public static 
            bool IsRenderbuffer(UInt32 renderbuffer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glIsRenderbufferOES((UInt32)renderbuffer);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLightModelxOES")]
            public static 
            void LightModelx(OpenTK.Graphics.ES11.All pname, int param)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glLightModelxOES((OpenTK.Graphics.ES11.All)pname, (int)param);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLightModelxvOES")]
            public static 
            unsafe void LightModelx(OpenTK.Graphics.ES11.All pname, int* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glLightModelxvOES((OpenTK.Graphics.ES11.All)pname, (int*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLightModelxvOES")]
            public static 
            void LightModelx(OpenTK.Graphics.ES11.All pname, int[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* @params_ptr = @params)
                    {
                        Delegates.glLightModelxvOES((OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLightxOES")]
            public static 
            void Lightx(OpenTK.Graphics.ES11.All light, OpenTK.Graphics.ES11.All pname, int param)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glLightxOES((OpenTK.Graphics.ES11.All)light, (OpenTK.Graphics.ES11.All)pname, (int)param);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLightxvOES")]
            public static 
            unsafe void Lightx(OpenTK.Graphics.ES11.All light, OpenTK.Graphics.ES11.All pname, int* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glLightxvOES((OpenTK.Graphics.ES11.All)light, (OpenTK.Graphics.ES11.All)pname, (int*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLightxvOES")]
            public static 
            void Lightx(OpenTK.Graphics.ES11.All light, OpenTK.Graphics.ES11.All pname, int[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* @params_ptr = @params)
                    {
                        Delegates.glLightxvOES((OpenTK.Graphics.ES11.All)light, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLineWidthxOES")]
            public static 
            void LineWidthx(int width)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glLineWidthxOES((int)width);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLoadMatrixxOES")]
            public static 
            unsafe void LoadMatrixx(int* m)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glLoadMatrixxOES((int*)m);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLoadMatrixxOES")]
            public static 
            void LoadMatrixx(int[] m)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* m_ptr = m)
                    {
                        Delegates.glLoadMatrixxOES((int*)m_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLoadMatrixxOES")]
            public static 
            void LoadMatrixx(ref int m)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* m_ptr = &m)
                    {
                        Delegates.glLoadMatrixxOES((int*)m_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glLoadPaletteFromModelViewMatrixOES")]
            public static 
            void LoadPaletteFromModelViewMatrix()
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glLoadPaletteFromModelViewMatrixOES();
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Map a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object being mapped. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="access">
        /// <para>
        /// Specifies the access policy, indicating whether it will be possible to read from, write to, or both read from and write to the buffer object's mapped data store. The symbolic constant must be GL_READ_ONLY, GL_WRITE_ONLY, or GL_READ_WRITE.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMapBufferOES")]
            public static 
            unsafe System.IntPtr MapBuffer(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All access)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glMapBufferOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)access);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMaterialxOES")]
            public static 
            void Materialx(OpenTK.Graphics.ES11.All face, OpenTK.Graphics.ES11.All pname, int param)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMaterialxOES((OpenTK.Graphics.ES11.All)face, (OpenTK.Graphics.ES11.All)pname, (int)param);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMaterialxvOES")]
            public static 
            unsafe void Materialx(OpenTK.Graphics.ES11.All face, OpenTK.Graphics.ES11.All pname, int* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMaterialxvOES((OpenTK.Graphics.ES11.All)face, (OpenTK.Graphics.ES11.All)pname, (int*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMaterialxvOES")]
            public static 
            void Materialx(OpenTK.Graphics.ES11.All face, OpenTK.Graphics.ES11.All pname, int[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* @params_ptr = @params)
                    {
                        Delegates.glMaterialxvOES((OpenTK.Graphics.ES11.All)face, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMatrixIndexPointerOES")]
            public static 
            void MatrixIndexPointer<T3>(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] ref T3 pointer)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glMatrixIndexPointerOES((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                    pointer = (T3)pointer_ptr.Target;
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMatrixIndexPointerOES")]
            public static 
            void MatrixIndexPointer<T3>(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] T3[,,] pointer)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glMatrixIndexPointerOES((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMatrixIndexPointerOES")]
            public static 
            void MatrixIndexPointer<T3>(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] T3[,] pointer)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glMatrixIndexPointerOES((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMatrixIndexPointerOES")]
            public static 
            void MatrixIndexPointer<T3>(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] T3[] pointer)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glMatrixIndexPointerOES((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMatrixIndexPointerOES")]
            public static 
            void MatrixIndexPointer(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, IntPtr pointer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMatrixIndexPointerOES((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMultiTexCoord4xOES")]
            public static 
            void MultiTexCoord4x(OpenTK.Graphics.ES11.All target, int s, int t, int r, int q)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultiTexCoord4xOES((OpenTK.Graphics.ES11.All)target, (int)s, (int)t, (int)r, (int)q);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMultMatrixxOES")]
            public static 
            unsafe void MultMatrixx(int* m)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glMultMatrixxOES((int*)m);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMultMatrixxOES")]
            public static 
            void MultMatrixx(int[] m)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* m_ptr = m)
                    {
                        Delegates.glMultMatrixxOES((int*)m_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glMultMatrixxOES")]
            public static 
            void MultMatrixx(ref int m)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* m_ptr = &m)
                    {
                        Delegates.glMultMatrixxOES((int*)m_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glNormal3xOES")]
            public static 
            void Normal3x(int nx, int ny, int nz)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glNormal3xOES((int)nx, (int)ny, (int)nz);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Multiply the current matrix with an orthographic matrix
        /// </summary>
        /// <param name="left">
        /// <para>
        /// Specify the coordinates for the left and right vertical clipping planes.
        /// </para>
        /// </param>
        /// <param name="bottom">
        /// <para>
        /// Specify the coordinates for the bottom and top horizontal clipping planes.
        /// </para>
        /// </param>
        /// <param name="nearVal">
        /// <para>
        /// Specify the distances to the nearer and farther depth clipping planes. These values are negative if the plane is to be behind the viewer.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glOrthofOES")]
            public static 
            void Ortho(Single left, Single right, Single bottom, Single top, Single zNear, Single zFar)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glOrthofOES((Single)left, (Single)right, (Single)bottom, (Single)top, (Single)zNear, (Single)zFar);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glOrthoxOES")]
            public static 
            void Orthox(int left, int right, int bottom, int top, int zNear, int zFar)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glOrthoxOES((int)left, (int)right, (int)bottom, (int)top, (int)zNear, (int)zFar);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPointParameterxOES")]
            public static 
            void PointParameterx(OpenTK.Graphics.ES11.All pname, int param)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glPointParameterxOES((OpenTK.Graphics.ES11.All)pname, (int)param);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPointParameterxvOES")]
            public static 
            unsafe void PointParameterx(OpenTK.Graphics.ES11.All pname, int* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glPointParameterxvOES((OpenTK.Graphics.ES11.All)pname, (int*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPointParameterxvOES")]
            public static 
            void PointParameterx(OpenTK.Graphics.ES11.All pname, int[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* @params_ptr = @params)
                    {
                        Delegates.glPointParameterxvOES((OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPointSizePointerOES")]
            public static 
            void PointSizePointer<T2>(OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] ref T2 pointer)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glPointSizePointerOES((OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                    pointer = (T2)pointer_ptr.Target;
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPointSizePointerOES")]
            public static 
            void PointSizePointer<T2>(OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] T2[,,] pointer)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glPointSizePointerOES((OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPointSizePointerOES")]
            public static 
            void PointSizePointer<T2>(OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] T2[,] pointer)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glPointSizePointerOES((OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPointSizePointerOES")]
            public static 
            void PointSizePointer<T2>(OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] T2[] pointer)
                where T2 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glPointSizePointerOES((OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPointSizePointerOES")]
            public static 
            void PointSizePointer(OpenTK.Graphics.ES11.All type, Int32 stride, IntPtr pointer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glPointSizePointerOES((OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPointSizexOES")]
            public static 
            void PointSizex(int size)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glPointSizexOES((int)size);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glPolygonOffsetxOES")]
            public static 
            void PolygonOffsetx(int factor, int units)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glPolygonOffsetxOES((int)factor, (int)units);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glQueryMatrixxOES")]
            public static 
            unsafe Int32 QueryMatrixx(int* mantissa, Int32* exponent)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glQueryMatrixxOES((int*)mantissa, (Int32*)exponent);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glQueryMatrixxOES")]
            public static 
            Int32 QueryMatrixx(int[] mantissa, Int32[] exponent)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* mantissa_ptr = mantissa)
                    fixed (Int32* exponent_ptr = exponent)
                    {
                        return Delegates.glQueryMatrixxOES((int*)mantissa_ptr, (Int32*)exponent_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glQueryMatrixxOES")]
            public static 
            Int32 QueryMatrixx(ref int mantissa, ref Int32 exponent)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* mantissa_ptr = &mantissa)
                    fixed (Int32* exponent_ptr = &exponent)
                    {
                        return Delegates.glQueryMatrixxOES((int*)mantissa_ptr, (Int32*)exponent_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glRenderbufferStorageOES")]
            public static 
            void RenderbufferStorage(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All internalformat, Int32 width, Int32 height)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glRenderbufferStorageOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)internalformat, (Int32)width, (Int32)height);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glRotatexOES")]
            public static 
            void Rotatex(int angle, int x, int y, int z)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glRotatexOES((int)angle, (int)x, (int)y, (int)z);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glSampleCoveragexOES")]
            public static 
            void SampleCoveragex(int value, bool invert)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glSampleCoveragexOES((int)value, (bool)invert);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glScalexOES")]
            public static 
            void Scalex(int x, int y, int z)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glScalexOES((int)x, (int)y, (int)z);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexEnvxOES")]
            public static 
            void TexEnvx(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, int param)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glTexEnvxOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (int)param);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexEnvxvOES")]
            public static 
            unsafe void TexEnvx(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, int* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glTexEnvxvOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (int*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexEnvxvOES")]
            public static 
            void TexEnvx(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, int[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* @params_ptr = @params)
                    {
                        Delegates.glTexEnvxvOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Control the generation of texture coordinates
        /// </summary>
        /// <param name="coord">
        /// <para>
        /// Specifies a texture coordinate. Must be one of GL_S, GL_T, GL_R, or GL_Q.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the texture-coordinate generation function. Must be GL_TEXTURE_GEN_MODE.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies a single-valued texture generation parameter, one of GL_OBJECT_LINEAR, GL_EYE_LINEAR, GL_SPHERE_MAP, GL_NORMAL_MAP, or GL_REFLECTION_MAP.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexGenfOES")]
            public static 
            void TexGen(OpenTK.Graphics.ES11.All coord, OpenTK.Graphics.ES11.All pname, Single param)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glTexGenfOES((OpenTK.Graphics.ES11.All)coord, (OpenTK.Graphics.ES11.All)pname, (Single)param);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Control the generation of texture coordinates
        /// </summary>
        /// <param name="coord">
        /// <para>
        /// Specifies a texture coordinate. Must be one of GL_S, GL_T, GL_R, or GL_Q.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the texture-coordinate generation function. Must be GL_TEXTURE_GEN_MODE.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies a single-valued texture generation parameter, one of GL_OBJECT_LINEAR, GL_EYE_LINEAR, GL_SPHERE_MAP, GL_NORMAL_MAP, or GL_REFLECTION_MAP.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexGenfvOES")]
            public static 
            unsafe void TexGen(OpenTK.Graphics.ES11.All coord, OpenTK.Graphics.ES11.All pname, Single* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glTexGenfvOES((OpenTK.Graphics.ES11.All)coord, (OpenTK.Graphics.ES11.All)pname, (Single*)@params);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Control the generation of texture coordinates
        /// </summary>
        /// <param name="coord">
        /// <para>
        /// Specifies a texture coordinate. Must be one of GL_S, GL_T, GL_R, or GL_Q.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the texture-coordinate generation function. Must be GL_TEXTURE_GEN_MODE.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies a single-valued texture generation parameter, one of GL_OBJECT_LINEAR, GL_EYE_LINEAR, GL_SPHERE_MAP, GL_NORMAL_MAP, or GL_REFLECTION_MAP.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexGenfvOES")]
            public static 
            void TexGen(OpenTK.Graphics.ES11.All coord, OpenTK.Graphics.ES11.All pname, Single[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Single* @params_ptr = @params)
                    {
                        Delegates.glTexGenfvOES((OpenTK.Graphics.ES11.All)coord, (OpenTK.Graphics.ES11.All)pname, (Single*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Control the generation of texture coordinates
        /// </summary>
        /// <param name="coord">
        /// <para>
        /// Specifies a texture coordinate. Must be one of GL_S, GL_T, GL_R, or GL_Q.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the texture-coordinate generation function. Must be GL_TEXTURE_GEN_MODE.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies a single-valued texture generation parameter, one of GL_OBJECT_LINEAR, GL_EYE_LINEAR, GL_SPHERE_MAP, GL_NORMAL_MAP, or GL_REFLECTION_MAP.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexGeniOES")]
            public static 
            void TexGen(OpenTK.Graphics.ES11.All coord, OpenTK.Graphics.ES11.All pname, Int32 param)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glTexGeniOES((OpenTK.Graphics.ES11.All)coord, (OpenTK.Graphics.ES11.All)pname, (Int32)param);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Control the generation of texture coordinates
        /// </summary>
        /// <param name="coord">
        /// <para>
        /// Specifies a texture coordinate. Must be one of GL_S, GL_T, GL_R, or GL_Q.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the texture-coordinate generation function. Must be GL_TEXTURE_GEN_MODE.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies a single-valued texture generation parameter, one of GL_OBJECT_LINEAR, GL_EYE_LINEAR, GL_SPHERE_MAP, GL_NORMAL_MAP, or GL_REFLECTION_MAP.
        /// </para>
        /// </param>
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexGenivOES")]
            public static 
            unsafe void TexGen(OpenTK.Graphics.ES11.All coord, OpenTK.Graphics.ES11.All pname, Int32* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glTexGenivOES((OpenTK.Graphics.ES11.All)coord, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params);
                #if DEBUG
                }
                #endif
            }

            
        /// <summary>
        /// Control the generation of texture coordinates
        /// </summary>
        /// <param name="coord">
        /// <para>
        /// Specifies a texture coordinate. Must be one of GL_S, GL_T, GL_R, or GL_Q.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the symbolic name of the texture-coordinate generation function. Must be GL_TEXTURE_GEN_MODE.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies a single-valued texture generation parameter, one of GL_OBJECT_LINEAR, GL_EYE_LINEAR, GL_SPHERE_MAP, GL_NORMAL_MAP, or GL_REFLECTION_MAP.
        /// </para>
        /// </param>
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexGenivOES")]
            public static 
            void TexGen(OpenTK.Graphics.ES11.All coord, OpenTK.Graphics.ES11.All pname, Int32[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (Int32* @params_ptr = @params)
                    {
                        Delegates.glTexGenivOES((OpenTK.Graphics.ES11.All)coord, (OpenTK.Graphics.ES11.All)pname, (Int32*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexGenxOES")]
            public static 
            void TexGenx(OpenTK.Graphics.ES11.All coord, OpenTK.Graphics.ES11.All pname, int param)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glTexGenxOES((OpenTK.Graphics.ES11.All)coord, (OpenTK.Graphics.ES11.All)pname, (int)param);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexGenxvOES")]
            public static 
            unsafe void TexGenx(OpenTK.Graphics.ES11.All coord, OpenTK.Graphics.ES11.All pname, int* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glTexGenxvOES((OpenTK.Graphics.ES11.All)coord, (OpenTK.Graphics.ES11.All)pname, (int*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexGenxvOES")]
            public static 
            void TexGenx(OpenTK.Graphics.ES11.All coord, OpenTK.Graphics.ES11.All pname, int[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* @params_ptr = @params)
                    {
                        Delegates.glTexGenxvOES((OpenTK.Graphics.ES11.All)coord, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexParameterxOES")]
            public static 
            void TexParameterx(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, int param)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glTexParameterxOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (int)param);
                #if DEBUG
                }
                #endif
            }

            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexParameterxvOES")]
            public static 
            unsafe void TexParameterx(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, int* @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glTexParameterxvOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (int*)@params);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTexParameterxvOES")]
            public static 
            void TexParameterx(OpenTK.Graphics.ES11.All target, OpenTK.Graphics.ES11.All pname, int[] @params)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                unsafe
                {
                    fixed (int* @params_ptr = @params)
                    {
                        Delegates.glTexParameterxvOES((OpenTK.Graphics.ES11.All)target, (OpenTK.Graphics.ES11.All)pname, (int*)@params_ptr);
                    }
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glTranslatexOES")]
            public static 
            void Translatex(int x, int y, int z)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glTranslatexOES((int)x, (int)y, (int)z);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glUnmapBufferOES")]
            public static 
            bool UnmapBuffer(OpenTK.Graphics.ES11.All target)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                return Delegates.glUnmapBufferOES((OpenTK.Graphics.ES11.All)target);
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glWeightPointerOES")]
            public static 
            void WeightPointer<T3>(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] ref T3 pointer)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glWeightPointerOES((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                    pointer = (T3)pointer_ptr.Target;
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glWeightPointerOES")]
            public static 
            void WeightPointer<T3>(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] T3[,,] pointer)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glWeightPointerOES((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glWeightPointerOES")]
            public static 
            void WeightPointer<T3>(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] T3[,] pointer)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glWeightPointerOES((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glWeightPointerOES")]
            public static 
            void WeightPointer<T3>(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, [InAttribute, OutAttribute] T3[] pointer)
                where T3 : struct
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
                try
                {
                    Delegates.glWeightPointerOES((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
                #if DEBUG
                }
                #endif
            }

            [AutoGenerated(Category = "1.1", Version = "1.1", EntryPoint = "glWeightPointerOES")]
            public static 
            void WeightPointer(Int32 size, OpenTK.Graphics.ES11.All type, Int32 stride, IntPtr pointer)
            {
                #if DEBUG
                using (new ErrorHelper(GraphicsContext.CurrentContext))
                {
                #endif
                Delegates.glWeightPointerOES((Int32)size, (OpenTK.Graphics.ES11.All)type, (Int32)stride, (IntPtr)pointer);
                #if DEBUG
                }
                #endif
            }

        }

    }
}
