/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class WIN32Window!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &WIN32WindowBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 WIN32WindowBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
WIN32WindowPtr WIN32WindowBase::create(void) 
{
    WIN32WindowPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = WIN32WindowPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
WIN32WindowPtr WIN32WindowBase::createEmpty(void) 
{ 
    WIN32WindowPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the WIN32Window::_sfHwnd field.
inline
SFHWND *WIN32WindowBase::getSFHwnd(void)
{
    return &_sfHwnd;
}

//! Get the WIN32Window::_sfHdc field.
inline
SFHDC *WIN32WindowBase::getSFHdc(void)
{
    return &_sfHdc;
}

//! Get the WIN32Window::_sfHglrc field.
inline
SFHGLRC *WIN32WindowBase::getSFHglrc(void)
{
    return &_sfHglrc;
}


//! Get the value of the WIN32Window::_sfHwnd field.
inline
HWND &WIN32WindowBase::getHwnd(void)
{
    return _sfHwnd.getValue();
}

//! Get the value of the WIN32Window::_sfHwnd field.
inline
const HWND &WIN32WindowBase::getHwnd(void) const
{
    return _sfHwnd.getValue();
}

//! Set the value of the WIN32Window::_sfHwnd field.
inline
void WIN32WindowBase::setHwnd(const HWND &value)
{
    _sfHwnd.setValue(value);
}

//! Get the value of the WIN32Window::_sfHdc field.
inline
HDC &WIN32WindowBase::getHdc(void)
{
    return _sfHdc.getValue();
}

//! Get the value of the WIN32Window::_sfHdc field.
inline
const HDC &WIN32WindowBase::getHdc(void) const
{
    return _sfHdc.getValue();
}

//! Set the value of the WIN32Window::_sfHdc field.
inline
void WIN32WindowBase::setHdc(const HDC &value)
{
    _sfHdc.setValue(value);
}

//! Get the value of the WIN32Window::_sfHglrc field.
inline
HGLRC &WIN32WindowBase::getHglrc(void)
{
    return _sfHglrc.getValue();
}

//! Get the value of the WIN32Window::_sfHglrc field.
inline
const HGLRC &WIN32WindowBase::getHglrc(void) const
{
    return _sfHglrc.getValue();
}

//! Set the value of the WIN32Window::_sfHglrc field.
inline
void WIN32WindowBase::setHglrc(const HGLRC &value)
{
    _sfHglrc.setValue(value);
}


OSG_END_NAMESPACE

#define OSGWIN32WINDOWBASE_INLINE_CVSID "@(#)$Id: FCBaseTemplate_inl.h,v 1.20 2002/12/04 14:22:22 dirk Exp $"

