/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class ProjectionCameraDecorator
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGPROJECTIONCAMERADECORATORBASE_H_
#define _OSGPROJECTIONCAMERADECORATORBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include <OSGSystemDef.h>

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGStereoCameraDecorator.h> // Parent

#include <OSGNodeFields.h> // User type
#include <OSGPnt3fFields.h> // Surface type
#include <OSGPlaneFields.h> // Left type
#include <OSGPlaneFields.h> // Bottom type
#include <OSGPlaneFields.h> // Normal type
#include <OSGReal32Fields.h> // Width type
#include <OSGReal32Fields.h> // Height type

#include <OSGProjectionCameraDecoratorFields.h>

OSG_BEGIN_NAMESPACE

class ProjectionCameraDecorator;
class BinaryDataHandler;

//! \brief ProjectionCameraDecorator Base Class.

class OSG_SYSTEMLIB_DLLMAPPING ProjectionCameraDecoratorBase : public StereoCameraDecorator
{
  private:

    typedef StereoCameraDecorator    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef ProjectionCameraDecoratorPtr  Ptr;

    enum
    {
        UserFieldId    = Inherited::NextFieldId,
        SurfaceFieldId = UserFieldId    + 1,
        LeftFieldId    = SurfaceFieldId + 1,
        BottomFieldId  = LeftFieldId    + 1,
        NormalFieldId  = BottomFieldId  + 1,
        WidthFieldId   = NormalFieldId  + 1,
        HeightFieldId  = WidthFieldId   + 1,
        NextFieldId    = HeightFieldId  + 1
    };

    static const OSG::BitVector UserFieldMask;
    static const OSG::BitVector SurfaceFieldMask;
    static const OSG::BitVector LeftFieldMask;
    static const OSG::BitVector BottomFieldMask;
    static const OSG::BitVector NormalFieldMask;
    static const OSG::BitVector WidthFieldMask;
    static const OSG::BitVector HeightFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFNodePtr           *getSFUser           (void);
           MFPnt3f             *getMFSurface        (void);
           SFReal32            *getSFWidth          (void);
           SFReal32            *getSFHeight         (void);

           NodePtr             &getUser           (void);
     const NodePtr             &getUser           (void) const;
           Real32              &getWidth          (void);
     const Real32              &getWidth          (void) const;
           Real32              &getHeight         (void);
     const Real32              &getHeight         (void) const;
           Pnt3f               &getSurface        (const UInt32 index);
           MFPnt3f             &getSurface        (void);
     const MFPnt3f             &getSurface        (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setUser           ( const NodePtr &value );
     void setWidth          ( const Real32 &value );
     void setHeight         ( const Real32 &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  ProjectionCameraDecoratorPtr      create          (void); 
    static  ProjectionCameraDecoratorPtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFNodePtr           _sfUser;
    MFPnt3f             _mfSurface;
    SFPlane             _sfLeft;
    SFPlane             _sfBottom;
    SFPlane             _sfNormal;
    SFReal32            _sfWidth;
    SFReal32            _sfHeight;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    ProjectionCameraDecoratorBase(void);
    ProjectionCameraDecoratorBase(const ProjectionCameraDecoratorBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~ProjectionCameraDecoratorBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFPlane             *getSFLeft           (void);
           SFPlane             *getSFBottom         (void);
           SFPlane             *getSFNormal         (void);

           Plane               &getLeft           (void);
     const Plane               &getLeft           (void) const;
           Plane               &getBottom         (void);
     const Plane               &getBottom         (void) const;
           Plane               &getNormal         (void);
     const Plane               &getNormal         (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setLeft           (const Plane &value);
     void setBottom         (const Plane &value);
     void setNormal         (const Plane &value);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      ProjectionCameraDecoratorBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      ProjectionCameraDecoratorBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const ProjectionCameraDecoratorBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef ProjectionCameraDecoratorBase *ProjectionCameraDecoratorBaseP;

typedef osgIF<ProjectionCameraDecoratorBase::isNodeCore,
              CoredNodePtr<ProjectionCameraDecorator>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet ProjectionCameraDecoratorNodePtr;

typedef RefPtr<ProjectionCameraDecoratorPtr> ProjectionCameraDecoratorRefPtr;

OSG_END_NAMESPACE

#define OSGPROJECTIONCAMERADECORATORBASE_HEADER_CVSID "@(#)$Id: FCBaseTemplate_h.h,v 1.40 2005/07/20 00:10:14 vossg Exp $"

#endif /* _OSGPROJECTIONCAMERADECORATORBASE_H_ */
