/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class OrthographicCamera!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &OrthographicCameraBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 OrthographicCameraBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
OrthographicCameraPtr OrthographicCameraBase::create(void) 
{
    OrthographicCameraPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = OrthographicCameraPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
OrthographicCameraPtr OrthographicCameraBase::createEmpty(void) 
{ 
    OrthographicCameraPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the OrthographicCamera::_sfVerticalSize field.
inline
SFReal32 *OrthographicCameraBase::getSFVerticalSize(void)
{
    return &_sfVerticalSize;
}

//! Get the OrthographicCamera::_sfAspect field.
inline
SFReal32 *OrthographicCameraBase::getSFAspect(void)
{
    return &_sfAspect;
}


//! Get the value of the OrthographicCamera::_sfVerticalSize field.
inline
Real32 &OrthographicCameraBase::getVerticalSize(void)
{
    return _sfVerticalSize.getValue();
}

//! Get the value of the OrthographicCamera::_sfVerticalSize field.
inline
const Real32 &OrthographicCameraBase::getVerticalSize(void) const
{
    return _sfVerticalSize.getValue();
}

//! Set the value of the OrthographicCamera::_sfVerticalSize field.
inline
void OrthographicCameraBase::setVerticalSize(const Real32 &value)
{
    _sfVerticalSize.setValue(value);
}

//! Get the value of the OrthographicCamera::_sfAspect field.
inline
Real32 &OrthographicCameraBase::getAspect(void)
{
    return _sfAspect.getValue();
}

//! Get the value of the OrthographicCamera::_sfAspect field.
inline
const Real32 &OrthographicCameraBase::getAspect(void) const
{
    return _sfAspect.getValue();
}

//! Set the value of the OrthographicCamera::_sfAspect field.
inline
void OrthographicCameraBase::setAspect(const Real32 &value)
{
    _sfAspect.setValue(value);
}


OSG_END_NAMESPACE

#define OSGORTHOGRAPHICCAMERABASE_INLINE_CVSID "@(#)$Id: OSGOrthographicCameraBase.inl,v 1.2 2006/02/20 16:54:30 dirk Exp $"

