/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class OrthographicCamera!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEORTHOGRAPHICCAMERAINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGOrthographicCameraBase.h"
#include "OSGOrthographicCamera.h"


OSG_USING_NAMESPACE

const OSG::BitVector  OrthographicCameraBase::VerticalSizeFieldMask = 
    (TypeTraits<BitVector>::One << OrthographicCameraBase::VerticalSizeFieldId);

const OSG::BitVector  OrthographicCameraBase::AspectFieldMask = 
    (TypeTraits<BitVector>::One << OrthographicCameraBase::AspectFieldId);

const OSG::BitVector OrthographicCameraBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Real32          OrthographicCameraBase::_sfVerticalSize
    The vertical size of the camera box, in world units.
*/
/*! \var Real32          OrthographicCameraBase::_sfAspect
    The aspect ratio (i.e. width / height) of a pixel.
*/

//! OrthographicCamera description

FieldDescription *OrthographicCameraBase::_desc[] = 
{
    new FieldDescription(SFReal32::getClassType(), 
                     "verticalSize", 
                     VerticalSizeFieldId, VerticalSizeFieldMask,
                     false,
                     (FieldAccessMethod) &OrthographicCameraBase::getSFVerticalSize),
    new FieldDescription(SFReal32::getClassType(), 
                     "aspect", 
                     AspectFieldId, AspectFieldMask,
                     false,
                     (FieldAccessMethod) &OrthographicCameraBase::getSFAspect)
};


FieldContainerType OrthographicCameraBase::_type(
    "OrthographicCamera",
    "Camera",
    NULL,
    (PrototypeCreateF) &OrthographicCameraBase::createEmpty,
    OrthographicCamera::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(OrthographicCameraBase, OrthographicCameraPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &OrthographicCameraBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &OrthographicCameraBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr OrthographicCameraBase::shallowCopy(void) const 
{ 
    OrthographicCameraPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const OrthographicCamera *>(this)); 

    return returnValue; 
}

UInt32 OrthographicCameraBase::getContainerSize(void) const 
{ 
    return sizeof(OrthographicCamera); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void OrthographicCameraBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((OrthographicCameraBase *) &other, whichField);
}
#else
void OrthographicCameraBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((OrthographicCameraBase *) &other, whichField, sInfo);
}
void OrthographicCameraBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void OrthographicCameraBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

OrthographicCameraBase::OrthographicCameraBase(void) :
    _sfVerticalSize           (), 
    _sfAspect                 (Real32(1)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

OrthographicCameraBase::OrthographicCameraBase(const OrthographicCameraBase &source) :
    _sfVerticalSize           (source._sfVerticalSize           ), 
    _sfAspect                 (source._sfAspect                 ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

OrthographicCameraBase::~OrthographicCameraBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 OrthographicCameraBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (VerticalSizeFieldMask & whichField))
    {
        returnValue += _sfVerticalSize.getBinSize();
    }

    if(FieldBits::NoField != (AspectFieldMask & whichField))
    {
        returnValue += _sfAspect.getBinSize();
    }


    return returnValue;
}

void OrthographicCameraBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (VerticalSizeFieldMask & whichField))
    {
        _sfVerticalSize.copyToBin(pMem);
    }

    if(FieldBits::NoField != (AspectFieldMask & whichField))
    {
        _sfAspect.copyToBin(pMem);
    }


}

void OrthographicCameraBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (VerticalSizeFieldMask & whichField))
    {
        _sfVerticalSize.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (AspectFieldMask & whichField))
    {
        _sfAspect.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void OrthographicCameraBase::executeSyncImpl(      OrthographicCameraBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (VerticalSizeFieldMask & whichField))
        _sfVerticalSize.syncWith(pOther->_sfVerticalSize);

    if(FieldBits::NoField != (AspectFieldMask & whichField))
        _sfAspect.syncWith(pOther->_sfAspect);


}
#else
void OrthographicCameraBase::executeSyncImpl(      OrthographicCameraBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (VerticalSizeFieldMask & whichField))
        _sfVerticalSize.syncWith(pOther->_sfVerticalSize);

    if(FieldBits::NoField != (AspectFieldMask & whichField))
        _sfAspect.syncWith(pOther->_sfAspect);



}

void OrthographicCameraBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<OrthographicCameraPtr>::_type("OrthographicCameraPtr", "CameraPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(OrthographicCameraPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(OrthographicCameraPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGOrthographicCameraBase.cpp,v 1.2 2006/02/20 16:54:30 dirk Exp $";
    static Char8 cvsid_hpp       [] = OSGORTHOGRAPHICCAMERABASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGORTHOGRAPHICCAMERABASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGORTHOGRAPHICCAMERAFIELDS_HEADER_CVSID;
}

