/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class DVRVolumeTexture
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGDVRVOLUMETEXTUREBASE_H_
#define _OSGDVRVOLUMETEXTUREBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include <OSGSystemDef.h>

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGAttachment.h> // Parent

#include <OSGImageFields.h> // Image type
#include <OSGReal32Fields.h> // Histogram type
#include <OSGReal32Fields.h> // MaxVal type
#include <OSGVec3fFields.h> // SliceThickness type
#include <OSGVec3fFields.h> // Resolution type
#include <OSGStringFields.h> // FileName type

#include <OSGDVRVolumeTextureFields.h>

OSG_BEGIN_NAMESPACE

class DVRVolumeTexture;
class BinaryDataHandler;

//! \brief DVRVolumeTexture Base Class.

class OSG_SYSTEMLIB_DLLMAPPING DVRVolumeTextureBase : public Attachment
{
  private:

    typedef Attachment    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef DVRVolumeTexturePtr  Ptr;

    enum
    {
        ImageFieldId          = Inherited::NextFieldId,
        HistogramFieldId      = ImageFieldId          + 1,
        MaxValFieldId         = HistogramFieldId      + 1,
        SliceThicknessFieldId = MaxValFieldId         + 1,
        ResolutionFieldId     = SliceThicknessFieldId + 1,
        FileNameFieldId       = ResolutionFieldId     + 1,
        NextFieldId           = FileNameFieldId       + 1
    };

    static const OSG::BitVector ImageFieldMask;
    static const OSG::BitVector HistogramFieldMask;
    static const OSG::BitVector MaxValFieldMask;
    static const OSG::BitVector SliceThicknessFieldMask;
    static const OSG::BitVector ResolutionFieldMask;
    static const OSG::BitVector FileNameFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFImagePtr          *getSFImage          (void);
           MFReal32            *getMFHistogram      (void);
           SFReal32            *getSFMaxVal         (void);
           SFVec3f             *getSFSliceThickness (void);
           SFVec3f             *getSFResolution     (void);
           SFString            *getSFFileName       (void);

           ImagePtr            &getImage          (void);
     const ImagePtr            &getImage          (void) const;
           Real32              &getMaxVal         (void);
     const Real32              &getMaxVal         (void) const;
           Vec3f               &getSliceThickness (void);
     const Vec3f               &getSliceThickness (void) const;
           Vec3f               &getResolution     (void);
     const Vec3f               &getResolution     (void) const;
           std::string         &getFileName       (void);
     const std::string         &getFileName       (void) const;
           Real32              &getHistogram      (const UInt32 index);
           MFReal32            &getHistogram      (void);
     const MFReal32            &getHistogram      (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setImage          ( const ImagePtr &value );
     void setMaxVal         ( const Real32 &value );
     void setSliceThickness ( const Vec3f &value );
     void setResolution     ( const Vec3f &value );
     void setFileName       ( const std::string &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  DVRVolumeTexturePtr      create          (void); 
    static  DVRVolumeTexturePtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFImagePtr          _sfImage;
    MFReal32            _mfHistogram;
    SFReal32            _sfMaxVal;
    SFVec3f             _sfSliceThickness;
    SFVec3f             _sfResolution;
    SFString            _sfFileName;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    DVRVolumeTextureBase(void);
    DVRVolumeTextureBase(const DVRVolumeTextureBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~DVRVolumeTextureBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      DVRVolumeTextureBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      DVRVolumeTextureBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const DVRVolumeTextureBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef DVRVolumeTextureBase *DVRVolumeTextureBaseP;

typedef osgIF<DVRVolumeTextureBase::isNodeCore,
              CoredNodePtr<DVRVolumeTexture>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet DVRVolumeTextureNodePtr;

typedef RefPtr<DVRVolumeTexturePtr> DVRVolumeTextureRefPtr;

OSG_END_NAMESPACE

#define OSGDVRVOLUMETEXTUREBASE_HEADER_CVSID "@(#)$Id: FCBaseTemplate_h.h,v 1.40 2005/07/20 00:10:14 vossg Exp $"

#endif /* _OSGDVRVOLUMETEXTUREBASE_H_ */
