/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class AbstractText
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGABSTRACTTEXTBASE_H_
#define _OSGABSTRACTTEXTBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include <OSGSystemDef.h>

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGMaterialDrawable.h> // Parent

#include <OSGVec3fFields.h> // Position type
#include <OSGSharedFontStyleWrapperFields.h> // Font type
#include <OSGStringFields.h> // Text type
#include <OSGReal32Fields.h> // VerticalLineDistance type
#include <OSGUInt8Fields.h> // Alignment type

#include <OSGAbstractTextFields.h>

OSG_BEGIN_NAMESPACE

class AbstractText;
class BinaryDataHandler;

//! \brief AbstractText Base Class.

class OSG_SYSTEMLIB_DLLMAPPING AbstractTextBase : public MaterialDrawable
{
  private:

    typedef MaterialDrawable    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef AbstractTextPtr  Ptr;

    enum
    {
        PositionFieldId             = Inherited::NextFieldId,
        FontFieldId                 = PositionFieldId             + 1,
        TextFieldId                 = FontFieldId                 + 1,
        VerticalLineDistanceFieldId = TextFieldId                 + 1,
        AlignmentFieldId            = VerticalLineDistanceFieldId + 1,
        NextFieldId                 = AlignmentFieldId            + 1
    };

    static const OSG::BitVector PositionFieldMask;
    static const OSG::BitVector FontFieldMask;
    static const OSG::BitVector TextFieldMask;
    static const OSG::BitVector VerticalLineDistanceFieldMask;
    static const OSG::BitVector AlignmentFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFVec3f             *getSFPosition       (void);
           SFSharedFontStyleWrapperPtr *getSFFont           (void);
           MFString            *getMFText           (void);
           SFReal32            *getSFVerticalLineDistance(void);
           SFUInt8             *getSFAlignment      (void);

           Vec3f               &getPosition       (void);
     const Vec3f               &getPosition       (void) const;
           SharedFontStyleWrapperPtr &getFont           (void);
     const SharedFontStyleWrapperPtr &getFont           (void) const;
           Real32              &getVerticalLineDistance(void);
     const Real32              &getVerticalLineDistance(void) const;
           UInt8               &getAlignment      (void);
     const UInt8               &getAlignment      (void) const;
           std::string         &getText           (const UInt32 index);
           MFString            &getText           (void);
     const MFString            &getText           (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setPosition       ( const Vec3f &value );
     void setFont           ( const SharedFontStyleWrapperPtr &value );
     void setVerticalLineDistance( const Real32 &value );
     void setAlignment      ( const UInt8 &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFVec3f             _sfPosition;
    SFSharedFontStyleWrapperPtr   _sfFont;
    MFString            _mfText;
    SFReal32            _sfVerticalLineDistance;
    SFUInt8             _sfAlignment;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    AbstractTextBase(void);
    AbstractTextBase(const AbstractTextBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~AbstractTextBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      AbstractTextBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      AbstractTextBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const AbstractTextBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef AbstractTextBase *AbstractTextBaseP;

typedef osgIF<AbstractTextBase::isNodeCore,
              CoredNodePtr<AbstractText>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet AbstractTextNodePtr;

typedef RefPtr<AbstractTextPtr> AbstractTextRefPtr;

OSG_END_NAMESPACE

#define OSGABSTRACTTEXTBASE_HEADER_CVSID "@(#)$Id: FCBaseTemplate_h.h,v 1.40 2005/07/20 00:10:14 vossg Exp $"

#endif /* _OSGABSTRACTTEXTBASE_H_ */
