/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class SHLChunk
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGSHLCHUNKBASE_H_
#define _OSGSHLCHUNKBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include <OSGSystemDef.h>

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGShaderChunk.h> // Parent

#include <OSGBoolFields.h> // CgFrontEnd type
#include <OSGBoolFields.h> // PointSize type
#include <OSGGLenumFields.h> // ProgramParameterNames type
#include <OSGUInt32Fields.h> // ProgramParameterValues type
#include <OSGUInt32Fields.h> // GLId type
#include <OSGInt32Fields.h> // IgnoreGLForAspect type

#include <OSGSHLChunkFields.h>

OSG_BEGIN_NAMESPACE

class SHLChunk;
class BinaryDataHandler;

//! \brief SHLChunk Base Class.

class OSG_SYSTEMLIB_DLLMAPPING SHLChunkBase : public ShaderChunk
{
  private:

    typedef ShaderChunk    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef SHLChunkPtr  Ptr;

    enum
    {
        CgFrontEndFieldId             = Inherited::NextFieldId,
        PointSizeFieldId              = CgFrontEndFieldId             + 1,
        ProgramParameterNamesFieldId  = PointSizeFieldId              + 1,
        ProgramParameterValuesFieldId = ProgramParameterNamesFieldId  + 1,
        GLIdFieldId                   = ProgramParameterValuesFieldId + 1,
        IgnoreGLForAspectFieldId      = GLIdFieldId                   + 1,
        NextFieldId                   = IgnoreGLForAspectFieldId      + 1
    };

    static const OSG::BitVector CgFrontEndFieldMask;
    static const OSG::BitVector PointSizeFieldMask;
    static const OSG::BitVector ProgramParameterNamesFieldMask;
    static const OSG::BitVector ProgramParameterValuesFieldMask;
    static const OSG::BitVector GLIdFieldMask;
    static const OSG::BitVector IgnoreGLForAspectFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFBool              *getSFCgFrontEnd     (void);
           SFBool              *getSFPointSize      (void);
           MFGLenum            *getMFProgramParameterNames(void);
           MFUInt32            *getMFProgramParameterValues(void);
           SFUInt32            *getSFGLId           (void);
           SFInt32             *getSFIgnoreGLForAspect(void);

           bool                &getCgFrontEnd     (void);
     const bool                &getCgFrontEnd     (void) const;
           bool                &getPointSize      (void);
     const bool                &getPointSize      (void) const;
           UInt32              &getGLId           (void);
     const UInt32              &getGLId           (void) const;
           Int32               &getIgnoreGLForAspect(void);
     const Int32               &getIgnoreGLForAspect(void) const;
           GLenum              &getProgramParameterNames(const UInt32 index);
           MFGLenum            &getProgramParameterNames(void);
     const MFGLenum            &getProgramParameterNames(void) const;
           UInt32              &getProgramParameterValues(const UInt32 index);
           MFUInt32            &getProgramParameterValues(void);
     const MFUInt32            &getProgramParameterValues(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setCgFrontEnd     ( const bool &value );
     void setPointSize      ( const bool &value );
     void setGLId           ( const UInt32 &value );
     void setIgnoreGLForAspect( const Int32 &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  SHLChunkPtr      create          (void); 
    static  SHLChunkPtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFBool              _sfCgFrontEnd;
    SFBool              _sfPointSize;
    MFGLenum            _mfProgramParameterNames;
    MFUInt32            _mfProgramParameterValues;
    SFUInt32            _sfGLId;
    SFInt32             _sfIgnoreGLForAspect;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    SHLChunkBase(void);
    SHLChunkBase(const SHLChunkBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~SHLChunkBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      SHLChunkBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      SHLChunkBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const SHLChunkBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef SHLChunkBase *SHLChunkBaseP;

typedef osgIF<SHLChunkBase::isNodeCore,
              CoredNodePtr<SHLChunk>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet SHLChunkNodePtr;

typedef RefPtr<SHLChunkPtr> SHLChunkRefPtr;

OSG_END_NAMESPACE

#define OSGSHLCHUNKBASE_HEADER_CVSID "@(#)$Id: OSGSHLChunkBase.h,v 1.14 2006/11/17 17:16:04 a-m-z Exp $"

#endif /* _OSGSHLCHUNKBASE_H_ */
