/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _OSGPHYSICSJOINT_H_
#define _OSGPHYSICSJOINT_H_
#ifdef __sgi
#pragma once
#endif

#include <OSGConfig.h>
#include <ode/ode.h>

#include <OSGPhysicsJointBase.h>

OSG_BEGIN_NAMESPACE

class  OSG_CONTRIBLIB_DLLMAPPING PhysicsJoint : public PhysicsJointBase
{
  private:

    typedef PhysicsJointBase Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

	  /*---------------------------------------------------------------------*/
	  /*! \name                   Class Specific Get Field                    */
	  /*! \{                                                                 */
	  dJointID getJointID(void);
	  /*! \}                                                                 */

	  /*---------------------------------------------------------------------*/
	  /*! \name                   Class Specific Set Field                    */
	  /*! \{                                                                 */
      void setJointID(const dJointID &value );
      void setFirstBody(const PhysicsBodyPtr &value );
      void setSecondBody(const PhysicsBodyPtr &value );
	  /*! \}                                                                 */

	  /*---------------------------------------------------------------------*/
	  /*! \name                   Class Specific                             */
	  /*! \{																*/
      void initJoint();
	  void attachTo( dBodyID body1, dBodyID body2 );
	  void setData( void* someData );
	  void* getData(void);
	  Int32 getJointType(void);
	  dBodyID getBody( Int32 );
	  // the raw feedback interface
	  void setFeedback( dJointFeedback* );
	  dJointFeedback* getFeedback(void);
	  //void getFeedback( Vec3f& force1, Vec3f& torque1,
		//  Vec3f& force2, Vec3f& torque2 );
	  /// set a joint parameter
	  virtual void setParam( Int32 param, Real32 value );
	  /// get a joint parameter
	  virtual Real32 getParam( Int32 param );
	  /*! \}                                                                 */


    /*---------------------------------------------------------------------*/
    /*! \name                      Sync                                    */
    /*! \{                                                                 */

    virtual void changed(BitVector  whichField, 
                         UInt32     origin    );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                     Output                                   */
    /*! \{                                                                 */

    virtual void dump(      UInt32     uiIndent = 0, 
                      const BitVector  bvFlags  = 0) const;

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    // Variables should all be in PhysicsJointBase.
    dJointID id;
    /*---------------------------------------------------------------------*/
    /*! \name                  Constructors                                */
    /*! \{                                                                 */

    PhysicsJoint(void);
    PhysicsJoint(const PhysicsJoint &source);

    /*! \}                                                                 */
	/*---------------------------------------------------------------------*/
	/*! \name                   Class Specific                             */
	/*! \{                                                                 */
	void onCreate(const PhysicsJoint *id = NULL);
	void onDestroy();
	/*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~PhysicsJoint(void); 

    /*! \}                                                                 */
    
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;
    friend class PhysicsJointBase;

    static void initMethod(void);

    // prohibit default functions (move to 'public' if you need one)

    void operator =(const PhysicsJoint &source);
};

typedef PhysicsJoint *PhysicsJointP;

OSG_END_NAMESPACE

#include <OSGPhysicsJointBase.inl>
#include <OSGPhysicsJoint.inl>

#define OSGPHYSICSJOINT_HEADER_CVSID "@(#)$Id: OSGPhysicsJoint.h,v 1.2 2006/08/19 00:21:46 dirk Exp $"

#endif /* _OSGPHYSICSJOINT_H_ */
