/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class BlendShapeDeformer!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEBLENDSHAPEDEFORMERINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGBlendShapeDeformerBase.h"
#include "OSGBlendShapeDeformer.h"


OSG_USING_NAMESPACE

const OSG::BitVector  BlendShapeDeformerBase::WeightFieldMask = 
    (TypeTraits<BitVector>::One << BlendShapeDeformerBase::WeightFieldId);

const OSG::BitVector  BlendShapeDeformerBase::VertexIndicesFieldMask = 
    (TypeTraits<BitVector>::One << BlendShapeDeformerBase::VertexIndicesFieldId);

const OSG::BitVector  BlendShapeDeformerBase::TargetIndicesFieldMask = 
    (TypeTraits<BitVector>::One << BlendShapeDeformerBase::TargetIndicesFieldId);

const OSG::BitVector  BlendShapeDeformerBase::TargetVerticesFieldMask = 
    (TypeTraits<BitVector>::One << BlendShapeDeformerBase::TargetVerticesFieldId);

const OSG::BitVector  BlendShapeDeformerBase::NormalIndicesFieldMask = 
    (TypeTraits<BitVector>::One << BlendShapeDeformerBase::NormalIndicesFieldId);

const OSG::BitVector  BlendShapeDeformerBase::NormalTargetIndicesFieldMask = 
    (TypeTraits<BitVector>::One << BlendShapeDeformerBase::NormalTargetIndicesFieldId);

const OSG::BitVector  BlendShapeDeformerBase::TargetNormalsFieldMask = 
    (TypeTraits<BitVector>::One << BlendShapeDeformerBase::TargetNormalsFieldId);

const OSG::BitVector BlendShapeDeformerBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Real32          BlendShapeDeformerBase::_mfWeight
    Weight of each target.
*/
/*! \var UInt32          BlendShapeDeformerBase::_mfVertexIndices
    Vertex indices to deform.
*/
/*! \var UInt16          BlendShapeDeformerBase::_mfTargetIndices
    Target index of vertex (into weight array).
*/
/*! \var Pnt3f           BlendShapeDeformerBase::_mfTargetVertices
    Target vertex offset.
*/
/*! \var UInt32          BlendShapeDeformerBase::_mfNormalIndices
    Normal indices to deform.
*/
/*! \var UInt16          BlendShapeDeformerBase::_mfNormalTargetIndices
    Target index of normal (into weight array).
*/
/*! \var Vec3f           BlendShapeDeformerBase::_mfTargetNormals
    Target normal offset.
*/

//! BlendShapeDeformer description

FieldDescription *BlendShapeDeformerBase::_desc[] = 
{
    new FieldDescription(MFReal32::getClassType(), 
                     "weight", 
                     WeightFieldId, WeightFieldMask,
                     false,
                     (FieldAccessMethod) &BlendShapeDeformerBase::getMFWeight),
    new FieldDescription(MFUInt32::getClassType(), 
                     "vertexIndices", 
                     VertexIndicesFieldId, VertexIndicesFieldMask,
                     false,
                     (FieldAccessMethod) &BlendShapeDeformerBase::getMFVertexIndices),
    new FieldDescription(MFUInt16::getClassType(), 
                     "targetIndices", 
                     TargetIndicesFieldId, TargetIndicesFieldMask,
                     false,
                     (FieldAccessMethod) &BlendShapeDeformerBase::getMFTargetIndices),
    new FieldDescription(MFPnt3f::getClassType(), 
                     "targetVertices", 
                     TargetVerticesFieldId, TargetVerticesFieldMask,
                     false,
                     (FieldAccessMethod) &BlendShapeDeformerBase::getMFTargetVertices),
    new FieldDescription(MFUInt32::getClassType(), 
                     "normalIndices", 
                     NormalIndicesFieldId, NormalIndicesFieldMask,
                     false,
                     (FieldAccessMethod) &BlendShapeDeformerBase::getMFNormalIndices),
    new FieldDescription(MFUInt16::getClassType(), 
                     "normalTargetIndices", 
                     NormalTargetIndicesFieldId, NormalTargetIndicesFieldMask,
                     false,
                     (FieldAccessMethod) &BlendShapeDeformerBase::getMFNormalTargetIndices),
    new FieldDescription(MFVec3f::getClassType(), 
                     "targetNormals", 
                     TargetNormalsFieldId, TargetNormalsFieldMask,
                     false,
                     (FieldAccessMethod) &BlendShapeDeformerBase::getMFTargetNormals)
};


FieldContainerType BlendShapeDeformerBase::_type(
    "BlendShapeDeformer",
    "Deformer",
    NULL,
    (PrototypeCreateF) &BlendShapeDeformerBase::createEmpty,
    BlendShapeDeformer::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(BlendShapeDeformerBase, BlendShapeDeformerPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &BlendShapeDeformerBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &BlendShapeDeformerBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr BlendShapeDeformerBase::shallowCopy(void) const 
{ 
    BlendShapeDeformerPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const BlendShapeDeformer *>(this)); 

    return returnValue; 
}

UInt32 BlendShapeDeformerBase::getContainerSize(void) const 
{ 
    return sizeof(BlendShapeDeformer); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void BlendShapeDeformerBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((BlendShapeDeformerBase *) &other, whichField);
}
#else
void BlendShapeDeformerBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((BlendShapeDeformerBase *) &other, whichField, sInfo);
}
void BlendShapeDeformerBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void BlendShapeDeformerBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfWeight.terminateShare(uiAspect, this->getContainerSize());
    _mfVertexIndices.terminateShare(uiAspect, this->getContainerSize());
    _mfTargetIndices.terminateShare(uiAspect, this->getContainerSize());
    _mfTargetVertices.terminateShare(uiAspect, this->getContainerSize());
    _mfNormalIndices.terminateShare(uiAspect, this->getContainerSize());
    _mfNormalTargetIndices.terminateShare(uiAspect, this->getContainerSize());
    _mfTargetNormals.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

BlendShapeDeformerBase::BlendShapeDeformerBase(void) :
    _mfWeight                 (), 
    _mfVertexIndices          (), 
    _mfTargetIndices          (), 
    _mfTargetVertices         (), 
    _mfNormalIndices          (), 
    _mfNormalTargetIndices    (), 
    _mfTargetNormals          (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

BlendShapeDeformerBase::BlendShapeDeformerBase(const BlendShapeDeformerBase &source) :
    _mfWeight                 (source._mfWeight                 ), 
    _mfVertexIndices          (source._mfVertexIndices          ), 
    _mfTargetIndices          (source._mfTargetIndices          ), 
    _mfTargetVertices         (source._mfTargetVertices         ), 
    _mfNormalIndices          (source._mfNormalIndices          ), 
    _mfNormalTargetIndices    (source._mfNormalTargetIndices    ), 
    _mfTargetNormals          (source._mfTargetNormals          ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

BlendShapeDeformerBase::~BlendShapeDeformerBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 BlendShapeDeformerBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (WeightFieldMask & whichField))
    {
        returnValue += _mfWeight.getBinSize();
    }

    if(FieldBits::NoField != (VertexIndicesFieldMask & whichField))
    {
        returnValue += _mfVertexIndices.getBinSize();
    }

    if(FieldBits::NoField != (TargetIndicesFieldMask & whichField))
    {
        returnValue += _mfTargetIndices.getBinSize();
    }

    if(FieldBits::NoField != (TargetVerticesFieldMask & whichField))
    {
        returnValue += _mfTargetVertices.getBinSize();
    }

    if(FieldBits::NoField != (NormalIndicesFieldMask & whichField))
    {
        returnValue += _mfNormalIndices.getBinSize();
    }

    if(FieldBits::NoField != (NormalTargetIndicesFieldMask & whichField))
    {
        returnValue += _mfNormalTargetIndices.getBinSize();
    }

    if(FieldBits::NoField != (TargetNormalsFieldMask & whichField))
    {
        returnValue += _mfTargetNormals.getBinSize();
    }


    return returnValue;
}

void BlendShapeDeformerBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (WeightFieldMask & whichField))
    {
        _mfWeight.copyToBin(pMem);
    }

    if(FieldBits::NoField != (VertexIndicesFieldMask & whichField))
    {
        _mfVertexIndices.copyToBin(pMem);
    }

    if(FieldBits::NoField != (TargetIndicesFieldMask & whichField))
    {
        _mfTargetIndices.copyToBin(pMem);
    }

    if(FieldBits::NoField != (TargetVerticesFieldMask & whichField))
    {
        _mfTargetVertices.copyToBin(pMem);
    }

    if(FieldBits::NoField != (NormalIndicesFieldMask & whichField))
    {
        _mfNormalIndices.copyToBin(pMem);
    }

    if(FieldBits::NoField != (NormalTargetIndicesFieldMask & whichField))
    {
        _mfNormalTargetIndices.copyToBin(pMem);
    }

    if(FieldBits::NoField != (TargetNormalsFieldMask & whichField))
    {
        _mfTargetNormals.copyToBin(pMem);
    }


}

void BlendShapeDeformerBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (WeightFieldMask & whichField))
    {
        _mfWeight.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (VertexIndicesFieldMask & whichField))
    {
        _mfVertexIndices.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (TargetIndicesFieldMask & whichField))
    {
        _mfTargetIndices.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (TargetVerticesFieldMask & whichField))
    {
        _mfTargetVertices.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (NormalIndicesFieldMask & whichField))
    {
        _mfNormalIndices.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (NormalTargetIndicesFieldMask & whichField))
    {
        _mfNormalTargetIndices.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (TargetNormalsFieldMask & whichField))
    {
        _mfTargetNormals.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void BlendShapeDeformerBase::executeSyncImpl(      BlendShapeDeformerBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (WeightFieldMask & whichField))
        _mfWeight.syncWith(pOther->_mfWeight);

    if(FieldBits::NoField != (VertexIndicesFieldMask & whichField))
        _mfVertexIndices.syncWith(pOther->_mfVertexIndices);

    if(FieldBits::NoField != (TargetIndicesFieldMask & whichField))
        _mfTargetIndices.syncWith(pOther->_mfTargetIndices);

    if(FieldBits::NoField != (TargetVerticesFieldMask & whichField))
        _mfTargetVertices.syncWith(pOther->_mfTargetVertices);

    if(FieldBits::NoField != (NormalIndicesFieldMask & whichField))
        _mfNormalIndices.syncWith(pOther->_mfNormalIndices);

    if(FieldBits::NoField != (NormalTargetIndicesFieldMask & whichField))
        _mfNormalTargetIndices.syncWith(pOther->_mfNormalTargetIndices);

    if(FieldBits::NoField != (TargetNormalsFieldMask & whichField))
        _mfTargetNormals.syncWith(pOther->_mfTargetNormals);


}
#else
void BlendShapeDeformerBase::executeSyncImpl(      BlendShapeDeformerBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);


    if(FieldBits::NoField != (WeightFieldMask & whichField))
        _mfWeight.syncWith(pOther->_mfWeight, sInfo);

    if(FieldBits::NoField != (VertexIndicesFieldMask & whichField))
        _mfVertexIndices.syncWith(pOther->_mfVertexIndices, sInfo);

    if(FieldBits::NoField != (TargetIndicesFieldMask & whichField))
        _mfTargetIndices.syncWith(pOther->_mfTargetIndices, sInfo);

    if(FieldBits::NoField != (TargetVerticesFieldMask & whichField))
        _mfTargetVertices.syncWith(pOther->_mfTargetVertices, sInfo);

    if(FieldBits::NoField != (NormalIndicesFieldMask & whichField))
        _mfNormalIndices.syncWith(pOther->_mfNormalIndices, sInfo);

    if(FieldBits::NoField != (NormalTargetIndicesFieldMask & whichField))
        _mfNormalTargetIndices.syncWith(pOther->_mfNormalTargetIndices, sInfo);

    if(FieldBits::NoField != (TargetNormalsFieldMask & whichField))
        _mfTargetNormals.syncWith(pOther->_mfTargetNormals, sInfo);


}

void BlendShapeDeformerBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (WeightFieldMask & whichField))
        _mfWeight.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (VertexIndicesFieldMask & whichField))
        _mfVertexIndices.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (TargetIndicesFieldMask & whichField))
        _mfTargetIndices.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (TargetVerticesFieldMask & whichField))
        _mfTargetVertices.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (NormalIndicesFieldMask & whichField))
        _mfNormalIndices.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (NormalTargetIndicesFieldMask & whichField))
        _mfNormalTargetIndices.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (TargetNormalsFieldMask & whichField))
        _mfTargetNormals.beginEdit(uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<BlendShapeDeformerPtr>::_type("BlendShapeDeformerPtr", "DeformerPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(BlendShapeDeformerPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(BlendShapeDeformerPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGBLENDSHAPEDEFORMERBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGBLENDSHAPEDEFORMERBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGBLENDSHAPEDEFORMERFIELDS_HEADER_CVSID;
}

