/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class CharacterModel
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGCHARACTERMODELBASE_H_
#define _OSGCHARACTERMODELBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include <OSGContribDef.h>

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGAttachmentContainer.h> // Parent

#include <OSGStringFields.h> // ConfigFile type
#include <OSGUInt32Fields.h> // NumAnimations type
#include <OSGSHLChunkFields.h> // Shader type
#include <OSGChunkMaterialFields.h> // Materials type

#include <OSGCharacterModelFields.h>

OSG_BEGIN_NAMESPACE

class CharacterModel;
class BinaryDataHandler;

//! \brief CharacterModel Base Class.

class OSG_CONTRIBLIB_DLLMAPPING CharacterModelBase : public AttachmentContainer
{
  private:

    typedef AttachmentContainer    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef CharacterModelPtr  Ptr;

    enum
    {
        ConfigFileFieldId    = Inherited::NextFieldId,
        NumAnimationsFieldId = ConfigFileFieldId    + 1,
        ShaderFieldId        = NumAnimationsFieldId + 1,
        MaterialsFieldId     = ShaderFieldId        + 1,
        NextFieldId          = MaterialsFieldId     + 1
    };

    static const OSG::BitVector ConfigFileFieldMask;
    static const OSG::BitVector NumAnimationsFieldMask;
    static const OSG::BitVector ShaderFieldMask;
    static const OSG::BitVector MaterialsFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFString            *getSFConfigFile     (void);
           SFUInt32            *getSFNumAnimations  (void);
           SFSHLChunkPtr       *getSFShader         (void);
           MFChunkMaterialPtr  *getMFMaterials      (void);

           std::string         &getConfigFile     (void);
     const std::string         &getConfigFile     (void) const;
           UInt32              &getNumAnimations  (void);
     const UInt32              &getNumAnimations  (void) const;
           SHLChunkPtr         &getShader         (void);
     const SHLChunkPtr         &getShader         (void) const;
           ChunkMaterialPtr    &getMaterials      (const UInt32 index);
           MFChunkMaterialPtr  &getMaterials      (void);
     const MFChunkMaterialPtr  &getMaterials      (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setConfigFile     ( const std::string &value );
     void setNumAnimations  ( const UInt32 &value );
     void setShader         ( const SHLChunkPtr &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  CharacterModelPtr      create          (void); 
    static  CharacterModelPtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFString            _sfConfigFile;
    SFUInt32            _sfNumAnimations;
    SFSHLChunkPtr       _sfShader;
    MFChunkMaterialPtr   _mfMaterials;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    CharacterModelBase(void);
    CharacterModelBase(const CharacterModelBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~CharacterModelBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      CharacterModelBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      CharacterModelBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const CharacterModelBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef CharacterModelBase *CharacterModelBaseP;

typedef osgIF<CharacterModelBase::isNodeCore,
              CoredNodePtr<CharacterModel>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet CharacterModelNodePtr;

typedef RefPtr<CharacterModelPtr> CharacterModelRefPtr;

OSG_END_NAMESPACE

#define OSGCHARACTERMODELBASE_HEADER_CVSID "@(#)$Id: OSGCharacterModelBase.h,v 1.2 2006/02/20 17:04:12 dirk Exp $"

#endif /* _OSGCHARACTERMODELBASE_H_ */
