CREATE TABLE `dialplan` (
  `id` int unsigned NOT NULL auto_increment,
  `dpid` int(11) NOT NULL,
  `pr` int(11) NOT NULL,
  `match_op` int(11) NOT NULL,
  `match_exp` varchar(64) NOT NULL,
  `match_len` int(11) NOT NULL,
  `subst_exp` varchar(64) default NULL,
  `repl_exp` varchar(32) NOT NULL,
  `attrs` varchar(32) default NULL,
  PRIMARY KEY (id)
);

insert into version values('dialplan',1);

-- example
INSERT INTO dialplan(dpid,pr,match_op,match_exp, match_len, subst_exp, repl_exp,attrs) VALUES (240,1,0,'112',3,NULL,'0040112',NULL),
(240,11,1,'^0[23][0-9]{8}',10,'^0(.+)','0040\\1',NULL),
(240,12,1,'^(+|00)[1-9][0-9]+',0,'^(+|00)(.+)','00\\2','h'),
(240,14,1,'^[1-9][0-9]{5}',6,'.+','0040240\\0',NULL),
(42,4,1,'abc(a+)(b*)',0,'abc(a+)(b*)','token1 \\1, token2 \\2','traa'),
(100,10,1,'^[1-9][0-9]{5}',6,'.+','0040240\\0',NULL),
(100,11,1,'^[1-9][0-9]{5}',6,'(.+)','\\1',NULL),
(42,2,1,'abcd{2}[0-5]{3}[a-z]{1}',9,'abc(d{2})([0-5]{3})[a-z]{1}','\\1\\2',''),
(100,9,1,'[a-z]{3}[0-9]+',0,'([a-z]{3})([0-9]+)','\\0\\1\\2','nm'),
(100,19,1,'[a-z]{3}[0-9]{2}',5,'([a-z]{3})([0-9]{2})','\\0\\1\\2',NULL),
(100,19,1,'[a-z]{3}[0-9]{4}',7,'([a-z]{3})([0-9]{2})([0-9]{2})','\\0\\1\\2',NULL),
(6,3,1,'[a-z]{3}',3,'.+','\\0',''),
(6,8,0,'nick',4,'.+','lol',''),
(5,9,0,'ank',3,'.+','tralala',''),
(8,4,0,'ank',3,'.+','ankutzel',''),
(45,1,1,'[0-9]{5}',5,'([0-9]{5})','0040\\0','none'),
(42,7,1,'[1-9][0-9]{6}',7,'([1-9])([0-9])([0-9])([0-9]{4})','\\0 and \\1 and \\2 and \\3 and \\4','attrs'),
(100,3,0,'ank',3,'','ankutz',''),
(100,2,1,'[a-z]{3}',3,'','ankutzel',''),
(100,6,0,'345',3,'.+','0040\\0','');
