/*
** Copyright (C) 2000 Alan McIvor <alan@mcivor.gen.nz>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

using namespace std;

#include "timeblock.h"

TimeBlock::TimeBlock(int start, int finish, Type type)
    : mStart(start), mFinish(finish), mType(type)
{
}

TimeBlock::~TimeBlock()
{
}


bool TimeBlock::overlap(int start, int finish) const
{
    if ( start <= mStart && mStart <= finish )
	return true;
    if ( start <= mFinish && mFinish <= finish )
	return true;
    if ( mStart <= start && start <= mFinish )
	return true;
    if ( mStart <= finish && finish <= mFinish )
	return true;
    return false;
}


TaskTimeBlock::TaskTimeBlock(RESOURCE *r, 
			     int start, 
			     int finish, 
			     Type type)
    : TimeBlock(start, finish, type), mResource(r)
{
}


ResourceTimeBlock::ResourceTimeBlock(TASK *t, 
				     int start, 
				     int finish, 
				     Type type)
    : TimeBlock(start, finish, type), mTask(t)
{
}

