/*      -*- OpenSAF  -*-
 *
 * (C) Copyright 2008 The OpenSAF Foundation
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. This file and program are licensed
 * under the GNU Lesser General Public License Version 2.1, February 1999.
 * The complete license can be accessed from the following location:
 * http://opensource.org/licenses/lgpl-license.php
 * See the Copying file included with the OpenSAF distribution for full
 * licensing terms.
 *
 * Author(s): Emerson Network Power
 *
 */

/*****************************************************************************
..............................................................................

  

..............................................................................

  DESCRIPTION:

  This module contains declarations that facilitate USRBUF usage. These uses
  were needed and developed in the context of SSS IE Encoding, though these
  services may well serve in many other contexts.
 
  NOTE: 
   This include and its corresponding ubuf_aid.c are put 'above' the sig
   directory since these services are not particular to any one sub-system.

******************************************************************************
*/

/*
 * Module Inclusion Control...
 */
#ifndef NCS_UBAID_H
#define NCS_UBAID_H

#include "ncsgl_defs.h"
#include "ncs_osprm.h"
#include "ncsusrbuf.h"
#include "ncs_mds_def.h"

#ifdef  __cplusplus
extern "C" {
#endif

/*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

   STRUCTURES, UNIONS and Derived Types

@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*/

/* NCS_UBAID is a collection of variables that are grouped for the benefit   */
/* of easy USRBUF management. It maintains the start as well as current     */
/* USRBUF. It also maintains where in the payload we are currently working  */
/* from, and how much space was reserved...                                 */

	typedef struct ncs_ubaid {
		/* ENC functions           DEC functions                 */
		   /*=======================+===============================*/
		USRBUF *start;	/* first usrbuf to fill    Not used                      */
		USRBUF *ub;	/* current usrbuf to fill  current usrbuf to consume     */
		uns8 *bufp;	/* inject info here        Not Used                      */
		int32 res;	/* space reserved          Not Used                      */
		int32 ttl;	/* total space claimed     total space consumed          */
		int32 max;	/* max we can encode       max we can decode             */
	} NCS_UBAID;

/*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

                      Prototypes

@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*/

/* Encode assist (member) functions */

	EXTERN_C LEAPDLL_API int32 ncs_enc_init_space(NCS_UBAID *uba);
	EXTERN_C LEAPDLL_API int32 ncs_enc_init_space_pp(NCS_UBAID *uba, uns8 pool_id, uns8 prio);
	EXTERN_C LEAPDLL_API void ncs_enc_prime_space(NCS_UBAID *uba, USRBUF *ub);
	EXTERN_C LEAPDLL_API uns8 *ncs_enc_reserve_space(NCS_UBAID *uba, int32 res);
	EXTERN_C LEAPDLL_API void ncs_enc_claim_space(NCS_UBAID *uba, int32 used);
	EXTERN_C LEAPDLL_API void ncs_enc_append_usrbuf(NCS_UBAID *uba, USRBUF *ub);
	EXTERN_C LEAPDLL_API uns32 ncs_encode_n_octets_in_uba(NCS_UBAID *uba, uns8 *os, unsigned int count);
	EXTERN_C LEAPDLL_API uns32 ncs_decode_n_octets_from_uba(NCS_UBAID *uba, uns8 *os, unsigned int count);

/* Decode assist (member) functions */

	EXTERN_C LEAPDLL_API void ncs_dec_init_space(NCS_UBAID *uba, USRBUF *ub);
	EXTERN_C LEAPDLL_API uns8 *ncs_dec_flatten_space(NCS_UBAID *uba, uns8 *os, int32 count);
	EXTERN_C LEAPDLL_API void ncs_dec_skip_space(NCS_UBAID *uba, int32 used);

/* These are used if the NCS_UBAID is used to track 'fit' issues */

	EXTERN_C LEAPDLL_API void ncs_set_max(NCS_UBAID *uba, int32 max);
	EXTERN_C LEAPDLL_API NCS_BOOL ncs_enc_can_i_put(NCS_UBAID *uba, int32 to_put);
	EXTERN_C LEAPDLL_API NCS_BOOL ncs_dec_can_i_get(NCS_UBAID *uba, int32 to_get);
	EXTERN_C LEAPDLL_API void ncs_reset_uba(NCS_UBAID *uba);

/***************************************************************\
      mds_encode_mds_dest: Encodes an MDS_DEST into a USRBUF. The
                           modified USRBUF pointer is returned
                           by this function (NULL if failure)

      mds_encode_mds_dest: Deodes an MDS_DEST from a USRBUF. The
                           modified USRBUF pointer is returned
                           by this function ((NULL if failure)

\***************************************************************/
	USRBUF *mds_encode_mds_dest(USRBUF *i_ub, MDS_DEST *i_mds_dest);
	USRBUF *mds_decode_mds_dest(USRBUF *i_ub, MDS_DEST *o_mds_dest);

/***************************************************************\
      mds_uba_encode_mds_dest: Encodes an MDS_DEST into a UBA.
                               Returns either NCSCC_RC_SUCCESS
                               or NCSCC_RC_FAILURE.

      mds_uba_decode_mds_dest: Deodes an MDS_DEST from a UBA.
                               Returns either NCSCC_RC_SUCCESS
                               or NCSCC_RC_FAILURE.

\***************************************************************/
	EXTERN_C LEAPDLL_API uns32 mds_uba_encode_mds_dest(NCS_UBAID *uba, MDS_DEST *i_mds_dest);
	EXTERN_C LEAPDLL_API uns32 mds_uba_decode_mds_dest(NCS_UBAID *uba, MDS_DEST *o_mds_dest);

	EXTERN_C LEAPDLL_API uns32 mds_st_encode_mds_dest(uns8 **stream, MDS_DEST *idest);
	EXTERN_C LEAPDLL_API uns32 mds_st_decode_mds_dest(uns8 **stream, MDS_DEST *odest);

/***************************************************************\
      ncs_encode_pointer: Encodes a pointer into a USRBUF. The
                           modified USRBUF pointer is returned
                           by this function (NULL if failure)
 
      ncs_decode_pointer: Deodes a pointer  from a USRBUF. The
                           modified USRBUF pointer is returned
                           by this function ((NULL if failure)
 
\***************************************************************/
	USRBUF *ncs_encode_pointer(USRBUF *i_ub, NCSCONTEXT i_pointer);
	USRBUF *ncs_decode_pointer(USRBUF *i_ub, uns64 *o_recvd_ptr, uns8 *o_ptr_size_in_bytes);

/***************************************************************\
      ncs_uba_encode_pointer: Encodes a pointer  into a UBA.
                               Returns either NCSCC_RC_SUCCESS
                               or NCSCC_RC_FAILURE.
 
      ncs_uba_decode_pointer: Deodes a pointer from a UBA.
                               Returns either NCSCC_RC_SUCCESS
                               or NCSCC_RC_FAILURE.
 
\***************************************************************/
	EXTERN_C LEAPDLL_API uns32 ncs_uba_encode_pointer(NCS_UBAID *uba, NCSCONTEXT i_pointer);
	EXTERN_C LEAPDLL_API uns32 ncs_uba_decode_pointer(NCS_UBAID *uba, uns64 *o_recvd_ptr,
							  uns8 *o_ptr_size_in_bytes);

#ifdef  __cplusplus
}
#endif

#endif
