'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: ch_xml_japanese_candlestick.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:28:15 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@sun.com
'*
'* short description : Check content.xml for attribute '<... chart:japanese-candle-stick = "true"|"false" ...>
'*
'*************************************************************************************************
'*
' #1 japaneseCandlestick
' #1 tJapaneseCandlestickChart
'*
'\*************************************************************************************************
sub japaneseCandlestick
  printLog Chr(13) + "---------  japanese candlestick chart  ----------"

     printlog "Testing 'Stock Chart 1'"
     call tJapaneseCandlestickChart("Type1")
     printlog "Testing 'Stock Chart 2'"
     call tJapaneseCandlestickChart("Type2")
     printlog "Testing 'Stock Chart 3'"
     call tJapaneseCandlestickChart("Type3")
     printlog "Testing 'Stock Chart 4'"
     call tJapaneseCandlestickChart("Type4")

end sub

'************************************************************
testcase tJapaneseCandlestickChart(sTypeNum as STRING)
'///<u><b>Check Value (true|false) of attribute 'chart:japanese-candle-stick' in Stock Charts Type 1-4</b></u>///

dim sIsJapaneseCandlestick as STRING
dim iIndex as INTEGER
dim sComfirmAttribute as STRING
dim sWarnAttribute as STRING
    select case sTypeNum
    case ("Type1") : sIsJapaneseCandlestick = "false"
                     iIndex = 1
                     sComfirmAttribute = "OK, 'Stock Chart 1' is no Japanese Candlestick Chart"
                     sWarnAttribute = "Unexpected value for attibute 'chart:japanese-candle-stick' in 'Stock Chart 1' -> Check this out!" 
    case ("Type2") : sIsJapaneseCandlestick = "true"
                     iIndex = 2
                     sComfirmAttribute = "OK, 'Stock Chart 2' is a Japanese Candlestick Chart"
                     sWarnAttribute = "Unexpected value for attibute 'chart:japanese-candle-stick' in 'Stock Chart 2' -> Check this out!" 
    case ("Type3") : sIsJapaneseCandlestick = "false"
                     iIndex = 3
                     sComfirmAttribute = "OK, 'Stock Chart 3' is no Japanese Candlestick Chart"
                     sWarnAttribute = "Unexpected value for attibute 'chart:japanese-candle-stick' in 'Stock Chart 3' -> Check this out!" 
    case ("Type4") : sIsJapaneseCandlestick = "true"
                     iIndex = 4
                     sComfirmAttribute = "OK, 'Stock Chart 4' is a Japanese Candlestick Chart"
                     sWarnAttribute = "Unexpected value for attibute 'chart:japanese-candle-stick' in 'Stock Chart 4' -> Check this out!" 
    end select

dim sOutputFile as STRING
    sOutputFile = (gOfficePath & ConvertPath("user\work\japaneseCandlestickType") & iIndex & Ext)
    
dim sUnpackedStorageDir as STRING
    sUnpackedStorageDir = (gOfficePath & ConvertPath("user\work\japaneseCandlestickType") & iIndex)
    if (dir(sUnpackedStorageDir) <> "") then
       kill (sUnpackedStorageDir)
    endif
    
dim sChartContentXML as STRING
    sChartContentXML = (gOfficePath & ConvertPath("user\work\japaneseCandlestickType") & iIndex & ConvertPath("\Object 1\content.xml"))
    
dim iSaxSeekIndex as INTEGER
    iSaxSeekIndex = 1
    
dim bContinueSeek as BOOLEAN
    bContinueSeek = TRUE
    
'///<ul>
'///<li>Open new document</li>///
    Call  hNewDocument
    printlog "Creating a test document for Stock Chart " & sTypeNum & "."
    '///<li>Add some random data</li>///
    Kontext "DocumentCalc"
    Kontext "RechenleisteCalc"
    if not RechenleisteCalc.isvisible then
       ViewToolbarsFormulaBar
    end if
    sleep(2)
    Kontext "RechenleisteCalc"
    Bereich.TypeKeys "<MOD1 A>"
    Bereich.TypeKeys "A1:F10"
    sleep(1)
    Bereich.TypeKeys "<RETURN>"
    sleep(2)
    Kontext "DocumentCalc"
    DocumentCalc.typekeys("=rand()<SHIFT MOD1 RETURN>")
      
    '///<li>Insert chart from data</li>///
    InsertChartCalc
    sleep(2)
    Kontext "AutoFormatDiagrammBeginn"
    '///<li>+ Click NEXT button</li>///
      Weiter.Click
    Kontext "AutoFormatDiagramm2"
    '///<li>+ Select Type 'Stock Chart'</li>///
      Diagrammtyp.typekeys("<HOME>")
      Diagrammtyp.typekeys("<RIGHT>", 7)
      '///<li>+ Click NEXT button</li>///
      Weiter.Click
    Kontext "AutoFormatDiagramm3"
      '///<li>+ Select Type 1-4 depending on test cycle</li>///
      Variante.typekeys("<HOME>")
      Variante.typekeys("<RIGHT>",(iIndex - 1))
      '///<li>+ Click CREATE button</li>///
      Fertigstellen.Click
    sleep(2)
    '///<li>Save document ...</li>///
    printlog "Save document using native file format."
    if hSpeichernUnterMitFilterKill (sOutputFile , gCalcFilter) = FALSE then
       warnlog "Saving " & sOutputFile & " failed! -> Exiting test!"
       call hCloseDocument
    else
       '///<li>... and close</li>///
       call hCloseDocument
       sleep(3)
       '///<li>Unpack storage to obtain the XML files</li>///
       printlog "Unpack storage of test document."
       UnpackStorage(sOutputFile, sUnpackedStorageDir)
       printlog "Read the test documents DOM."
       '///<li>Read DOM of content.xml</li>///
       SAXReadFile(sChartContentXML)
       sleep(2)
       '///<li>Set the DOM pointer on element 'office:automatic-styles'</li>///
       printlog "Set the DOM pointer on element 'office:automatic-styles'"
       printlog "|-/"
       SAXSeekElement("/")
       printlog "  |-office:document-content"
       SAXSeekElement("office:document-content")
       printlog "    |-office:automatic-styles"
       SAXSeekElement("office:automatic-styles")
       '///<li>Seek in (all) elements 'style:style' ... </li>///
       printlog "Seek and check value of 'chart:japanese-candle-stick'"
       while SAXHasElement("style:style" , iSaxSeekIndex) AND bContinueSeek
             printlog "      |-style:style"
             SAXSeekElement("style:style" , iSaxSeekIndex)
	     '///<li>... for element 'style:chart-properties' and ... </li>///
             if SAXHasElement("style:chart-properties") then
                printlog "        |-style:chart-properties"
                SAXSeekElement("style:chart-properties")
		'///<li>... look for the attibute 'chart:japanese-candle-stick'</li>///
	        if SaxGetAttributeName(1) = "chart:japanese-candle-stick" then
	           printlog "Bingo, found attribute 'chart:japanese-candle-stick'"
		   '///<li>FOUND -> First check if 'chart:japanese-candle-stick' sits on the expected node</li>///
		   if iSaxSeekIndex <> 4 then
		      warnlog "Found 'chart:japanese-candle-stick' on an unexpected Node -> Check this out!"
		      qaErrorLog "TODO: Check if change of file format was announced!"
		      qaErrorLog "TODO: Modify test if change of file format was intended!"
		   endif
		   bContinueSeek = FALSE
		   '///<li>Then check correct value (true|false) of attribute 'chart:japanese-candle-stick'</li>///
		   printlog "Now check for expected value of 'chart:japanese-candle-stick'!"
		   if SAXGetAttributeValue("chart:japanese-candle-stick") = sIsJapaneseCandlestick then
                   '///<li>Print test result</li>///
		      printlog sComfirmAttribute
		   else
                      warnlog sWarnAttribute
                   endif
	         endif
                 SAXSeekElement(0)
             endif
             iSaxSeekIndex = iSaxSeekIndex + 1
             SAXSeekElement(0)
       wend
    endif
    '///<li>Throw warning if testcase didn't succeed at all!</li>///
    if bContinueSeek then
       warnlog "OOPS, attribute 'chart:japanese-candle-stick' wasn't found at all -> Check this out!"
    endif
    '///<li>Release DOM</li>///
    SAXRelease
'///</ul>
endcase

