'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_001_.inc,v $
'*
'*  $Revision: 1.38 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:27:31 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description :
'*
'\***********************************************************************

sub w_001_
    printLog Chr(13) + "--------- File Menu (w_001_.inc) ----------"

'   Call tFileNew
    Call tFileNewLabels
    Call tFileNewBusinessCards
    Call tFileOpen

    Call tFileClose
    Call tFileSave
    Call tFileSaveAll
    Call tFileSaveAs
    Call tFileSaveAsExport
    Call tFileSaveWithPassword
    Call tFileReload
    Call tFileVersions

    if gApplication = "WRITER" then
        Call tToolsXMLFilterSettings
    endif
    Call tFileExportAsPDF
'   Call tFileSendDocumentAsEmail
'   Call tFileSendAutoMail
    Call tFileSendCreateMasterDocument
    Call tFileSendCreateHTMLDocument
    Call tFileSendOutlineToPresentation
    Call tFileSendOutlineToClipboard
    Call tFileSendCreateAutoabstract
    Call tFileSendAutoabstractToPresentation

end sub

'-----------------------------------------------------------

testcase tFileNew
    printLog "- File / New"

    Call hNewDocument
    '/// Open new document ///

    FileNewFromTemplate
    Kontext "Neu"
    Zusaetze.Open

    Call DialogTest (Neu)
    Zusaetze.Close
    Neu.Cancel

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFileNewLabels
    Dim i as integer, x as integer, y as integer
    Dim sTypes as integer, vTypes as integer
    
    PrintLog "- File / New / Labels"
    if gApplication <> "WRITER" then
        printlog "Not in : " + gApplication
        goto endsub
    endif

    '/// Open Labels-dialog with File / New / Labels ///
    if hCreateLabels = False then goto endsub
    Sleep 5
    Call DialogTest (TabEtiketten)
    '/// Switch to Tabpage 'Labels' ///
    Sleep 5
    '/// <B>Check number of brands and types (see #i44801# for details)</B>
    For i = 1 to 2
        Select Case i
            Case 1
                Endlos.Check
                printlog "Continous is checked"
            Case 2
                Bogen.Check
                printlog "Sheet is checked"
        end select    
        '/// There should be 10 brands in list
        For x = 1 to Marke.GetItemCount 
            Marke.Select x
            printlog "- Brand: " & Marke.GetSelText
            sTypes = Typ.GetItemCount
            Select Case x
                Case 1:
                    '/// Avery/A4 should have 295 types in list if 'Sheet' is checked
                    '/// Avery/A4 should have 1 type in list if 'Continous' is checked
                    if i = 1 then vTypes = 1 else vTypes = 295
                Case 2:
                    '/// Avery A4/Asia should have 88 types in list if 'Sheet' is checked
                    '/// Avery A4/Asia should have 1 type in list if 'Continous' is checked
                    if i = 1 then vTypes = 1 else vTypes = 88    
                Case 3:
                    '/// Avery Lettersize should have 251 types in list if 'Sheet' is checked
                    '/// Avery Lettersize should have 45 types in list if 'Continous' is checked
                    if i = 1 then vTypes = 45 else vTypes = 251
                Case 4:
                    '/// Avery Zweckform should have 333 types in list if 'Sheet' is checked
                    '/// Avery Zweckform should have 67 types in list if 'Continous' is checked
                    if i = 1 then vTypes = 67 else vTypes = 333    
                Case 5:
                    '/// Herlitz should have 26 types in list if 'Sheet' is checked
                    '/// Herlitz should have 6 types in list if 'Continous' is checked
                    if i = 1 then vTypes = 6 else vTypes = 26    
                Case 6:
                    '/// Herma A4 should have 491 types in list if 'Sheet' is checked
                    '/// Herma A4 should have 1 type in list if 'Continous' is checked
                    if i = 1 then vTypes = 1 else vTypes = 491
                Case 7:
                    '/// Herma A5 should have 18 types in list if 'Sheet' is checked
                    '/// Herma A5 should have 1 type in list if 'Continous' is checked
                    if i = 1 then vTypes = 1 else vTypes = 18    
                Case 8:
                    '/// Herma endlos should have 1 type in list if 'Sheet' is checked
                    '/// Herma endlos should have 119 types in list if 'Continous' is checked
                    if i = 1 then vTypes = 119 else vTypes = 1
                Case 9:
                    '/// Leitz should have 13 types in list if 'Sheet' is checked
                    '/// Leitz should have 1 type in list if 'Continous' is checked
                    if i = 1 then vTypes = 1 else vTypes = 13
                Case 10:
                    '/// Sigel should have 20 types in list if 'Sheet' is checked
                    '/// Sigel should have 1 type in list if 'Continous' is checked
                    if i = 1 then vTypes = 1 else vTypes = 20    
                Case else: Warnlog "- There are more than 10 brands in list"
            end select            
            if sTypes <> vTypes then Warnlog "-  Not " & sTypes & " types in list but " & vTypes
            For y = 1 to Typ.GetItemCount
                Typ.Select y
                printlog "-  Type: " & Typ.GetSelText
            next y
        next x
    next i
    Sleep 1
    
    Kontext
    active.SetPage TabFormatEtiketten
    '/// Switch to Tabpage 'Format' ///

    wait 500
    Kontext "TabFormatEtiketten"
    Call DialogTest (TabFormatEtiketten)
    wait 500
    FormatSpeichern.Click
    '/// Click 'Save' ///

    Kontext "SaveLabelFormat"
    wait 500
    Call DialogTest (SaveLabelFormat)
    SaveLabelFormat.Cancel
    '/// Close dialog 'Save Label Format' ///
    Kontext "TabFormatEtiketten"
    Sleep 5

    Kontext
    active.SetPage TabDruckerEtiketten
    '/// Switch to Tabpage 'Options' ///
    wait 500
    Kontext "TabDruckerEtiketten"
    Call DialogTest (TabDruckerEtiketten)
    '/// Click pushbutton 'Setup' ///

    Sleep 2
    if gPlatgroup = "w95" or gPlatgroup = "wnt" then
        Einrichten.Click
        Sleep 2
        Kontext "DruckerEinrichten"
        if DruckerEinrichten.Exists then
            DruckerEinrichten.Cancel
        else
            Warnlog "No Default Printer!"
        endif
        Kontext "TabDruckerEtiketten"
    endif
    '/// Close printer-setup dialog ///
    Sleep 2
    '/// Check checkbox 'Synchronize contents' ///
    InhaltSynchronisieren.Check
    wait 500
    '/// Click 'New document' ///
    NeuesDok.Click
    Sleep 5
    Kontext "Active"
    if Active.Exists then
        try
            Active.Ok
        catch
            Active.Cancel
            Warnlog "Once Document has been opened, office asks to save it! BugID 89702"
        endcatch
    endif

    wait 500
    '/// Check if dialog 'Synchronize Labels' is up ///
    Kontext "EtikettenSynchronisieren"
    if EtikettenSynchronisieren.Exists then
        Call DialogTest ( EtikettenSynchronisieren )
        Synchronisieren.Click
        Sleep 2
    else
        Warnlog " Dialog to synchronize labels not up!"
    endif
    Sleep 5
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFileNewBusinessCards
    Dim i as integer, x as integer, y as integer
    Dim sTypes as integer, vTypes as integer
    Printlog "- File / New / Business Cards"
    if gApplication <> "WRITER" then
        printlog "Not in : " + gApplication
        goto endsub
    endif

    '/// Open Business Cards dialog with File / New / Business Cards ///
    if hCreateBusinessCards = False then goto endsub
    Kontext 
	Active.Setpage TabEtikettenMedium
	Kontext "TabEtikettenMedium"
	Call DialogTest (TabEtikettenMedium)
    '/// Switch to Tabpage 'Medium' ///
    Sleep 5
    '/// <B>Check number of brands and types (see #i44801# for details)</B>
    For i = 1 to 2
        Select Case i
            Case 1
                Endlos.Check
                printlog "Continous is checked"
            Case 2
                Bogen.Check
                printlog "Sheet is checked"
        end select    
        '/// There should be 10 brands in list
        For x = 1 to Marke.GetItemCount 
            Marke.Select x
            printlog "- Brand: " & Marke.GetSelText
            sTypes = Typ.GetItemCount
            Select Case x
                Case 1:
                    '/// Avery/A4 should have 295 types in list if 'Sheet' is checked
                    '/// Avery/A4 should have 1 type in list if 'Continous' is checked
                    if i = 1 then vTypes = 1 else vTypes = 295
                Case 2:
                    '/// Avery A4/Asia should have 88 types in list if 'Sheet' is checked
                    '/// Avery A4/Asia should have 1 type in list if 'Continous' is checked
                    if i = 1 then vTypes = 1 else vTypes = 88    
                Case 3:
                    '/// Avery Lettersize should have 251 types in list if 'Sheet' is checked
                    '/// Avery Lettersize should have 45 types in list if 'Continous' is checked
                    if i = 1 then vTypes = 45 else vTypes = 251
                Case 4:
                    '/// Avery Zweckform should have 333 types in list if 'Sheet' is checked
                    '/// Avery Zweckform should have 67 types in list if 'Continous' is checked
                    if i = 1 then vTypes = 67 else vTypes = 333    
                Case 5:
                    '/// Herlitz should have 26 types in list if 'Sheet' is checked
                    '/// Herlitz should have 6 types in list if 'Continous' is checked
                    if i = 1 then vTypes = 6 else vTypes = 26    
                Case 6:
                    '/// Herma A4 should have 491 types in list if 'Sheet' is checked
                    '/// Herma A4 should have 1 type in list if 'Continous' is checked
                    if i = 1 then vTypes = 1 else vTypes = 491
                Case 7:
                    '/// Herma A5 should have 18 types in list if 'Sheet' is checked
                    '/// Herma A5 should have 1 type in list if 'Continous' is checked
                    if i = 1 then vTypes = 1 else vTypes = 18    
                Case 8:
                    '/// Herma endlos should have 1 type in list if 'Sheet' is checked
                    '/// Herma endlos should have 119 types in list if 'Continous' is checked
                    if i = 1 then vTypes = 119 else vTypes = 1
                Case 9:
                    '/// Leitz should have 13 types in list if 'Sheet' is checked
                    '/// Leitz should have 1 type in list if 'Continous' is checked
                    if i = 1 then vTypes = 1 else vTypes = 13
                Case 10:
                    '/// Sigel should have 20 types in list if 'Sheet' is checked
                    '/// Sigel should have 1 type in list if 'Continous' is checked
                    if i = 1 then vTypes = 1 else vTypes = 20    
                Case else: Warnlog "- There are more than 10 brands in list"
            end select            
            if sTypes <> vTypes then Warnlog "-  Not " & sTypes & " types in list but " & vTypes
            For y = 1 to Typ.GetItemCount
                Typ.Select y
                printlog "-  Type: " & Typ.GetSelText
            next y
        next x
    next i
    Sleep 1
	Kontext
	Active.Setpage TabVisitenkarten
	Sleep 5
	'/// Switch to Tabpage 'Business Cards' ///

	Kontext "Active"
	if Active.GetRT = 304 then
		Warnlog Active.Gettext
		Active.Ok
	endif

	Kontext "TabVisitenkarten"
	for i = 1 to 20
		if Inhalt.IsVisible then
			Call DialogTest (TabVisitenkarten)
			i = 21
		else
			Sleep 1
		endif
	next i
		
    Sleep 1
    Kontext
    Active.Setpage TabPrivat
    wait 500
    Kontext "TabPrivat"
    Call DialogTest (TabPrivat)
    '/// Switch to Tabpage 'Private' ///

    Kontext
    Active.Setpage TabGeschaeft
    wait 500
    Kontext "TabGeschaeft"
    Call DialogTest (TabGeschaeft)
    '/// Switch to Tabpage 'Business' ///

    Kontext
    Active.Setpage TabFormatEtiketten
    wait 500
    Kontext "TabFormatEtiketten"
    Call DialogTest (TabFormatEtiketten)
    '/// Switch to Tabpage 'Format' ///
    wait 500
    FormatSpeichern.Click
    '/// Click pushbutton 'Save' ///

    Kontext "SaveLabelFormat"
    wait 500
    Call DialogTest (SaveLabelFormat)
    SaveLabelFormat.Cancel
    Kontext "TabFormatEtiketten"
    Sleep 5
    '/// Close upcoming dialog 'Save Label Format' ///

    Kontext
    Active.Setpage TabZusaetzeEtiketten
    wait 500
    Kontext "TabZusaetzeEtiketten"
    Call DialogTest (TabZusaetzeEtiketten)
    Einrichten.Click
    Sleep 2
    Kontext "DruckerEinrichten"
    if DruckerEinrichten.Exists then
        DruckerEinrichten.Cancel
    else
        Warnlog "No Default Printer!"
    endif

    Kontext "TabZusaetzeEtiketten"
    '/// Switch to Tabpage 'Options' ///
    wait 500
    InhaltSynchronisieren.Check
    '/// Check Checkbox 'Syncronize contents ///

    Sleep 2
    NeuesDok.Click
    '/// Click 'new Document' ///
    Sleep 5
    Kontext "Active"
    if Active.Exists then
        try
            Active.Ok
        catch
            Active.Cancel
            Warnlog "Once Document has been opened, office asks to save it! BugID 89702"
        endcatch
    endif

    wait 500
    Kontext "EtikettenSynchronisieren"
    '/// Check i dialog 'Syncronize Labels' is up ///
    if EtikettenSynchronisieren.Exists then
        Call DialogTest ( EtikettenSynchronisieren )
        Synchronisieren.Click
        Sleep 2
    else
        Warnlog "Dialog to synchronize Business Cards not up!"
    endif
    Sleep 5
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFileOpen
    printLog "- File / Open"

    '/// File / Open ///
    FileOpen
    Sleep 2
    if gUseSysDlg = False then
    '/// ///
    Kontext "OeffnenDlg"
    Call DialogTest ( OeffnenDlg )
        UebergeordneterOrdner.Click
        '/// Click 'Up one level' ///
        Sleep 1
        try
            Standard.Click
            '/// Click button 'Default directory' ///
        catch
            ExceptLog
        endcatch
        Sleep 1
        '/// Click Button 'New folder' ///
        if NeuerOrdner.IsVisible and NeuerOrdner.IsEnabled then
            NeuerOrdner.Click
            Sleep 1
            Kontext "NeuerOrdner"
            OrdnerName.SetText "TT_Test"
            '///Enter a folder name in upcoming dialog and click 'Cancel'  ///
            NeuerOrdner.Cancel
        else
            Warnlog "Unable to create new folder! (Button disabled)"
        endif
        Kontext "OeffnenDlg"
        OeffnenDlg.Cancel
        '/// Close File-Open-dialog with 'Cancel' ///
    endif
endcase

'-----------------------------------------------------------

testcase tFileClose
    PrintLog "- File/Close"

    Call hNewDocument
    '/// Open new document ///
    Call hTabelleEinfuegen
    '/// Insert a table ///

    wait 500
    FileClose
    '/// File / Close ///
    Kontext
    wait 500
    Active.Cancel
    '/// Cancel upcoming messagebox ///

    Sleep 2
    FileClose
    '/// again File / Close ///
    Kontext "Active"
    wait 500
    Active.Yes

    Sleep 2
    if gUSeSysDlg = False then
        '/// Click 'Cancel' in File-Save-Dialog ///
        Kontext "SpeichernDlg"
        if SpeichernDlg.Exists then
            SpeichernDlg.Cancel
        else
            Kontext "Active"
            if Active.Exists then
                Warnlog Active.Gettext
                Active.Ok
            else
                Warnlog "Dialog to Save document isn't up!"
            endif
        endif
    endif

    Sleep 2
    '/// Choose File / Close again ///
    FileClose
    Kontext
    wait 500
    '/// On upcoming messagebox click 'No' ///
    Active.No
    Sleep 2

endcase

'-----------------------------------------------------------

testcase tFileSave
    PrintLog "- File/Save"

    Call hNewDocument
    '/// Open new document ///

    Call hTabelleEinfuegen
    '/// Insert a table ///

    if gUseSysDlg = False then
        FileSave
        '/// Choose 'File / Save' ///
        Kontext "SpeichernDlg"
        Call DialogTest ( SpeichernDlg )
        '/// In File-Dialog click 'Up one level' ///
        UebergeordneterOrdner.Click
        Sleep 1
        try
            '/// Click 'Default directory' ///
            Standard.Click
        catch
            ExceptLog
        endcatch
        Sleep 1
        '/// Click 'Create New Folder '///
        if NeuerOrdner.IsVisible and NeuerOrdner.Exists then
            if NeuerOrdner.IsEnabled then
                NeuerOrdner.Click
                Kontext "NeuerOrdner"
                '/// Enter a foldername ///
                OrdnerName.SetText "TT_Test"
                '/// Close 'Create New Folder-dialog' with cancel ///
                NeuerOrdner.Cancel
            else
                Warnlog "Unable to creater new folder! (Button disabled)"
            endif
        else
            Warnlog "Unable to create new folder! (Button not found)"
        endif
        Kontext "SpeichernDlg"
        '/// Close File-Save-Dialog with Cancel ///
        SpeichernDlg.Cancel
    endif

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFileSaveAll
    PrintLog "- File / Save All"

    Call hNewDocument
    '/// Open new document ///

    Call hTabelleEinfuegen
    '/// Insert a table in document ///

    Call hNewDocument
    '/// Open a second document ///

    Call hTabelleEinfuegen
    '/// Insert a table in second document ///

    if gUSeSysDlg = False then
        '/// Choose File / Save all ///
        FileSaveAll
        Kontext "SpeichernDlg"
        Sleep 5
        '/// Cancel 1. upcoming Filedialog ///
        SpeichernDlg.Cancel

        Kontext "SpeichernDlg"
        '/// Cancel 2. upcoming Filedialog ///
        Sleep 5
        SpeichernDlg.Cancel

        Kontext "SpeichernDlg"
        Sleep 5
        if SpeichernDlg.Exists then SpeichernDlg.Cancel
    endif

    Sleep 3
    Call hCloseDocument
    '/// Close 1. active document ///

    Call hCloseDocument
    '/// Close 2. active document ///

endcase

'-----------------------------------------------------------

testcase tFileSaveAs
    PrintLog "- File / Save As"

    Call hNewDocument
    '/// Open new document ///

    if gUseSysDlg = False then
        FileSaveAs
        '/// Choose 'Fiole / Save as' ///
        Kontext "SpeichernDlg"
        Call DialogTest ( SpeichernDlg )
        UebergeordneterOrdner.Click
        '/// Click button 'Up one level' ///
        Sleep 1
        try
            '/// Click button 'Default Directory' ///
            Standard.Click
        catch
            ExceptLog
        endcatch
        Sleep 1
        '/// Click button 'Create Folder' ///
        if NeuerOrdner.IsVisible and NeuerOrdner.Exists then
            if NeuerOrdner.IsEnabled then
                NeuerOrdner.Click
                Kontext "NeuerOrdner"
                '/// Enter a foldername in upcoming dialog ///
                OrdnerName.SetText "TT_Test"
                '/// Close dialog with 'Cancel'///
                NeuerOrdner.Cancel
            else
                Warnlog "Unable to create new folder! (Button disabled)"
            endif
        else
            Warnlog "Unable to create new folder! (Button not found)"
        endif
        Kontext "SpeichernDlg"
        SpeichernDlg.Cancel
    endif

    Sleep 1
    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFileSaveAsExport
    Dim xExport as string, xExportFilter as string, CountDocu as integer
    PrintLog "- File / Save As / Export with MS-filter"

    Select Case gApplication
        Case "WRITER"
            xExport = Convertpath( gTesttoolpath + "writer\input\st1_1.sxw" )
            xExportFilter = "Microsoft Word 97/2000/XP (.doc)"
        Case else
            goto endsub
    end select
    Call hNewDocument
    '/// Open new document ///

    Sleep 2
    Call hDateiOeffnen(xExport)
    '/// Open document '..\writer\input\st1_1.sxw ///

    Sleep 5
    Call hSpeichernUnterMitFilterKill(Convertpath(gOfficepath + "user\work\ecksport.doc"), xExportFilter)
    '/// Select Save as .. and choose 'Microsoft Word 97/2000/XP' as export-filter /// Sleep 5

    CountDocu = 0
    Do Until GetDocumentCount = 1
        Call hCloseDocument
        CountDocu = CountDocu + 1
    Loop
    if CountDocu > 1 then
        QAErrorlog "#i42080#More than 1 document had to be closed!"
    endif
    
    '/// Close document
    Call hCloseDocument
    
endcase

'-----------------------------------------------------------

testcase tFileSaveWithPassword
    Dim DokumentPfad$, Datei$, sFile$, sFile2$
	
    Printlog "- File / Save with Password"
    Select Case gApplication
        Case "WRITER"
            sFile$ = "password.odt"
            sFile2$ = "password2.odt"
        Case "MASTERDOC"
            sFile$ = "password.odm"
            sFile2$ = "password2.odm"
        Case "HTMLDOKUMENT"
            printlog "Not in Writer/Web!"
            goto endsub
    end select

    Call hNewDocument
    '/// Open new document ///

    Call wDokSchreiben("This document will be saved with a password!")
    '/// Enter some text into document ///

    if gUseSysDlg = True then goto endsub
    Datei$ = ConvertPath ( gOfficePath + "user\work\" + sFile$ )
    if Dir (Datei$) <> "" then kill Datei$
	
    FileSaveAs
    '/// Choose File / Save as.. ///
    Kontext "SpeichernDlg"
    '/// enter destination and check 'Password' ///
    if Passwort.IsEnabled then
        Passwort.Check
    else
      Warnlog "- Not able to save with Password -> Checkbox is disabled! Maybe default-filter wrong!?"
      SpeichernDlg.Cancel
        Call hCloseDocument
        '/// if Checkbox is disabled the test stops here! ///
        goto endsub
    endif

    Dateiname.SetText Datei$
    Speichern.Click
    '/// Save your document ///
    Sleep 1
    Kontext "Active"
    if Active.Exists (1) then Active.Yes

    Sleep 2
    Kontext "Passwort"
    '/// Password dialog has to come up ///
    if Passwort.Exists then
        '/// Enter your password ///
        PasswortName.SetText "12345"
        '/// Re-Enter a wrong passwort ///
        PasswortBestaetigen.Settext "54321"
        Passwort.OK
        Sleep 2
    else
        Warnlog "- Password-Dialog not up !"
    endif

    Kontext "Active"
    Sleep 5
    '/// A messagebox has to come up, warns of wrong confirmation ///
    if Active.Exists(1) then
        Active.OK
    else
        Warnlog "Able to save document with wrong password"
    endif

    Kontext "Passwort"
    if Passwort.Exists then
        '/// Enter new password, and re-enter the same password ///
        PasswortName.SetText "12345"
        PasswortBestaetigen.SetText "12345"
        Passwort.OK
    else
        Warnlog "- Password-Dialog not up !"
    endif

    Sleep 2
    '/// Close the document ///
    FileClose
    Sleep 2
    '/// Open previous saved document ///
    Call hDateiOeffnen(Datei$)
    Sleep 1

    Kontext "PasswordFileOpen"
    '/// Enter a wrong password. ///
    if PasswordFileOpen.Exists then
        PasswortName.SetText "34567"
        PasswordFileOpen.OK
    else
        Warnlog "- Password-Dialog not up or Document couldn't be loaded!"
    endif

    '/// A messagebox has to come up, warns of wrong password ///
    Kontext "Active"
    Sleep 5
    if Not Active.Exists(1) then
        Warnlog "Able to load document with wrong password"
    else
        Active.OK
    endif

    Sleep 3
    '/// File / Open again your previous saved document ///
    Call hDateiOeffnen(Datei$)
    '/// Enter your password in password dialog ///
    Kontext "PasswordFileOpen"
    if PasswordFileOpen.Exists then
        PasswortName.SetText "12345"
        PasswordFileOpen.OK
    else
        Warnlog "- Password-Dialog not up!"
    endif

    Sleep 2

    Datei$ = ConvertPath ( gOfficePath + "user\work\" + sFile2$ )
    if Dir (Datei$) <> "" then kill Datei$
    '/// File / Save as ... ///
    FileSaveAs
    Kontext "SpeichernDlg"
    Dateiname.SetText Datei$
    if Not Passwort.IsChecked = True then
        Warnlog "#i36015#Checkbox 'Save with password' is not checked in file-dialog !"
        Passwort.Check
        SpeichernDlg.Cancel
    else
        Speichern.Click
        Kontext "Active"
        if Active.Exists(2) then Active.Yes
        '/// Click on 'Save' in file open dialog ///
        Kontext "Passwort"
        if Not Passwort.Exists(1) then
            Warnlog "Passworddialog is not coming up on saving document"
        else
            PasswortName.SetText "54321"
            PasswortBestaetigen.SetText "54321"
            Passwort.OK
            '/// The password dialog should come up ///
            Sleep 2
            FileClose
            '/// File / Close and open your document again ///
            Call hDateiOeffnen(Datei$)
            Sleep 1
            Kontext "PasswordFileOpen"
            '/// Now the passwort dialog should come up ///
            if Not PasswordFileOpen.Exists(2) then
                Warnlog "Passworddialog is not coming up on reload"
            else
                PasswortName.SetText "54321"
                PasswordFileOpen.OK
            endif
        endif
    endif
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFileReload
    Dim DokumentPfad$, Datei$,sFile$
	Dim WriterFilterExtension(10) as string, MasterDocFilterExtension(10) as string
	
	WriterFilterExtension() = hGetFilternameExtension ( "writer8" )
	MasterDocFilterExtension() = hGetFilternameExtension ( "writerglobal8" )

    PrintLog "- File / Reload"
    Select Case gApplication
        Case "WRITER"
            sFile$ = "reload." & WriterFilterExtension(0)
        Case "MASTERDOC"
            sFile$ = "reload." & MasterDocFilterExtension(0)
        Case "HTMLDOKUMENT"
            printlog "Not in Writer/Web!"
            goto endsub
    end select

    Call hNewDocument
    '/// Open new document ///

    Call wDokSchreiben("File -> Reload!")
    '/// Enter some text, save and close document ///
    Call hSpeichernUnterKill ( gOfficePath + "user\work\" + sFile$ )
    FileClose
    Kontext
    if MessageBox.Exists (1) then
        WarnLog "Messagebox after saving and closing : " + MessageBox.GetText
        MessageBox.Yes
    endif
    Sleep 2

    '/// Open previous saved document ///
    Call hDateiOeffnen ( gOfficePath + "user\work\" + sFile$ )
    '/// Insert a table in document ///
    Call hTabelleEinfuegen
    '/// File / Reload ///
    FileReload
    Sleep 1
    '/// Quit messagebox with 'No' ///
    Kontext "Active"
    Active.No
    Sleep 1

    FileReload
    '/// File / Reload again and quit messagebox with yes ///

    Sleep 2
    Kontext "Active"
    Active.Yes
    Sleep 2
    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFileVersions
    Dim sFile$, WriterFilterExtension(10) as string, MasterDocFilterExtension(10) as string

	WriterFilterExtension() = hGetFilternameExtension ( "writer8" )
	MasterDocFilterExtension() = hGetFilternameExtension ( "writerglobal8" )

	
    PrintLog "- File / Versions"
    Select Case gApplication
        Case "WRITER"
            sFile$ = "kann_weg." & WriterFilterExtension(0)
        Case "MASTERDOC"
            sFile$ = "kann_weg." & MasterDocFilterExtension(0)
        Case "HTMLDOKUMENT"
            printlog "Not in Writer/Web!"
            goto endsub
    end select

    Call hNewDocument
    '/// Open new document ///

    Call wDokSchreiben ("File version")
    '/// enter some text in documet and save it ///
    Call hSpeichernUnterKill(gOfficePath + "user\work\" + sFile$)
    Sleep 3

    try
        '/// Choose File / Versions ///
        FileVersions
    catch
        Warnlog "- File / Versions not accessible!"
        goto endsub
    endcatch

    Kontext "Versionen"
    Call DialogTest ( Versionen )
    Speichern.Click
    '/// In Version-dialog click 'Save New Version' ///
    Kontext "VersionskommentarEingeben"
    Call DialogTest ( VersionskommentarEingeben )
    VersionskommentarEingeben.Cancel
    '/// Cancel dialog 'Insert version comment' ///

    Kontext "Versionen"
    Versionen.Close
    '/// Close dialog ///
    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFileExportAsPDF
    PrintLog "- File / Export as PDF"
    if gApplication = "HTMLDOKUMENT" then goto endsub

    '/// Open new document ///
    Call hNewDocument

    Call wDokSchreiben ("Export as PDF")
    '/// Insert some text in document ///
    '/// File / Export as PDF ///
    FileExportAsPDF

    Kontext "ExportAsPDFDlg"
    '/// Enter a filename in Export dialog ///
    Dateiname.Settext gOfficePath + "user\work\test.pdf"
    Export.Click
    ' Maybe it exists then overwrite
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            try
                Active.Ok
                Warnlog Active.Gettext
            catch
                Active.Yes
            endcatch
        endif
    endif
    Wait 500
    '/// PDF-Options dialog should have been opened ///
    Kontext "AlienWarning"
    if AlienWarning.Exists then
        QAErrorlog "#i41983#Alien format warning when exporting as PDF"    
        AlienWarning.Ok
    endif
    
    wait 500
    
    Kontext "PDFOptions"
    if PDFOptions.Exists then
        Call DialogTest ( PDFOptions )
        '/// Close PDF-Options dialog ///
        PDFOptions.Cancel
    else
        Warnlog "PDF-Options dialog is not up!"
    endif

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFileSendDocumentAsEmail
    PrintLog "- File / Send / Document as eMail"

    Call hNewDocument
    '/// Open new document ///

    Call wDokSchreiben("Hallo, ich werde an eine Mail angehaengt")

    FileSendDocumentAsEmail
    Kontext "Active"
    if Active.Exists then
        Warnlog Active.GetText
        Active.OK
        Exit sub
    endif

    Kontext "TabSendAsEmail"
    Wait 500

    CloseIt.Click

    Kontext "Active"        ' Push 'Back to message'
    if Active.Exists then Active.Cancel
    Kontext "TabSendAsEmail"

    CloseIt.Click

    Kontext "Active"     ' Click 'Discard'
    if Active.Exists then Active.Click(201)

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFileSendAutoMail
    PrintLog "- File / Send / AutoMail"

    Call hNewDocument
    '/// Open new document ///

    FileSendAutoMail
    Kontext
    Active.Yes

    Kontext "Adressbuch"
    Adressbuch.Close

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFileSendCreateMasterDocument
    PrintLog "- File / Send / Create Masterdocument"
    if gApplication <> "WRITER" then
        printlog "Not in : " + gApplication
        goto endsub
    endif

    Call hNewDocument
    '/// Open new document ///
    Call wDokSchreiben("File -> Send -> Create Master Document")
    FileSendCreateMasterdocument
    '/// Choose File / Send /Create Master Document///
    Kontext "SendMasterDocument"

    SendMasterdocument.Cancel
    '/// Cancel File-Save-dialog ///
    Kontext "Active"
    if Active.Exists then Active.OK
    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFileSendCreateHTMLDocument
    PrintLog "- File / Send / Create HTML-Dokument"
    Select Case gApplication
        Case "WRITER"
            Call hNewDocument

        Case "MASTERDOC"
            Call hNewDocument
            '/// Open new document ///

        Case "HTMLDOKUMENT"
            printlog "Not in WriterWeb!"
            goto endsub
    end select
    FileSendCreateHTMLDocument
    '/// Choose File / Send / Create HTML-Document ///

    Kontext "SendHTMLDocument"
    '/// Cancel Filedialog ///
    SendHTMLDocument.Cancel
    Kontext "Active"
    if Active.Exists then Active.OK
    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFileSendOutlineToPresentation
    Dim sFile$
    PrintLog "- File / Send / Outline to Presentation"
    Select Case gApplication
        Case "WRITER"
            sFile$ = "htmltest.sxw"
        Case "MASTERDOC"
            sFile$ = "htmltest.sxg"
        Case "HTMLDOKUMENT"
            printlog "Not in Writer/Web!"
            goto endsub
    end select
    '/// Open file ( gTesttoolPath + "writer\input\" + htmltest.sxw ) ///
    Call hDateiOeffnen  ( gTesttoolPath + "writer\input\" + sFile$ )
    Kontext "Navigator"
    if Navigator.Exists then Navigator.Close
    Sleep 1
    Kontext "DocumentWriter"
    '/// File / Send / Outline to presentation ///
    try
        FileSendOutlineToPresentation
    catch
        Warnlog "#i38723#Unable to execute 'File -> Send -> Outline to Presentation'"
        Call hCloseDocument
        goto endsub
    endcatch
    Sleep 2

    Kontext "DocumentImpressOutlineView"
    if DocumentImpressOutlineView.Exists then
        DocumentImpressOutlineView.TypeKeys "<Mod1 Home>"
        DocumentImpressOutlineView.TypeKeys "<Shift End>"
        Sleep 1
        try
            EditCopy
            if GetClipboardText <> "Seite 1." then QAErrorlog "#i29453#Wrong Outline in Impress Outlinemode"
        catch
            QAErrorlog "#i47819#Send outline to presentation doesn't work correct."
        endcatch
    else
        WarnLog "Outlinemode comes not up!"
    endif

    '/// Close documents ///
    Call hCloseDocument
    Sleep 1
    Call hCloseDocument

endcase

'-----------------------------------------------------------

testcase tFileSendOutlineToClipboard
    Dim sFile$
    PrintLog "- File / Send / Outline to Clipboard"
    Select Case gApplication
        Case "WRITER"
            sFile$ = "htmltest.sxw"
        Case "MASTERDOC"
            sFile$ = "htmltest.sxg"
        Case "HTMLDOKUMENT"
            printlog "Not in Writer/Web!"
            goto endsub
    end select
    
    '/// Open file ( gTesttoolPath + "writer\input\" + htmltest.sxw ) ///
    Call hDateiOeffnen ( gTesttoolPath + "writer\input\" + sFile$ )
    Sleep 3
    '/// File / Send / Outline to Clipboard ///
    try
        FileSendOutlineToClipboard
    catch
        Warnlog "#i38723#Unable to execute 'File -> Send -> Outline to Clipboard'"
        Call hCloseDocument
        goto endsub
    endcatch
    
    Sleep 2
    Call hCloseDocument
    '/// Close active document ///

    Sleep 3
    Call hNewDocument
    '/// Open new document ///

    Sleep 1

    '/// Paste outline in new document ///
    EditPaste
    Call wDokSchreiben("<Up>", 6)
    Call wDokSchreiben("<Home><Shift End>")
    EditCopy
    if GetClipboardText <> "Seite 1." then QAErrorlog "#i29453#Wrong Outline in Impress Outlinemode"
    Sleep 1
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFileSendCreateAutoabstract
    Dim sFile$
    PrintLog "- File / Send / Create Autoabstract"
    Select Case gApplication
        Case "WRITER"
            sFile$ = "htmltest.sxw"
        Case "MASTERDOC"
            sFile$ = "htmltest.sxg"
        Case "HTMLDOKUMENT"
            printlog "Not in Writer/Web!"
            goto endsub
    end select

    '/// Open file ( gTesttoolPath + "writer\input\" + htmltest.sxw ) ///
    Call hDateiOeffnen  ( gTesttoolPath + "writer\input\" + sFile$ )
    Kontext "Navigator"
    if Navigator.Exists then Navigator.Close
    Sleep 2
    Kontext "DocumentWriter"
    '/// File / Send / Create Autoabstract ///
    try
        FileSendCreateAutoabstract
    catch
        Warnlog "#i38723#Unable to execute 'File -> Send -> Create Autoabstract'"
        Call hCloseDocument
        goto endsub
    endcatch
    
    Sleep 2
    Kontext "AutoAbstractErzeugen"
    AutoAbstractErzeugen.OK
    '/// Close upcoming dialog with 'Ok' ///
    Sleep 1
    Call wDokSchreiben("<Home><Up>", 10)
    Call wDokSchreiben("<Shift End>")
    try
        EditCopy
        Sleep 1
        if GetClipboardText <> "Seite 1." then QAErrorlog "#i29453#Wrong Outline in Impress Outlinemode"        
    catch
        QAErrorlog "#i47819#Empty autoabstract created"
    endcatch
    Sleep 1
    Call hCloseDocument
    '/// Close active document ///

    Sleep 2
    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFileSendAutoabstractToPresentation
    Dim sFile$
    PrintLog "- File / Send / Autoabstract to Presentation"
    Select Case gApplication
        Case "WRITER"
            sFile$ = "htmltest.sxw"
        Case "MASTERDOC"
            sFile$ = "htmltest.sxg"
        Case "HTMLDOKUMENT"
            printlog "Not in Writer/Web!"
            goto endsub
    end select

    '/// Open file ( gTesttoolPath + "writer\input\" + htmltest.sxw ) ///
    Call hDateiOeffnen  ( gTesttoolPath + "writer\input\" + sFile$ )
    Kontext "Navigator"
    if Navigator.Exists then Navigator.Close
    Sleep 1
    Kontext "DocumentWriter"
    '/// File / Send / Create Autoabstract To Presentation ///
    try
        FileSendAutoabstractToPresentation
    catch
        Warnlog "#i38723#Unable to execute 'File -> Send -> Autoabstract to Presentation'"
        Call hCloseDocument
        goto endsub
    endcatch
        
    Sleep 3
    Kontext "AutoAbstractErzeugen"
    Sleep 1
    '/// Close upcoming dialog with 'Ok' ///
    AutoAbstractErzeugen.OK

    Sleep 3

    Kontext "DocumentImpressOutlineView"
    Sleep 2
    if DocumentImpressOutlineView.Exists then
        ' Point cursor to beginning of document
        DocumentImpressOutlineView.TypeKeys "<Mod1 Home>"
        ' Mark text
        DocumentImpressOutlineView.TypeKeys "<Shift End>"
        try
            EditCopy
            Sleep 1
            if GetClipboardText <> "Seite 1." then QAErrorlog "#i29453#Wrong Outline in Impress Outlinemode"
        catch
            QAErrorlog "#i42310#Edit / copy disabled. Maybe data could not be pasted correctly!"
        endcatch
    else
        Warnlog "- Outline in Impress not created!"
    endif
    Sleep 2
    Call hCloseDocument
    '/// Close active document ///

    Call wDocSetContext
    FileClose
endcase
